/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.plotsquared.google.Binding;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.spi.ProvisionListener;
import java.util.LinkedHashSet;
import java.util.List;

final class ProvisionListenerStackCallback<T> {
    private static final ProvisionListener[] EMPTY_LISTENER = new ProvisionListener[0];
    private static final ProvisionListenerStackCallback<?> EMPTY_CALLBACK = new ProvisionListenerStackCallback(null, (List<ProvisionListener>)ImmutableList.of());
    private final ProvisionListener[] listeners;
    private final Binding<T> binding;

    public static <T> ProvisionListenerStackCallback<T> emptyListener() {
        return EMPTY_CALLBACK;
    }

    public ProvisionListenerStackCallback(Binding<T> binding, List<ProvisionListener> list) {
        this.binding = binding;
        if (list.isEmpty()) {
            this.listeners = EMPTY_LISTENER;
        } else {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(list);
            this.listeners = linkedHashSet.toArray(new ProvisionListener[linkedHashSet.size()]);
        }
    }

    public boolean hasListeners() {
        return this.listeners.length > 0;
    }

    public T provision(InternalContext internalContext, ProvisionCallback<T> provisionCallback) {
        Provision provision = new Provision(provisionCallback);
        RuntimeException runtimeException = null;
        try {
            provision.provision();
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        if (provision.exceptionDuringProvision != null) {
            throw provision.exceptionDuringProvision;
        }
        if (runtimeException != null) {
            String string = provision.erredListener != null ? provision.erredListener.getClass() : "(unknown)";
            throw InternalProvisionException.errorInUserCode(ErrorId.OTHER, runtimeException, "Error notifying ProvisionListener %s of %s.\n Reason: %s", string, this.binding.getKey(), runtimeException);
        }
        return provision.result;
    }

    private class Provision
    extends ProvisionListener.ProvisionInvocation<T> {
        final ProvisionCallback<T> callable;
        int index = -1;
        T result;
        InternalProvisionException exceptionDuringProvision;
        ProvisionListener erredListener;

        public Provision(ProvisionCallback<T> provisionCallback) {
            this.callable = provisionCallback;
        }

        @Override
        public T provision() {
            ++this.index;
            if (this.index == ProvisionListenerStackCallback.this.listeners.length) {
                try {
                    this.result = this.callable.call();
                }
                catch (InternalProvisionException internalProvisionException) {
                    this.exceptionDuringProvision = internalProvisionException;
                    throw internalProvisionException.toProvisionException();
                }
            }
            if (this.index < ProvisionListenerStackCallback.this.listeners.length) {
                int n = this.index;
                try {
                    ProvisionListenerStackCallback.this.listeners[this.index].onProvision(this);
                }
                catch (RuntimeException runtimeException) {
                    this.erredListener = ProvisionListenerStackCallback.this.listeners[n];
                    throw runtimeException;
                }
                if (n == this.index) {
                    this.provision();
                }
            } else {
                throw new IllegalStateException("Already provisioned in this listener.");
            }
            return this.result;
        }

        @Override
        public Binding<T> getBinding() {
            return ProvisionListenerStackCallback.this.binding;
        }
    }

    public static interface ProvisionCallback<T> {
        public T call() throws InternalProvisionException;
    }
}

