/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.core.aopalliance.intercept.MethodInterceptor;
import com.plotsquared.google.internal.BytecodeGen;
import com.plotsquared.google.internal.ConstructionProxy;
import com.plotsquared.google.internal.ConstructionProxyFactory;
import com.plotsquared.google.internal.DefaultConstructionProxyFactory;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InterceptorStackCallback;
import com.plotsquared.google.internal.MethodAspect;
import com.plotsquared.google.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private static final Logger logger = Logger.getLogger(ProxyFactory.class.getName());
    private final InjectionPoint injectionPoint;
    private final Function<String, BiFunction<Object, Object[], Object>> enhancer;
    private final ImmutableMap<Method, List<MethodInterceptor>> interceptors;
    private final InvocationHandler[] callbacks;

    ProxyFactory(InjectionPoint injectionPoint, Iterable<MethodAspect> iterable) {
        Method method;
        int n;
        this.injectionPoint = injectionPoint;
        Class<?> clazz = injectionPoint.getMember().getDeclaringClass();
        ArrayList arrayList = Lists.newArrayList();
        for (MethodAspect methodArray2 : iterable) {
            if (!methodArray2.matches(clazz)) continue;
            arrayList.add(methodArray2);
        }
        if (arrayList.isEmpty()) {
            this.enhancer = null;
            this.interceptors = ImmutableMap.of();
            this.callbacks = null;
            return;
        }
        BytecodeGen.EnhancerBuilder enhancerBuilder = BytecodeGen.enhancerBuilder(clazz);
        Method[] methodArray = enhancerBuilder.getEnhanceableMethods();
        int n2 = methodArray.length;
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        BitSet bitSet = new BitSet();
        for (MethodAspect n3 : arrayList) {
            for (n = 0; n < n2; ++n) {
                method = methodArray[n];
                if (!n3.matches(method)) continue;
                if (method.isSynthetic()) {
                    logger.log(Level.WARNING, "Method [{0}] is synthetic and is being intercepted by {1}. This could indicate a bug.  The method may be intercepted twice, or may not be intercepted at all.", new Object[]{method, n3.interceptors()});
                }
                arrayListMultimap.putAll((Object)method, n3.interceptors());
                bitSet.set(n);
            }
        }
        if (bitSet.isEmpty()) {
            this.enhancer = null;
            this.interceptors = ImmutableMap.of();
            this.callbacks = null;
            return;
        }
        try {
            this.enhancer = enhancerBuilder.buildEnhancer(bitSet);
        }
        catch (Throwable throwable) {
            throw new Errors().errorEnhancingClass(clazz, throwable).toException();
        }
        this.callbacks = new InvocationHandler[bitSet.cardinality()];
        ImmutableMap.Builder throwable = ImmutableMap.builder();
        int n3 = 0;
        n = bitSet.nextSetBit(0);
        while (n >= 0) {
            method = methodArray[n];
            ImmutableList immutableList = ImmutableSet.copyOf((Collection)arrayListMultimap.get((Object)method)).asList();
            throwable.put((Object)method, (Object)immutableList);
            BiFunction<Object, Object[], Object> biFunction = BytecodeGen.superMethod(this.enhancer, method);
            this.callbacks[n3++] = new InterceptorStackCallback(method, (List<MethodInterceptor>)immutableList, biFunction);
            n = bitSet.nextSetBit(n + 1);
        }
        this.interceptors = throwable.buildOrThrow();
    }

    public ImmutableMap<Method, List<MethodInterceptor>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public ConstructionProxy<T> create() {
        if (this.interceptors.isEmpty()) {
            return new DefaultConstructionProxyFactory(this.injectionPoint).create();
        }
        try {
            return new ProxyConstructor(this.injectionPoint, this.enhancer, this.interceptors, this.callbacks);
        }
        catch (Throwable throwable) {
            throw new Errors().errorEnhancingClass(this.injectionPoint.getMember().getDeclaringClass(), throwable).toException();
        }
    }

    private static class ProxyConstructor<T>
    implements ConstructionProxy<T> {
        final InjectionPoint injectionPoint;
        final Constructor<T> constructor;
        final BiFunction<Object, Object[], Object> enhancedConstructor;
        final ImmutableMap<Method, List<MethodInterceptor>> interceptors;
        final InvocationHandler[] callbacks;

        ProxyConstructor(InjectionPoint injectionPoint, Function<String, BiFunction<Object, Object[], Object>> function, ImmutableMap<Method, List<MethodInterceptor>> immutableMap, InvocationHandler[] invocationHandlerArray) {
            this.injectionPoint = injectionPoint;
            this.constructor = (Constructor)injectionPoint.getMember();
            this.enhancedConstructor = BytecodeGen.enhancedConstructor(function, this.constructor);
            this.interceptors = immutableMap;
            this.callbacks = invocationHandlerArray;
        }

        @Override
        public T newInstance(Object ... objectArray) {
            return (T)this.enhancedConstructor.apply(this.callbacks, objectArray);
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        @Override
        public ImmutableMap<Method, List<MethodInterceptor>> getMethodInterceptors() {
            return this.interceptors;
        }
    }
}

