/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.ProvisionException;
import com.plotsquared.google.Scope;
import com.plotsquared.google.Scopes;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.CycleDetectingLock;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProviderToInternalFactoryAdapter;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Message;
import java.util.Formatter;
import java.util.List;

public class SingletonScope
implements Scope {
    private static final Object NULL = new Object();
    private static final CycleDetectingLock.CycleDetectingLockFactory<Key<?>> cycleDetectingLockFactory = new CycleDetectingLock.CycleDetectingLockFactory();

    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> provider) {
        return new Provider<T>(this){
            volatile Object instance;
            final ConstructionContext<T> constructionContext = new ConstructionContext();
            final CycleDetectingLock<Key<?>> creationLock = SingletonScope.access$000().create(key);
            @Nullable
            final InjectorImpl injector = provider instanceof ProviderToInternalFactoryAdapter ? ((ProviderToInternalFactoryAdapter)provider).getInjector() : null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public T get() {
                var1_1 = this.instance;
                if (var1_1 == null) {
                    var2_2 = this.injector == null ? null : this.injector.getLocalContext();
                    var3_4 = this.creationLock.lockOrDetectPotentialLocksCycle();
                    if (var3_4.isEmpty()) {
                        try {
                            if (this.instance != null) ** GOTO lbl54
                            var4_5 = provider.get();
                            v0 = var5_7 = var4_5 == null ? SingletonScope.access$100() : var4_5;
                            if (this.instance == null) {
                                if (Scopes.isCircularProxy(var4_5)) {
                                    var6_9 = var4_5;
                                    return (T)var6_9;
                                }
                                var6_10 = this.constructionContext;
                                synchronized (var6_10) {
                                    this.instance = var5_7;
                                    this.constructionContext.setProxyDelegates(var4_5);
                                }
                            }
                            Preconditions.checkState((boolean)(this.instance == var5_7), (Object)"Singleton is called recursively returning different results");
                        }
                        catch (RuntimeException var4_6) {
                            var5_7 = this.constructionContext;
                            synchronized (var5_7) {
                                this.constructionContext.finishConstruction();
                            }
                            throw var4_6;
                        }
                        finally {
                            this.creationLock.unlock();
                        }
                    } else {
                        if (var2_2 == null) {
                            throw new ProvisionException((Iterable<Message>)ImmutableList.of((Object)this.createCycleDependenciesMessage(var3_4, null)));
                        }
                        var4_5 = this.constructionContext;
                        synchronized (var4_5) {
                            if (this.instance == null) {
                                var5_8 = (Dependency)Preconditions.checkNotNull(var2_2.getDependency(), (Object)"internalContext.getDependency()");
                                var6_11 = var5_8.getKey().getTypeLiteral().getRawType();
                                try {
                                    var7_13 = this.constructionContext.createProxy(var2_2.getInjectorOptions(), var6_11);
                                    return (T)var7_13;
                                }
                                catch (InternalProvisionException var7_14) {
                                    var8_16 = (Message)Iterables.getOnlyElement(var7_14.getErrors());
                                    var9_18 = this.createCycleDependenciesMessage(var3_4, var8_16);
                                    throw new ProvisionException((Iterable<Message>)ImmutableList.of((Object)var9_18, (Object)var8_16));
                                }
                            }
                        }
                    }
lbl54:
                    // 4 sources

                    var4_5 = this.instance;
                    Preconditions.checkState((boolean)(var4_5 != null), (Object)"Internal error: Singleton is not initialized contrary to our expectations");
                    var5_7 = var4_5;
                    return (T)(var4_5 == SingletonScope.access$100() ? null : var5_7);
                }
                var2_3 = var1_1;
                return (T)(var1_1 == SingletonScope.access$100() ? null : var2_3);
            }

            private Message createCycleDependenciesMessage(ListMultimap<Thread, Key<?>> listMultimap, @Nullable Message message) {
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder);
                formatter.format("Encountered circular dependency spanning several threads.", new Object[0]);
                if (message != null) {
                    formatter.format(" %s", message.getMessage());
                }
                formatter.format("\n", new Object[0]);
                for (Thread thread : listMultimap.keySet()) {
                    List list = listMultimap.get((Object)thread);
                    formatter.format("%s is holding locks the following singletons in the cycle:\n", thread);
                    for (Key key2 : list) {
                        formatter.format("%s\n", Errors.convert(key2));
                    }
                    for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                        formatter.format("\tat %s\n", stackTraceElement);
                    }
                }
                formatter.close();
                return new Message(Thread.currentThread(), stringBuilder.toString());
            }

            public String toString() {
                return String.format("%s[%s]", provider, Scopes.SINGLETON);
            }
        };
    }

    @Override
    public String toString() {
        return "Scopes.SINGLETON";
    }

    static /* synthetic */ CycleDetectingLock.CycleDetectingLockFactory access$000() {
        return cycleDetectingLockFactory;
    }

    static /* synthetic */ Object access$100() {
        return NULL;
    }
}

