/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.matcher.AbstractMatcher;
import com.plotsquared.google.matcher.Matcher;
import com.plotsquared.google.matcher.Matchers;
import com.plotsquared.google.spi.TypeConverter;
import com.plotsquared.google.spi.TypeConverterBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

final class TypeConverterBindingProcessor
extends AbstractProcessor {
    TypeConverterBindingProcessor(Errors errors) {
        super(errors);
    }

    static void prepareBuiltInConverters(InjectorImpl injectorImpl) {
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Integer.TYPE, Integer.class);
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Long.TYPE, Long.class);
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Boolean.TYPE, Boolean.class);
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Byte.TYPE, Byte.class);
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Short.TYPE, Short.class);
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Float.TYPE, Float.class);
        TypeConverterBindingProcessor.convertToPrimitiveType(injectorImpl, Double.TYPE, Double.class);
        TypeConverterBindingProcessor.convertToClass(injectorImpl, Character.class, new TypeConverter(){

            @Override
            public Object convert(String string, TypeLiteral<?> typeLiteral) {
                if ((string = string.trim()).length() != 1) {
                    throw new RuntimeException("Length != 1.");
                }
                return Character.valueOf(string.charAt(0));
            }

            public String toString() {
                return "TypeConverter<Character>";
            }
        });
        TypeConverterBindingProcessor.convertToClasses(injectorImpl, Matchers.subclassesOf(Enum.class), new TypeConverter(){

            @Override
            public Object convert(String string, TypeLiteral<?> typeLiteral) {
                return Enum.valueOf(typeLiteral.getRawType(), string);
            }

            public String toString() {
                return "TypeConverter<E extends Enum<E>>";
            }
        });
        TypeConverterBindingProcessor.internalConvertToTypes(injectorImpl, new AbstractMatcher<TypeLiteral<?>>(){

            @Override
            public boolean matches(TypeLiteral<?> typeLiteral) {
                return typeLiteral.getRawType() == Class.class;
            }

            public String toString() {
                return "Class<?>";
            }
        }, new TypeConverter(){

            @Override
            public Object convert(String string, TypeLiteral<?> typeLiteral) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException.getMessage());
                }
            }

            public String toString() {
                return "TypeConverter<Class<?>>";
            }
        });
    }

    private static <T> void convertToPrimitiveType(InjectorImpl injectorImpl, Class<T> clazz, final Class<T> clazz2) {
        try {
            final Method method = clazz2.getMethod("parse" + TypeConverterBindingProcessor.capitalize(clazz.getName()), String.class);
            TypeConverter typeConverter = new TypeConverter(){

                @Override
                public Object convert(String string, TypeLiteral<?> typeLiteral) {
                    try {
                        return method.invoke(null, string);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new RuntimeException(invocationTargetException.getTargetException().getMessage());
                    }
                }

                public String toString() {
                    return "TypeConverter<" + clazz2.getSimpleName() + ">";
                }
            };
            TypeConverterBindingProcessor.convertToClass(injectorImpl, clazz2, typeConverter);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private static <T> void convertToClass(InjectorImpl injectorImpl, Class<T> clazz, TypeConverter typeConverter) {
        TypeConverterBindingProcessor.convertToClasses(injectorImpl, Matchers.identicalTo(clazz), typeConverter);
    }

    private static void convertToClasses(InjectorImpl injectorImpl, final Matcher<? super Class<?>> matcher, TypeConverter typeConverter) {
        TypeConverterBindingProcessor.internalConvertToTypes(injectorImpl, new AbstractMatcher<TypeLiteral<?>>(){

            @Override
            public boolean matches(TypeLiteral<?> typeLiteral) {
                Type type = typeLiteral.getType();
                if (!(type instanceof Class)) {
                    return false;
                }
                Class clazz = (Class)type;
                return matcher.matches(clazz);
            }

            public String toString() {
                return matcher.toString();
            }
        }, typeConverter);
    }

    private static void internalConvertToTypes(InjectorImpl injectorImpl, Matcher<? super TypeLiteral<?>> matcher, TypeConverter typeConverter) {
        injectorImpl.getBindingData().addConverter(new TypeConverterBinding(SourceProvider.UNKNOWN_SOURCE, matcher, typeConverter));
    }

    @Override
    public Boolean visit(TypeConverterBinding typeConverterBinding) {
        this.injector.getBindingData().addConverter(new TypeConverterBinding(typeConverterBinding.getSource(), typeConverterBinding.getTypeMatcher(), typeConverterBinding.getTypeConverter()));
        return true;
    }

    private static String capitalize(String string) {
        char c;
        if (string.length() == 0) {
            return string;
        }
        char c2 = string.charAt(0);
        return c2 == (c = Character.toUpperCase(c2)) ? string : c + string.substring(1);
    }
}

