/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Elements;
import com.plotsquared.google.spi.UntargettedBinding;

final class UntargettedBindingImpl<T>
extends BindingImpl<T>
implements UntargettedBinding<T> {
    UntargettedBindingImpl(InjectorImpl injectorImpl, Key<T> key, Object object) {
        super(injectorImpl, key, object, new InternalFactory<T>(){

            @Override
            public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
                throw new AssertionError();
            }
        }, Scoping.UNSCOPED);
    }

    public UntargettedBindingImpl(Object object, Key<T> key, Scoping scoping) {
        super(object, key, scoping);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> bindingTargetVisitor) {
        return bindingTargetVisitor.visit(this);
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new UntargettedBindingImpl(this.getSource(), this.getKey(), scoping);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new UntargettedBindingImpl<T>(this.getSource(), key, this.getScoping());
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(Elements.withTrustedSource(GuiceInternal.GUICE_INTERNAL, binder, this.getSource()).bind(this.getKey()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(UntargettedBinding.class).add("key", this.getKey()).add("source", this.getSource()).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof UntargettedBindingImpl) {
            UntargettedBindingImpl untargettedBindingImpl = (UntargettedBindingImpl)object;
            return this.getKey().equals(untargettedBindingImpl.getKey()) && this.getScoping().equals(untargettedBindingImpl.getScoping());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping()});
    }
}

