/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.ToIntFunction;

final class ImmutableStringTrie
implements ToIntFunction<String> {
    private static final char LEAF_MARKER = '\u8000';
    private static final char BUD_MARKER = '\u4000';
    private static final int MAX_ROWS_PER_TRIE = 16384;
    private final char[] trie;

    private static int singletonTrie(String string) {
        return 0;
    }

    @Override
    public int applyAsInt(String string) {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        char[] cArray = this.trie;
        while (n3 < n2 && (n = Arrays.binarySearch(cArray, n4, n4 + (c = cArray[n4++]), string.charAt(n3))) >= 0) {
            int n5 = n + c;
            char c2 = cArray[n5];
            if ((c2 & 0x8000) != 0) {
                return c2 & 0xFFFF7FFF;
            }
            if ((c2 & 0x4000) != 0) {
                if (n3 == n2 - 1) {
                    return c2 & 0xFFFFBFFF;
                }
                c2 = '\u0001';
            }
            n3 += c2;
            if (n > n4) {
                int n6 = n5 + c - 1;
                n4 += cArray[n6];
            }
            n4 += c * 3 - 1;
        }
        return -1;
    }

    public static ToIntFunction<String> buildTrie(Collection<String> collection) {
        int n = collection.size();
        if (n > 1) {
            return ImmutableStringTrie.buildTrie(new StringBuilder(), collection.toArray(new String[n]), 0, n);
        }
        return ImmutableStringTrie::singletonTrie;
    }

    private static ToIntFunction<String> buildTrie(StringBuilder stringBuilder, String[] stringArray, int n, int n2) {
        int n3 = n + 16384;
        if (n2 <= n3) {
            ImmutableStringTrie.buildSubTrie(stringBuilder, stringArray, 0, n, n2);
            char[] cArray = new char[stringBuilder.length()];
            stringBuilder.getChars(0, cArray.length, cArray, 0);
            return new ImmutableStringTrie(cArray);
        }
        ImmutableStringTrie.buildSubTrie(stringBuilder, stringArray, 0, n, n3);
        char[] cArray = new char[stringBuilder.length()];
        stringBuilder.getChars(0, cArray.length, cArray, 0);
        stringBuilder.setLength(0);
        return new Overflow(cArray, stringArray[n3], ImmutableStringTrie.buildTrie(stringBuilder, stringArray, n3, n2));
    }

    ImmutableStringTrie(char[] cArray) {
        this.trie = cArray;
    }

    private static void buildSubTrie(StringBuilder stringBuilder, String[] stringArray, int n, int n2, int n3) {
        int n4 = stringBuilder.length();
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        boolean bl = true;
        while (n5 < n3) {
            int n8;
            String string = stringArray[n5];
            int n9 = string.length();
            char c = string.charAt(n);
            int n10 = ImmutableStringTrie.nextPivotRow(stringArray, c, n, n5, n3);
            int n11 = ImmutableStringTrie.nextPivotColumn(stringArray, n, n5, n10);
            if (n11 == n9 && n11 - n > 1 && n10 - n5 > 1) {
                --n11;
            }
            int n12 = n4 + n6;
            stringBuilder.insert(n12, c);
            int n13 = n12 + 1 + n6;
            int n14 = stringBuilder.length() + 1;
            if (n11 < n9) {
                stringBuilder.insert(n13, (char)(n11 - n));
                ImmutableStringTrie.buildSubTrie(stringBuilder, stringArray, n11, n5, n10);
                bl = false;
            } else {
                ImmutableStringTrie.buildSubTrie(stringBuilder, stringArray, n11, n5 + 1, n10);
                n8 = n14 > stringBuilder.length() ? 1 : 0;
                int n15 = n8 != 0 ? 32768 : 16384;
                stringBuilder.insert(n13, (char)(n5 & 0x3FFF | n15));
                boolean bl2 = bl = bl && n8 != 0;
            }
            if (n10 < n3) {
                n8 = n13 + 1 + n6;
                stringBuilder.insert(n8, (char)(n7 += stringBuilder.length() - n14));
            }
            n5 = n10;
            ++n6;
        }
        if (n6 > 0) {
            stringBuilder.insert(n4, (char)n6);
            if (bl) {
                int n16 = n4 + 1 + n6 * 2;
                stringBuilder.delete(n16, n16 + n6);
            }
        }
    }

    private static int nextPivotRow(String[] stringArray, char c, int n, int n2, int n3) {
        for (int i = n2 + 1; i < n3; ++i) {
            String string = stringArray[i];
            if (string.length() > n && string.charAt(n) == c) continue;
            return i;
        }
        return n3;
    }

    private static int nextPivotColumn(String[] stringArray, int n, int n2, int n3) {
        String string = stringArray[n2];
        int n4 = string.length();
        for (int i = n + 1; i < n4; ++i) {
            if (ImmutableStringTrie.nextPivotRow(stringArray, string.charAt(i), i, n2, n3) >= n3) continue;
            return i;
        }
        return n4;
    }

    private static final class Overflow
    implements ToIntFunction<String> {
        private final ImmutableStringTrie trie;
        private final String overflowKey;
        private final ToIntFunction<String> next;

        Overflow(char[] cArray, String string, ToIntFunction<String> toIntFunction) {
            this.trie = new ImmutableStringTrie(cArray);
            this.overflowKey = string;
            this.next = toIntFunction;
        }

        @Override
        public int applyAsInt(String string) {
            return string.compareTo(this.overflowKey) < 0 ? this.trie.applyAsInt(string) : 16384 + this.next.applyAsInt(string);
        }
    }
}

