/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.plotsquared.google.TypeLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

final class MethodPartition {
    private final List<Method> candidates = new ArrayList<Method>();

    public MethodPartition(Method method, Method method2) {
        this.candidates.add(method);
        this.candidates.add(method2);
    }

    public MethodPartition addCandidate(Method method) {
        this.candidates.add(method);
        return this;
    }

    public void collectEnhanceableMethods(TypeLiteral<?> typeLiteral, Consumer<Method> consumer, Map<Method, Method> map) {
        Method method;
        Object object;
        HashMap<Object, Method> hashMap = new HashMap<Object, Method>();
        HashMap<Object, Method> hashMap2 = new HashMap<Object, Method>();
        for (Method object2 : this.candidates) {
            object = MethodPartition.parametersKey(object2.getParameterTypes());
            method = hashMap.putIfAbsent(object, object2);
            if (method == null) {
                if (!object2.isBridge()) continue;
                hashMap2.put(object, null);
                continue;
            }
            if (!method.isBridge()) continue;
            if (method.getDeclaringClass() == object2.getDeclaringClass()) {
                if (!object2.isBridge()) {
                    hashMap.put(object, object2);
                    hashMap2.remove(object);
                    continue;
                }
                if (!method.getReturnType().isAssignableFrom(object2.getReturnType())) continue;
                hashMap.put(object, object2);
                continue;
            }
            if (object2.isBridge()) continue;
            hashMap2.putIfAbsent(object, object2);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (Method)entry.getValue();
            if ((((Method)object).getModifiers() & 0x10) != 0) {
                hashMap2.remove(entry.getKey());
                continue;
            }
            if (((Method)object).isBridge()) continue;
            consumer.accept((Method)object);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = (Method)hashMap.get(entry.getKey());
            method = (Method)entry.getValue();
            Object object2 = object;
            for (Method method2 : this.candidates) {
                boolean bl;
                if (method2.isBridge()) continue;
                boolean bl2 = bl = method2 == method;
                if (bl) {
                    if (((Method)object).getReturnType() != method.getReturnType() || method.getDeclaringClass().isInterface()) break;
                    object2 = method;
                    break;
                }
                if (!MethodPartition.resolvedParametersMatch((Method)object, typeLiteral, method2) && (method == null || !MethodPartition.resolvedParametersMatch(method2, typeLiteral, method))) continue;
                map.put((Method)object, method2);
                break;
            }
            if ((((Method)object2).getModifiers() & 0x10) != 0) continue;
            consumer.accept((Method)object2);
        }
    }

    private static String parametersKey(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(classArray[i].getName());
        }
        return stringBuilder.toString();
    }

    private static boolean resolvedParametersMatch(Method method, TypeLiteral<?> typeLiteral, Method method2) {
        Class<?>[] classArray = method.getParameterTypes();
        List<TypeLiteral<?>> list = typeLiteral.getParameterTypes(method2);
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            if (classArray[i] == list.get(i).getRawType()) continue;
            return false;
        }
        return true;
    }
}

