/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.aop;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.aop.AnonymousClassDefiner;
import com.plotsquared.google.internal.aop.ClassDefiner;
import com.plotsquared.google.internal.aop.GeneratedClassDefiner;
import com.plotsquared.google.internal.aop.HiddenClassDefiner;
import com.plotsquared.google.internal.asm.$ClassWriter;
import com.plotsquared.google.internal.asm.$MethodVisitor;
import com.plotsquared.google.internal.asm.$Type;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UnsafeClassDefiner
implements ClassDefiner {
    private static final Logger logger = Logger.getLogger(UnsafeClassDefiner.class.getName());
    private static final ClassDefiner UNSAFE_DEFINER;
    private static final boolean ALWAYS_DEFINE_ANONYMOUSLY;
    private static final String DEFINEACCESS_BY_GUICE_MARKER = "$$DefineAccessByGuice$$";
    private static final String[] DEFINEACCESS_API;
    private static final String CLASS_LOADER_TYPE;
    private static final String BYTE_ARRAY_TYPE;

    UnsafeClassDefiner() {
    }

    public static boolean isAccessible() {
        return UNSAFE_DEFINER != null;
    }

    public static boolean canLoadProxyByName(Class<?> clazz) {
        return UnsafeClassDefiner.findClassDefiner(clazz.getClassLoader()) != UNSAFE_DEFINER;
    }

    public static boolean canDowncastToProxy(Class<?> clazz) {
        return !(UnsafeClassDefiner.findClassDefiner(clazz.getClassLoader()) instanceof AnonymousClassDefiner);
    }

    @Override
    public Class<?> define(Class<?> clazz, byte[] byArray) {
        return UnsafeClassDefiner.findClassDefiner(clazz.getClassLoader()).define(clazz, byArray);
    }

    private static ClassDefiner findClassDefiner(ClassLoader classLoader) {
        if (classLoader == null || ALWAYS_DEFINE_ANONYMOUSLY) {
            return UNSAFE_DEFINER;
        }
        if (ClassLoaderDefineClassHolder.CLASS_LOADER_DEFINE_CLASS != null) {
            return ClassLoaderDefineClassHolder.CLASS_LOADER_DEFINE_CLASS;
        }
        return (ClassDefiner)DefineClassCacheHolder.DEFINE_CLASS_CACHE.getUnchecked(classLoader.getClass());
    }

    static <T> T tryPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction, String string) {
        try {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, string, throwable);
            return null;
        }
    }

    static ClassDefiner tryAccessDefineClass(Class<?> clazz) {
        try {
            logger.log(Level.FINE, "Accessing defineClass method in %s", clazz);
            return AccessController.doPrivileged(() -> UnsafeClassDefiner.accessDefineClass(clazz));
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Cannot access defineClass method in " + clazz, throwable);
            return UNSAFE_DEFINER;
        }
    }

    static ClassDefiner accessDefineClass(Class<?> clazz) {
        byte[] byArray = UnsafeClassDefiner.buildDefineClassAccess(clazz);
        Class<?> clazz2 = UNSAFE_DEFINER.define(clazz, byArray);
        return new GeneratedClassDefiner((BiFunction)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private static byte[] buildDefineClassAccess(Class<?> clazz) {
        $ClassWriter $ClassWriter = new $ClassWriter(1);
        $ClassWriter.visit(52, 33, clazz.getName().replace('.', '/') + DEFINEACCESS_BY_GUICE_MARKER, null, "java/lang/Object", DEFINEACCESS_API);
        $MethodVisitor $MethodVisitor = $ClassWriter.visitMethod(1, "<init>", "()V", null, null);
        $MethodVisitor.visitCode();
        $MethodVisitor.visitVarInsn(25, 0);
        $MethodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        $MethodVisitor.visitInsn(177);
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
        $MethodVisitor = $ClassWriter.visitMethod(1, "apply", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        $MethodVisitor.visitCode();
        $MethodVisitor.visitVarInsn(25, 1);
        $MethodVisitor.visitTypeInsn(192, CLASS_LOADER_TYPE);
        $MethodVisitor.visitInsn(1);
        $MethodVisitor.visitVarInsn(25, 2);
        $MethodVisitor.visitTypeInsn(192, BYTE_ARRAY_TYPE);
        $MethodVisitor.visitInsn(3);
        $MethodVisitor.visitVarInsn(25, 2);
        $MethodVisitor.visitTypeInsn(192, BYTE_ARRAY_TYPE);
        $MethodVisitor.visitInsn(190);
        $MethodVisitor.visitMethodInsn(182, "java/lang/ClassLoader", "defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;", false);
        $MethodVisitor.visitInsn(176);
        $MethodVisitor.visitMaxs(0, 0);
        $MethodVisitor.visitEnd();
        $ClassWriter.visitEnd();
        return $ClassWriter.toByteArray();
    }

    static {
        ClassDefiner classDefiner = UnsafeClassDefiner.tryPrivileged(AnonymousClassDefiner::new, "Cannot bind Unsafe.defineAnonymousClass");
        if (classDefiner == null) {
            classDefiner = UnsafeClassDefiner.tryPrivileged(HiddenClassDefiner::new, "Cannot bind MethodHandles.Lookup.defineHiddenClass");
        }
        UNSAFE_DEFINER = classDefiner;
        ALWAYS_DEFINE_ANONYMOUSLY = InternalFlags.getCustomClassLoadingOption() == InternalFlags.CustomClassLoadingOption.ANONYMOUS;
        DEFINEACCESS_API = new String[]{"java/util/function/BiFunction"};
        CLASS_LOADER_TYPE = $Type.getInternalName(ClassLoader.class);
        BYTE_ARRAY_TYPE = $Type.getInternalName(byte[].class);
    }

    private static class DefineClassCacheHolder {
        static final LoadingCache<Class<?>, ClassDefiner> DEFINE_CLASS_CACHE = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from(UnsafeClassDefiner::tryAccessDefineClass));

        private DefineClassCacheHolder() {
        }
    }

    private static class ClassLoaderDefineClassHolder {
        static final ClassDefiner CLASS_LOADER_DEFINE_CLASS = UnsafeClassDefiner.tryPrivileged(() -> UnsafeClassDefiner.accessDefineClass(ClassLoader.class), "Cannot access ClassLoader.defineClass");

        private ClassLoaderDefineClassHolder() {
        }
    }
}

