/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.asm;

import com.plotsquared.google.internal.asm.$AnnotationVisitor;
import com.plotsquared.google.internal.asm.$AnnotationWriter;
import com.plotsquared.google.internal.asm.$Attribute;
import com.plotsquared.google.internal.asm.$ByteVector;
import com.plotsquared.google.internal.asm.$ClassReader;
import com.plotsquared.google.internal.asm.$ClassTooLargeException;
import com.plotsquared.google.internal.asm.$ClassVisitor;
import com.plotsquared.google.internal.asm.$FieldVisitor;
import com.plotsquared.google.internal.asm.$FieldWriter;
import com.plotsquared.google.internal.asm.$Handle;
import com.plotsquared.google.internal.asm.$MethodVisitor;
import com.plotsquared.google.internal.asm.$MethodWriter;
import com.plotsquared.google.internal.asm.$ModuleVisitor;
import com.plotsquared.google.internal.asm.$ModuleWriter;
import com.plotsquared.google.internal.asm.$RecordComponentVisitor;
import com.plotsquared.google.internal.asm.$RecordComponentWriter;
import com.plotsquared.google.internal.asm.$Symbol;
import com.plotsquared.google.internal.asm.$SymbolTable;
import com.plotsquared.google.internal.asm.$TypePath;

public class $ClassWriter
extends $ClassVisitor {
    public static final int COMPUTE_MAXS = 1;
    public static final int COMPUTE_FRAMES = 2;
    private final int flags;
    private int version;
    private final $SymbolTable symbolTable;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfaceCount;
    private int[] interfaces;
    private $FieldWriter firstField;
    private $FieldWriter lastField;
    private $MethodWriter firstMethod;
    private $MethodWriter lastMethod;
    private int numberOfInnerClasses;
    private $ByteVector innerClasses;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    private int signatureIndex;
    private int sourceFileIndex;
    private $ByteVector debugExtension;
    private $AnnotationWriter lastRuntimeVisibleAnnotation;
    private $AnnotationWriter lastRuntimeInvisibleAnnotation;
    private $AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private $AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private $ModuleWriter moduleWriter;
    private int nestHostClassIndex;
    private int numberOfNestMemberClasses;
    private $ByteVector nestMemberClasses;
    private int numberOfPermittedSubclasses;
    private $ByteVector permittedSubclasses;
    private $RecordComponentWriter firstRecordComponent;
    private $RecordComponentWriter lastRecordComponent;
    private $Attribute firstAttribute;
    private int compute;

    public $ClassWriter(int n) {
        this(null, n);
    }

    public $ClassWriter($ClassReader $ClassReader, int n) {
        super(589824);
        this.flags = n;
        $SymbolTable $SymbolTable = this.symbolTable = $ClassReader == null ? new $SymbolTable(this) : new $SymbolTable(this, $ClassReader);
        this.compute = (n & 2) != 0 ? 4 : ((n & 1) != 0 ? 1 : 0);
    }

    public boolean hasFlags(int n) {
        return (this.flags & n) == n;
    }

    public final void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.version = n;
        this.accessFlags = n2;
        this.thisClass = this.symbolTable.setMajorVersionAndClassName(n & 0xFFFF, string);
        if (string2 != null) {
            this.signatureIndex = this.symbolTable.addConstantUtf8(string2);
        }
        int n3 = this.superClass = string3 == null ? 0 : this.symbolTable.addConstantClass((String)string3).index;
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.symbolTable.addConstantClass((String)stringArray[i]).index;
            }
        }
        if (this.compute == 1 && (n & 0xFFFF) >= 51) {
            this.compute = 2;
        }
    }

    public final void visitSource(String string, String string2) {
        if (string != null) {
            this.sourceFileIndex = this.symbolTable.addConstantUtf8(string);
        }
        if (string2 != null) {
            this.debugExtension = new $ByteVector().encodeUtf8(string2, 0, Integer.MAX_VALUE);
        }
    }

    public final $ModuleVisitor visitModule(String string, int n, String string2) {
        this.moduleWriter = new $ModuleWriter(this.symbolTable, this.symbolTable.addConstantModule((String)string).index, n, string2 == null ? 0 : this.symbolTable.addConstantUtf8(string2));
        return this.moduleWriter;
    }

    public final void visitNestHost(String string) {
        this.nestHostClassIndex = this.symbolTable.addConstantClass((String)string).index;
    }

    public final void visitOuterClass(String string, String string2, String string3) {
        this.enclosingClassIndex = this.symbolTable.addConstantClass((String)string).index;
        if (string2 != null && string3 != null) {
            this.enclosingMethodIndex = this.symbolTable.addConstantNameAndType(string2, string3);
        }
    }

    public final $AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleAnnotation = $AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = $AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public final $AnnotationVisitor visitTypeAnnotation(int n, $TypePath $TypePath, String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = $AnnotationWriter.create(this.symbolTable, n, $TypePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = $AnnotationWriter.create(this.symbolTable, n, $TypePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public final void visitAttribute($Attribute $Attribute) {
        $Attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = $Attribute;
    }

    public final void visitNestMember(String string) {
        if (this.nestMemberClasses == null) {
            this.nestMemberClasses = new $ByteVector();
        }
        ++this.numberOfNestMemberClasses;
        this.nestMemberClasses.putShort(this.symbolTable.addConstantClass((String)string).index);
    }

    public final void visitPermittedSubclass(String string) {
        if (this.permittedSubclasses == null) {
            this.permittedSubclasses = new $ByteVector();
        }
        ++this.numberOfPermittedSubclasses;
        this.permittedSubclasses.putShort(this.symbolTable.addConstantClass((String)string).index);
    }

    public final void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.innerClasses == null) {
            this.innerClasses = new $ByteVector();
        }
        $Symbol $Symbol = this.symbolTable.addConstantClass(string);
        if ($Symbol.info == 0) {
            ++this.numberOfInnerClasses;
            this.innerClasses.putShort($Symbol.index);
            this.innerClasses.putShort(string2 == null ? 0 : this.symbolTable.addConstantClass((String)string2).index);
            this.innerClasses.putShort(string3 == null ? 0 : this.symbolTable.addConstantUtf8(string3));
            this.innerClasses.putShort(n);
            $Symbol.info = this.numberOfInnerClasses;
        }
    }

    public final $RecordComponentVisitor visitRecordComponent(String string, String string2, String string3) {
        $RecordComponentWriter $RecordComponentWriter = new $RecordComponentWriter(this.symbolTable, string, string2, string3);
        if (this.firstRecordComponent == null) {
            this.firstRecordComponent = $RecordComponentWriter;
        } else {
            this.lastRecordComponent.delegate = $RecordComponentWriter;
        }
        this.lastRecordComponent = $RecordComponentWriter;
        return this.lastRecordComponent;
    }

    public final $FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        $FieldWriter $FieldWriter = new $FieldWriter(this.symbolTable, n, string, string2, string3, object);
        if (this.firstField == null) {
            this.firstField = $FieldWriter;
        } else {
            this.lastField.fv = $FieldWriter;
        }
        this.lastField = $FieldWriter;
        return this.lastField;
    }

    public final $MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        $MethodWriter $MethodWriter = new $MethodWriter(this.symbolTable, n, string, string2, string3, stringArray, this.compute);
        if (this.firstMethod == null) {
            this.firstMethod = $MethodWriter;
        } else {
            this.lastMethod.mv = $MethodWriter;
        }
        this.lastMethod = $MethodWriter;
        return this.lastMethod;
    }

    public final void visitEnd() {
    }

    public byte[] toByteArray() {
        int n;
        int n2 = 24 + 2 * this.interfaceCount;
        int n3 = 0;
        $FieldWriter $FieldWriter = this.firstField;
        while ($FieldWriter != null) {
            ++n3;
            n2 += $FieldWriter.computeFieldInfoSize();
            $FieldWriter = ($FieldWriter)$FieldWriter.fv;
        }
        int n4 = 0;
        $MethodWriter $MethodWriter = this.firstMethod;
        while ($MethodWriter != null) {
            ++n4;
            n2 += $MethodWriter.computeMethodInfoSize();
            $MethodWriter = ($MethodWriter)$MethodWriter.mv;
        }
        int n5 = 0;
        if (this.innerClasses != null) {
            ++n5;
            n2 += 8 + this.innerClasses.length;
            this.symbolTable.addConstantUtf8("InnerClasses");
        }
        if (this.enclosingClassIndex != 0) {
            ++n5;
            n2 += 10;
            this.symbolTable.addConstantUtf8("EnclosingMethod");
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            ++n5;
            n2 += 6;
            this.symbolTable.addConstantUtf8("Synthetic");
        }
        if (this.signatureIndex != 0) {
            ++n5;
            n2 += 8;
            this.symbolTable.addConstantUtf8("Signature");
        }
        if (this.sourceFileIndex != 0) {
            ++n5;
            n2 += 8;
            this.symbolTable.addConstantUtf8("SourceFile");
        }
        if (this.debugExtension != null) {
            ++n5;
            n2 += 6 + this.debugExtension.length;
            this.symbolTable.addConstantUtf8("SourceDebugExtension");
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n5;
            n2 += 6;
            this.symbolTable.addConstantUtf8("Deprecated");
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeVisibleAnnotation.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeInvisibleAnnotation.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        if (this.symbolTable.computeBootstrapMethodsSize() > 0) {
            ++n5;
            n2 += this.symbolTable.computeBootstrapMethodsSize();
        }
        if (this.moduleWriter != null) {
            n5 += this.moduleWriter.getAttributeCount();
            n2 += this.moduleWriter.computeAttributesSize();
        }
        if (this.nestHostClassIndex != 0) {
            ++n5;
            n2 += 8;
            this.symbolTable.addConstantUtf8("NestHost");
        }
        if (this.nestMemberClasses != null) {
            ++n5;
            n2 += 8 + this.nestMemberClasses.length;
            this.symbolTable.addConstantUtf8("NestMembers");
        }
        if (this.permittedSubclasses != null) {
            ++n5;
            n2 += 8 + this.permittedSubclasses.length;
            this.symbolTable.addConstantUtf8("PermittedSubclasses");
        }
        int n6 = 0;
        int n7 = 0;
        if ((this.accessFlags & 0x10000) != 0 || this.firstRecordComponent != null) {
            $RecordComponentWriter $RecordComponentWriter = this.firstRecordComponent;
            while ($RecordComponentWriter != null) {
                ++n6;
                n7 += $RecordComponentWriter.computeRecordComponentInfoSize();
                $RecordComponentWriter = ($RecordComponentWriter)$RecordComponentWriter.delegate;
            }
            ++n5;
            n2 += 8 + n7;
            this.symbolTable.addConstantUtf8("Record");
        }
        if (this.firstAttribute != null) {
            n5 += this.firstAttribute.getAttributeCount();
            n2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        n2 += this.symbolTable.getConstantPoolLength();
        int n8 = this.symbolTable.getConstantPoolCount();
        if (n8 > 65535) {
            throw new $ClassTooLargeException(this.symbolTable.getClassName(), n8);
        }
        $ByteVector $ByteVector = new $ByteVector(n2);
        $ByteVector.putInt(-889275714).putInt(this.version);
        this.symbolTable.putConstantPool($ByteVector);
        int n9 = (this.version & 0xFFFF) < 49 ? 4096 : 0;
        $ByteVector.putShort(this.accessFlags & ~n9).putShort(this.thisClass).putShort(this.superClass);
        $ByteVector.putShort(this.interfaceCount);
        for (n = 0; n < this.interfaceCount; n += 1) {
            $ByteVector.putShort(this.interfaces[n]);
        }
        $ByteVector.putShort(n3);
        $FieldWriter = this.firstField;
        while ($FieldWriter != null) {
            $FieldWriter.putFieldInfo($ByteVector);
            $FieldWriter = ($FieldWriter)$FieldWriter.fv;
        }
        $ByteVector.putShort(n4);
        n = 0;
        boolean bl = false;
        $MethodWriter = this.firstMethod;
        while ($MethodWriter != null) {
            n |= $MethodWriter.hasFrames();
            bl |= $MethodWriter.hasAsmInstructions();
            $MethodWriter.putMethodInfo($ByteVector);
            $MethodWriter = ($MethodWriter)$MethodWriter.mv;
        }
        $ByteVector.putShort(n5);
        if (this.innerClasses != null) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("InnerClasses")).putInt(this.innerClasses.length + 2).putShort(this.numberOfInnerClasses).putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.enclosingClassIndex != 0) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("EnclosingMethod")).putInt(4).putShort(this.enclosingClassIndex).putShort(this.enclosingMethodIndex);
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (this.signatureIndex != 0) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(this.signatureIndex);
        }
        if (this.sourceFileIndex != 0) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("SourceFile")).putInt(2).putShort(this.sourceFileIndex);
        }
        if (this.debugExtension != null) {
            int n10 = this.debugExtension.length;
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("SourceDebugExtension")).putInt(n10).putByteArray(this.debugExtension.data, 0, n10);
        }
        if ((this.accessFlags & 0x20000) != 0) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
        $AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, $ByteVector);
        this.symbolTable.putBootstrapMethods($ByteVector);
        if (this.moduleWriter != null) {
            this.moduleWriter.putAttributes($ByteVector);
        }
        if (this.nestHostClassIndex != 0) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("NestHost")).putInt(2).putShort(this.nestHostClassIndex);
        }
        if (this.nestMemberClasses != null) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("NestMembers")).putInt(this.nestMemberClasses.length + 2).putShort(this.numberOfNestMemberClasses).putByteArray(this.nestMemberClasses.data, 0, this.nestMemberClasses.length);
        }
        if (this.permittedSubclasses != null) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("PermittedSubclasses")).putInt(this.permittedSubclasses.length + 2).putShort(this.numberOfPermittedSubclasses).putByteArray(this.permittedSubclasses.data, 0, this.permittedSubclasses.length);
        }
        if ((this.accessFlags & 0x10000) != 0 || this.firstRecordComponent != null) {
            $ByteVector.putShort(this.symbolTable.addConstantUtf8("Record")).putInt(n7 + 2).putShort(n6);
            $RecordComponentWriter $RecordComponentWriter = this.firstRecordComponent;
            while ($RecordComponentWriter != null) {
                $RecordComponentWriter.putRecordComponentInfo($ByteVector);
                $RecordComponentWriter = ($RecordComponentWriter)$RecordComponentWriter.delegate;
            }
        }
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, $ByteVector);
        }
        if (bl) {
            return this.replaceAsmInstructions($ByteVector.data, n != 0);
        }
        return $ByteVector.data;
    }

    private byte[] replaceAsmInstructions(byte[] byArray, boolean bl) {
        $Attribute[] $AttributeArray = this.getAttributePrototypes();
        this.firstField = null;
        this.lastField = null;
        this.firstMethod = null;
        this.lastMethod = null;
        this.lastRuntimeVisibleAnnotation = null;
        this.lastRuntimeInvisibleAnnotation = null;
        this.lastRuntimeVisibleTypeAnnotation = null;
        this.lastRuntimeInvisibleTypeAnnotation = null;
        this.moduleWriter = null;
        this.nestHostClassIndex = 0;
        this.numberOfNestMemberClasses = 0;
        this.nestMemberClasses = null;
        this.numberOfPermittedSubclasses = 0;
        this.permittedSubclasses = null;
        this.firstRecordComponent = null;
        this.lastRecordComponent = null;
        this.firstAttribute = null;
        this.compute = bl ? 3 : 0;
        new $ClassReader(byArray, 0, false).accept(this, $AttributeArray, (bl ? 8 : 0) | 0x100);
        return this.toByteArray();
    }

    private $Attribute[] getAttributePrototypes() {
        $Attribute.Set set = new $Attribute.Set();
        set.addAttributes(this.firstAttribute);
        $FieldWriter $FieldWriter = this.firstField;
        while ($FieldWriter != null) {
            $FieldWriter.collectAttributePrototypes(set);
            $FieldWriter = ($FieldWriter)$FieldWriter.fv;
        }
        $MethodWriter $MethodWriter = this.firstMethod;
        while ($MethodWriter != null) {
            $MethodWriter.collectAttributePrototypes(set);
            $MethodWriter = ($MethodWriter)$MethodWriter.mv;
        }
        $RecordComponentWriter $RecordComponentWriter = this.firstRecordComponent;
        while ($RecordComponentWriter != null) {
            $RecordComponentWriter.collectAttributePrototypes(set);
            $RecordComponentWriter = ($RecordComponentWriter)$RecordComponentWriter.delegate;
        }
        return set.toArray();
    }

    public int newConst(Object object) {
        return this.symbolTable.addConstant((Object)object).index;
    }

    public int newUTF8(String string) {
        return this.symbolTable.addConstantUtf8(string);
    }

    public int newClass(String string) {
        return this.symbolTable.addConstantClass((String)string).index;
    }

    public int newMethodType(String string) {
        return this.symbolTable.addConstantMethodType((String)string).index;
    }

    public int newModule(String string) {
        return this.symbolTable.addConstantModule((String)string).index;
    }

    public int newPackage(String string) {
        return this.symbolTable.addConstantPackage((String)string).index;
    }

    @Deprecated
    public int newHandle(int n, String string, String string2, String string3) {
        return this.newHandle(n, string, string2, string3, n == 9);
    }

    public int newHandle(int n, String string, String string2, String string3, boolean bl) {
        return this.symbolTable.addConstantMethodHandle((int)n, (String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    public int newConstantDynamic(String string, String string2, $Handle $Handle, Object ... objectArray) {
        return this.symbolTable.addConstantDynamic((String)string, (String)string2, ($Handle)$Handle, (Object[])objectArray).index;
    }

    public int newInvokeDynamic(String string, String string2, $Handle $Handle, Object ... objectArray) {
        return this.symbolTable.addConstantInvokeDynamic((String)string, (String)string2, ($Handle)$Handle, (Object[])objectArray).index;
    }

    public int newField(String string, String string2, String string3) {
        return this.symbolTable.addConstantFieldref((String)string, (String)string2, (String)string3).index;
    }

    public int newMethod(String string, String string2, String string3, boolean bl) {
        return this.symbolTable.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    public int newNameType(String string, String string2) {
        return this.symbolTable.addConstantNameAndType(string, string2);
    }

    protected String getCommonSuperClass(String string, String string2) {
        Class<?> clazz;
        Class<?> clazz2;
        ClassLoader classLoader = this.getClassLoader();
        try {
            clazz2 = Class.forName(string.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string, classNotFoundException);
        }
        try {
            clazz = Class.forName(string2.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string2, classNotFoundException);
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return string;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return string2;
        }
        if (clazz2.isInterface() || clazz.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz2 = clazz2.getSuperclass()).isAssignableFrom(clazz)) {
        }
        return clazz2.getName().replace('.', '/');
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

