/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.asm;

import com.plotsquared.google.internal.asm.$ByteVector;
import com.plotsquared.google.internal.asm.$Edge;
import com.plotsquared.google.internal.asm.$Frame;
import com.plotsquared.google.internal.asm.$MethodVisitor;

public class $Label {
    static final int FLAG_DEBUG_ONLY = 1;
    static final int FLAG_JUMP_TARGET = 2;
    static final int FLAG_RESOLVED = 4;
    static final int FLAG_REACHABLE = 8;
    static final int FLAG_SUBROUTINE_CALLER = 16;
    static final int FLAG_SUBROUTINE_START = 32;
    static final int FLAG_SUBROUTINE_END = 64;
    static final int FLAG_LINE_NUMBER = 128;
    static final int LINE_NUMBERS_CAPACITY_INCREMENT = 4;
    static final int FORWARD_REFERENCES_CAPACITY_INCREMENT = 6;
    static final int FORWARD_REFERENCE_TYPE_MASK = -268435456;
    static final int FORWARD_REFERENCE_TYPE_SHORT = 0x10000000;
    static final int FORWARD_REFERENCE_TYPE_WIDE = 0x20000000;
    static final int FORWARD_REFERENCE_HANDLE_MASK = 0xFFFFFFF;
    static final $Label EMPTY_LIST = new $Label();
    public Object info;
    short flags;
    private short lineNumber;
    private int[] otherLineNumbers;
    int bytecodeOffset;
    private int[] forwardReferences;
    short inputStackSize;
    short outputStackSize;
    short outputStackMax;
    short subroutineId;
    $Frame frame;
    $Label nextBasicBlock;
    $Edge outgoingEdges;
    $Label nextListElement;

    public int getOffset() {
        if ((this.flags & 4) == 0) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.bytecodeOffset;
    }

    final $Label getCanonicalInstance() {
        return this.frame == null ? this : this.frame.owner;
    }

    final void addLineNumber(int n) {
        if ((this.flags & 0x80) == 0) {
            this.flags = (short)(this.flags | 0x80);
            this.lineNumber = (short)n;
        } else {
            int n2;
            if (this.otherLineNumbers == null) {
                this.otherLineNumbers = new int[4];
            }
            if ((n2 = (this.otherLineNumbers[0] = this.otherLineNumbers[0] + 1)) >= this.otherLineNumbers.length) {
                int[] nArray = new int[this.otherLineNumbers.length + 4];
                System.arraycopy(this.otherLineNumbers, 0, nArray, 0, this.otherLineNumbers.length);
                this.otherLineNumbers = nArray;
            }
            this.otherLineNumbers[n2] = n;
        }
    }

    final void accept($MethodVisitor $MethodVisitor, boolean bl) {
        $MethodVisitor.visitLabel(this);
        if (bl && (this.flags & 0x80) != 0) {
            $MethodVisitor.visitLineNumber(this.lineNumber & 0xFFFF, this);
            if (this.otherLineNumbers != null) {
                for (int i = 1; i <= this.otherLineNumbers[0]; ++i) {
                    $MethodVisitor.visitLineNumber(this.otherLineNumbers[i], this);
                }
            }
        }
    }

    final void put($ByteVector $ByteVector, int n, boolean bl) {
        if ((this.flags & 4) == 0) {
            if (bl) {
                this.addForwardReference(n, 0x20000000, $ByteVector.length);
                $ByteVector.putInt(-1);
            } else {
                this.addForwardReference(n, 0x10000000, $ByteVector.length);
                $ByteVector.putShort(-1);
            }
        } else if (bl) {
            $ByteVector.putInt(this.bytecodeOffset - n);
        } else {
            $ByteVector.putShort(this.bytecodeOffset - n);
        }
    }

    private void addForwardReference(int n, int n2, int n3) {
        int n4;
        if (this.forwardReferences == null) {
            this.forwardReferences = new int[6];
        }
        if ((n4 = this.forwardReferences[0]) + 2 >= this.forwardReferences.length) {
            int[] nArray = new int[this.forwardReferences.length + 6];
            System.arraycopy(this.forwardReferences, 0, nArray, 0, this.forwardReferences.length);
            this.forwardReferences = nArray;
        }
        this.forwardReferences[++n4] = n;
        this.forwardReferences[++n4] = n2 | n3;
        this.forwardReferences[0] = n4;
    }

    final boolean resolve(byte[] byArray, int n) {
        this.flags = (short)(this.flags | 4);
        this.bytecodeOffset = n;
        if (this.forwardReferences == null) {
            return false;
        }
        boolean bl = false;
        for (int i = this.forwardReferences[0]; i > 0; i -= 2) {
            int n2 = this.forwardReferences[i - 1];
            int n3 = this.forwardReferences[i];
            int n4 = n - n2;
            int n5 = n3 & 0xFFFFFFF;
            if ((n3 & 0xF0000000) == 0x10000000) {
                if (n4 < Short.MIN_VALUE || n4 > Short.MAX_VALUE) {
                    int n6 = byArray[n2] & 0xFF;
                    byArray[n2] = n6 < 198 ? (byte)(n6 + 49) : (byte)(n6 + 20);
                    bl = true;
                }
                byArray[n5++] = (byte)(n4 >>> 8);
                byArray[n5] = (byte)n4;
                continue;
            }
            byArray[n5++] = (byte)(n4 >>> 24);
            byArray[n5++] = (byte)(n4 >>> 16);
            byArray[n5++] = (byte)(n4 >>> 8);
            byArray[n5] = (byte)n4;
        }
        return bl;
    }

    final void markSubroutine(short s) {
        $Label $Label = this;
        $Label.nextListElement = EMPTY_LIST;
        while ($Label != EMPTY_LIST) {
            $Label $Label2 = $Label;
            $Label = $Label.nextListElement;
            $Label2.nextListElement = null;
            if ($Label2.subroutineId != 0) continue;
            $Label2.subroutineId = s;
            $Label = $Label2.pushSuccessors($Label);
        }
    }

    final void addSubroutineRetSuccessors($Label $Label) {
        $Label $Label2;
        $Label $Label3 = EMPTY_LIST;
        $Label $Label4 = this;
        $Label4.nextListElement = EMPTY_LIST;
        while ($Label4 != EMPTY_LIST) {
            $Label2 = $Label4;
            $Label4 = $Label2.nextListElement;
            $Label2.nextListElement = $Label3;
            $Label3 = $Label2;
            if (($Label2.flags & 0x40) != 0 && $Label2.subroutineId != $Label.subroutineId) {
                $Label2.outgoingEdges = new $Edge($Label2.outputStackSize, $Label.outgoingEdges.successor, $Label2.outgoingEdges);
            }
            $Label4 = $Label2.pushSuccessors($Label4);
        }
        while ($Label3 != EMPTY_LIST) {
            $Label2 = $Label3.nextListElement;
            $Label3.nextListElement = null;
            $Label3 = $Label2;
        }
    }

    private $Label pushSuccessors($Label $Label) {
        $Label $Label2 = $Label;
        $Edge $Edge = this.outgoingEdges;
        while ($Edge != null) {
            boolean bl;
            boolean bl2 = bl = (this.flags & 0x10) != 0 && $Edge == this.outgoingEdges.nextEdge;
            if (!bl && $Edge.successor.nextListElement == null) {
                $Edge.successor.nextListElement = $Label2;
                $Label2 = $Edge.successor;
            }
            $Edge = $Edge.nextEdge;
        }
        return $Label2;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

