/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Classes {
    public static boolean isInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcrete(Class<?> clazz) {
        int n = clazz.getModifiers();
        return !clazz.isInterface() && !Modifier.isAbstract(n);
    }

    public static String toString(Member member) {
        Class<? extends Member> clazz = Classes.memberType(member);
        if (clazz == Method.class) {
            return member.getDeclaringClass().getName() + '.' + member.getName() + "()";
        }
        if (clazz == Field.class) {
            return member.getDeclaringClass().getName() + '.' + member.getName();
        }
        if (clazz == Constructor.class) {
            return member.getDeclaringClass().getName() + ".<init>()";
        }
        throw new AssertionError();
    }

    public static Class<? extends Member> memberType(Member member) {
        Preconditions.checkNotNull((Object)member, (Object)"member");
        if (member instanceof Field) {
            return Field.class;
        }
        if (member instanceof Method) {
            return Method.class;
        }
        if (member instanceof Constructor) {
            return Constructor.class;
        }
        throw new IllegalArgumentException("Unsupported implementation class for Member, " + member.getClass());
    }
}

