/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.RestrictedBindingSource;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.spi.DefaultElementVisitor;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementSource;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ModuleSource;
import com.plotsquared.google.spi.PrivateElements;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class BindingSourceRestriction {
    private static final Logger logger = Logger.getLogger(RestrictedBindingSource.class.getName());

    private BindingSourceRestriction() {
    }

    public static Optional<String> getMissingImplementationSuggestion(GuiceInternal guiceInternal, Key<?> key) {
        Preconditions.checkNotNull((Object)guiceInternal);
        RestrictedBindingSource restrictedBindingSource = BindingSourceRestriction.getRestriction(key);
        if (restrictedBindingSource == null) {
            return Optional.empty();
        }
        return Optional.of(String.format("\nHint: This key is restricted and cannot be bound directly. Restriction explanation: %s", restrictedBindingSource.explanation()));
    }

    public static ImmutableList<Message> check(GuiceInternal guiceInternal, List<Element> list) {
        Preconditions.checkNotNull((Object)guiceInternal);
        ImmutableList<Message> immutableList = BindingSourceRestriction.check(list);
        list.forEach(BindingSourceRestriction::clear);
        return immutableList;
    }

    private static ImmutableList<Message> check(List<Element> list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element : list) {
            builder.addAll(BindingSourceRestriction.check(element));
        }
        return builder.build();
    }

    private static ImmutableList<Message> check(Element element) {
        return element.acceptVisitor(new DefaultElementVisitor<ImmutableList<Message>>(){

            @Override
            protected ImmutableList<Message> visitOther(Element element) {
                return ImmutableList.of();
            }

            @Override
            public <T> ImmutableList<Message> visit(Binding<T> binding) {
                Optional optional = BindingSourceRestriction.check(binding);
                if (optional.isPresent()) {
                    return ImmutableList.of((Object)((Message)optional.get()));
                }
                return ImmutableList.of();
            }

            @Override
            public ImmutableList<Message> visit(PrivateElements privateElements) {
                return BindingSourceRestriction.check(privateElements.getElements());
            }
        });
    }

    private static Optional<Message> check(Binding<?> binding) {
        Key<?> key = binding.getKey();
        ElementSource elementSource = (ElementSource)binding.getSource();
        RestrictedBindingSource restrictedBindingSource = BindingSourceRestriction.getRestriction(key);
        if (restrictedBindingSource == null) {
            return Optional.empty();
        }
        ImmutableSet<Class<? extends Annotation>> immutableSet = BindingSourceRestriction.getAllPermits(elementSource);
        ImmutableSet immutableSet2 = ImmutableSet.copyOf((Object[])restrictedBindingSource.permits());
        boolean bl = immutableSet.stream().anyMatch(arg_0 -> ((ImmutableSet)immutableSet2).contains(arg_0));
        if (bl || BindingSourceRestriction.isExempt(elementSource, restrictedBindingSource.exemptModules())) {
            return Optional.empty();
        }
        String string = BindingSourceRestriction.getViolationMessage(key, restrictedBindingSource.explanation(), (ImmutableSet<Class<? extends Annotation>>)immutableSet2, key.getAnnotationType() != null);
        if (restrictedBindingSource.restrictionLevel() == RestrictedBindingSource.RestrictionLevel.WARNING) {
            Formatter formatter = new Formatter();
            Errors.formatSource(formatter, elementSource);
            logger.log(Level.WARNING, string + "\n" + formatter);
            return Optional.empty();
        }
        return Optional.of(new Message(elementSource, string));
    }

    private static String getViolationMessage(Key<?> key, String string, ImmutableSet<Class<? extends Annotation>> immutableSet, boolean bl) {
        return String.format("Unable to bind key: %s. One of the modules that created this binding has to be annotated with one of %s, because the key's %s is annotated with @RestrictedBindingSource. %s", key, immutableSet.stream().map(clazz -> "@" + clazz.getName()).collect(Collectors.toList()), bl ? "annotation" : "type", string);
    }

    private static ImmutableSet<Class<? extends Annotation>> getAllPermits(ElementSource elementSource) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(elementSource.moduleSource.getPermitMap().getPermits(elementSource));
        if (elementSource.scanner != null) {
            BindingSourceRestriction.getPermits(elementSource.scanner.getClass()).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        if (elementSource.getOriginalElementSource() != null && elementSource.trustedOriginalElementSource) {
            builder.addAll(BindingSourceRestriction.getAllPermits(elementSource.getOriginalElementSource()));
        }
        return builder.build();
    }

    private static boolean isExempt(ElementSource elementSource, String string2) {
        if (string2.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(string2);
        return StreamSupport.stream(BindingSourceRestriction.getAllModules(elementSource).spliterator(), false).anyMatch(string -> pattern.matcher((CharSequence)string).matches());
    }

    private static Iterable<String> getAllModules(ElementSource elementSource) {
        List<String> list = elementSource.getModuleClassNames();
        if (elementSource.getOriginalElementSource() == null || !elementSource.trustedOriginalElementSource) {
            return list;
        }
        return Iterables.concat(list, BindingSourceRestriction.getAllModules(elementSource.getOriginalElementSource()));
    }

    private static void clear(Element element) {
        element.acceptVisitor(new DefaultElementVisitor<Void>(){

            @Override
            protected Void visitOther(Element element) {
                Object object = element.getSource();
                if (object instanceof ElementSource) {
                    BindingSourceRestriction.clear((ElementSource)object);
                }
                return null;
            }

            @Override
            public Void visit(PrivateElements privateElements) {
                privateElements.getElements().forEach(element -> BindingSourceRestriction.clear(element));
                return null;
            }
        });
    }

    private static void clear(ElementSource elementSource) {
        while (elementSource != null) {
            elementSource.moduleSource.getPermitMap().clear();
            elementSource = elementSource.getOriginalElementSource();
        }
    }

    private static RestrictedBindingSource getRestriction(Key<?> key) {
        return key.getAnnotationType() == null ? key.getTypeLiteral().getRawType().getAnnotation(RestrictedBindingSource.class) : key.getAnnotationType().getAnnotation(RestrictedBindingSource.class);
    }

    private static Stream<Class<? extends Annotation>> getPermits(Class<?> clazz2) {
        Stream<Annotation> stream = Arrays.stream(clazz2.getAnnotations());
        if (clazz2.getAnnotatedSuperclass() != null) {
            stream = Stream.concat(stream, Arrays.stream(clazz2.getAnnotatedSuperclass().getAnnotations()));
        }
        return stream.map(Annotation::annotationType).filter(clazz -> clazz.isAnnotationPresent(RestrictedBindingSource.Permit.class));
    }

    static final class PermitMapConstruction {
        final Map<ModuleSource, ImmutableSet<Class<? extends Annotation>>> modulePermits = new HashMap<ModuleSource, ImmutableSet<Class<? extends Annotation>>>();
        ImmutableSet<Class<? extends Annotation>> currentModulePermits = ImmutableSet.of();
        final Deque<ImmutableSet<Class<? extends Annotation>>> modulePermitsStack = new ArrayDeque<ImmutableSet<Class<? extends Annotation>>>();
        final PermitMapImpl permitMap = new PermitMapImpl();

        PermitMapConstruction() {
        }

        PermitMap getPermitMap() {
            return this.permitMap;
        }

        void restoreCurrentModulePermits(ModuleSource moduleSource) {
            this.currentModulePermits = this.modulePermits.get(moduleSource);
        }

        void pushModule(Class<?> clazz2, ModuleSource moduleSource) {
            List list = BindingSourceRestriction.getPermits(clazz2).filter(clazz -> !this.currentModulePermits.contains(clazz)).collect(Collectors.toList());
            this.modulePermitsStack.push(this.currentModulePermits);
            if (!list.isEmpty()) {
                this.currentModulePermits = ImmutableSet.builder().addAll(this.currentModulePermits).addAll(list).build();
            }
            this.modulePermits.put(moduleSource, this.currentModulePermits);
        }

        void popModule() {
            this.currentModulePermits = this.modulePermitsStack.pop();
        }

        void finish() {
            this.permitMap.modulePermits = this.modulePermits;
        }

        @VisibleForTesting
        static boolean isElementSourceCleared(ElementSource elementSource) {
            PermitMapImpl permitMapImpl = (PermitMapImpl)elementSource.moduleSource.getPermitMap();
            return permitMapImpl.modulePermits == null;
        }

        private static final class PermitMapImpl
        implements PermitMap {
            Map<ModuleSource, ImmutableSet<Class<? extends Annotation>>> modulePermits;

            private PermitMapImpl() {
            }

            @Override
            public ImmutableSet<Class<? extends Annotation>> getPermits(ElementSource elementSource) {
                return this.modulePermits.get(elementSource.moduleSource);
            }

            @Override
            public void clear() {
                this.modulePermits = null;
            }
        }
    }

    static interface PermitMap {
        public ImmutableSet<Class<? extends Annotation>> getPermits(ElementSource var1);

        public void clear();
    }
}

