/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.ProviderWithDependencies;
import com.plotsquared.google.util.Types;
import java.util.Set;

public final class ProviderLookup<T>
implements Element {
    private final Object source;
    private final Dependency<T> dependency;
    private Provider<T> delegate;

    public ProviderLookup(Object object, Key<T> key) {
        this(object, Dependency.get((Key)Preconditions.checkNotNull(key, (Object)"key")));
    }

    public ProviderLookup(Object object, Dependency<T> dependency) {
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
        this.dependency = (Dependency)Preconditions.checkNotNull(dependency, (Object)"dependency");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.dependency.getKey();
    }

    public Dependency<T> getDependency() {
        return this.dependency;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> elementVisitor) {
        return elementVisitor.visit(this);
    }

    public void initializeDelegate(Provider<T> provider) {
        Preconditions.checkState((this.delegate == null ? 1 : 0) != 0, (Object)"delegate already initialized");
        this.delegate = (Provider)Preconditions.checkNotNull(provider, (Object)"delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getProvider(this.dependency));
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    public Provider<T> getProvider() {
        return new ProviderWithDependencies<T>(){

            @Override
            public T get() {
                Provider provider = ProviderLookup.this.delegate;
                if (provider == null) {
                    throw new IllegalStateException("This Provider cannot be used until the Injector has been created.");
                }
                return provider.get();
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                Key<?> key = ProviderLookup.this.getKey().ofType(Types.providerOf(ProviderLookup.this.getKey().getTypeLiteral().getType()));
                return ImmutableSet.of(Dependency.get(key));
            }

            public String toString() {
                return "Provider<" + ProviderLookup.this.getKey().getTypeLiteral() + ">";
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(ProviderLookup.class).add("dependency", this.dependency).add("source", Errors.convert(this.source)).toString();
    }

    public boolean equals(Object object) {
        return object instanceof ProviderLookup && ((ProviderLookup)object).dependency.equals(this.dependency) && ((ProviderLookup)object).source.equals(this.source);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dependency, this.source});
    }
}

