/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.spi;

import com.google.common.collect.ImmutableList;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.matcher.Matcher;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.ElementVisitor;
import com.plotsquared.google.spi.ProvisionListener;
import java.util.List;

public final class ProvisionListenerBinding
implements Element {
    private final Object source;
    private final Matcher<? super Binding<?>> bindingMatcher;
    private final List<ProvisionListener> listeners;

    ProvisionListenerBinding(Object object, Matcher<? super Binding<?>> matcher, ProvisionListener[] provisionListenerArray) {
        this.source = object;
        this.bindingMatcher = matcher;
        this.listeners = ImmutableList.copyOf((Object[])provisionListenerArray);
    }

    public List<ProvisionListener> getListeners() {
        return this.listeners;
    }

    public Matcher<? super Binding<?>> getBindingMatcher() {
        return this.bindingMatcher;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public <R> R acceptVisitor(ElementVisitor<R> elementVisitor) {
        return elementVisitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindListener(this.bindingMatcher, this.listeners.toArray(new ProvisionListener[this.listeners.size()]));
    }
}

