/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CheckReturnValue;
import com.plotsquared.google.AbstractModule;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.Module;
import com.plotsquared.google.PrivateBinder;
import com.plotsquared.google.Scope;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.spi.DefaultBindingScopingVisitor;
import com.plotsquared.google.spi.DefaultElementVisitor;
import com.plotsquared.google.spi.Element;
import com.plotsquared.google.spi.Elements;
import com.plotsquared.google.spi.ModuleAnnotatedMethodScannerBinding;
import com.plotsquared.google.spi.PrivateElements;
import com.plotsquared.google.spi.ScopeBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@CheckReturnValue
public final class Modules {
    public static final Module EMPTY_MODULE = new EmptyModule();

    private Modules() {
    }

    public static OverriddenModuleBuilder override(Module ... moduleArray) {
        return Modules.override(Arrays.asList(moduleArray));
    }

    @Deprecated
    public static OverriddenModuleBuilder override() {
        return Modules.override(Arrays.asList(new Module[0]));
    }

    public static OverriddenModuleBuilder override(Iterable<? extends Module> iterable) {
        return new RealOverriddenModuleBuilder(iterable);
    }

    public static Module combine(Module ... moduleArray) {
        return Modules.combine((Iterable<? extends Module>)ImmutableSet.copyOf((Object[])moduleArray));
    }

    @Deprecated
    public static Module combine(Module module) {
        return module;
    }

    @Deprecated
    public static Module combine() {
        return EMPTY_MODULE;
    }

    public static Module combine(Iterable<? extends Module> iterable) {
        return new CombinedModule(iterable);
    }

    private static Module extractScanners(Iterable<Element> iterable) {
        final ArrayList arrayList = Lists.newArrayList();
        DefaultElementVisitor<Void> defaultElementVisitor = new DefaultElementVisitor<Void>(){

            @Override
            public Void visit(ModuleAnnotatedMethodScannerBinding moduleAnnotatedMethodScannerBinding) {
                arrayList.add(moduleAnnotatedMethodScannerBinding);
                return null;
            }
        };
        for (Element element : iterable) {
            element.acceptVisitor(defaultElementVisitor);
        }
        return new AbstractModule(){

            @Override
            protected void configure() {
                for (ModuleAnnotatedMethodScannerBinding moduleAnnotatedMethodScannerBinding : arrayList) {
                    moduleAnnotatedMethodScannerBinding.applyTo(this.binder());
                }
            }
        };
    }

    public static Module requireExplicitBindingsModule() {
        return new RequireExplicitBindingsModule();
    }

    public static Module requireAtInjectOnConstructorsModule() {
        return new RequireAtInjectOnConstructorsModule();
    }

    public static Module requireExactBindingAnnotationsModule() {
        return new RequireExactBindingAnnotationsModule();
    }

    public static Module disableCircularProxiesModule() {
        return new DisableCircularProxiesModule();
    }

    private static final class DisableCircularProxiesModule
    implements Module {
        private DisableCircularProxiesModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.disableCircularProxies();
        }
    }

    private static final class RequireExactBindingAnnotationsModule
    implements Module {
        private RequireExactBindingAnnotationsModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.requireExactBindingAnnotations();
        }
    }

    private static final class RequireAtInjectOnConstructorsModule
    implements Module {
        private RequireAtInjectOnConstructorsModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.requireAtInjectOnConstructors();
        }
    }

    private static final class RequireExplicitBindingsModule
    implements Module {
        private RequireExplicitBindingsModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.requireExplicitBindings();
        }
    }

    private static class ModuleWriter
    extends DefaultElementVisitor<Void> {
        protected final Binder binder;

        ModuleWriter(Binder binder) {
            this.binder = binder.skipSources(this.getClass());
        }

        @Override
        protected Void visitOther(Element element) {
            element.applyTo(this.binder);
            return null;
        }

        void writeAll(Iterable<? extends Element> iterable) {
            for (Element element : iterable) {
                element.acceptVisitor(this);
            }
        }
    }

    static class OverrideModule
    extends AbstractModule {
        private final ImmutableSet<Module> overrides;
        private final ImmutableSet<Module> baseModules;

        OverrideModule(Iterable<? extends Module> iterable, ImmutableSet<Module> immutableSet) {
            this.overrides = ImmutableSet.copyOf(iterable);
            this.baseModules = immutableSet;
        }

        @Override
        public void configure() {
            Object object2;
            PrivateElements privateElements;
            Object object3;
            Object object4 = this.binder();
            List<Element> list = Elements.getElements(this.currentStage(), this.baseModules);
            if (list.size() == 1 && (object3 = (Element)Iterables.getOnlyElement(list)) instanceof PrivateElements) {
                privateElements = (PrivateElements)object3;
                object2 = object4.newPrivateBinder().withSource(privateElements.getSource());
                for (Key<?> object5 : privateElements.getExposedKeys()) {
                    object2.withSource(privateElements.getExposedSource(object5)).expose(object5);
                }
                object4 = object2;
                list = privateElements.getElements();
            }
            object3 = object4.skipSources(this.getClass());
            privateElements = ImmutableSet.copyOf(list);
            object2 = Modules.extractScanners((Iterable)((Object)privateElements));
            List<Element> list2 = Elements.getElements(this.currentStage(), (Iterable<? extends Module>)ImmutableList.builder().addAll(this.overrides).add(object2).build());
            final HashSet hashSet = Sets.newHashSet();
            final HashMap hashMap = Maps.newHashMap();
            new ModuleWriter(this, (Binder)object3){

                @Override
                public <T> Void visit(Binding<T> binding) {
                    hashSet.add(binding.getKey());
                    return (Void)super.visit(binding);
                }

                @Override
                public Void visit(ScopeBinding scopeBinding) {
                    hashMap.put(scopeBinding.getAnnotationType(), scopeBinding);
                    return (Void)super.visit(scopeBinding);
                }

                @Override
                public Void visit(PrivateElements privateElements) {
                    hashSet.addAll(privateElements.getExposedKeys());
                    return (Void)super.visit(privateElements);
                }
            }.writeAll((Iterable<? extends Element>)list2);
            final HashMap hashMap2 = Maps.newHashMap();
            final ArrayList arrayList = Lists.newArrayList();
            new ModuleWriter((Binder)object3){

                @Override
                public <T> Void visit(Binding<T> binding) {
                    if (!hashSet.remove(binding.getKey())) {
                        super.visit(binding);
                        Scope scope2 = this.getScopeInstanceOrNull(binding);
                        if (scope2 != null) {
                            hashMap2.computeIfAbsent(scope2, scope -> Lists.newArrayList()).add(binding.getSource());
                        }
                    }
                    return null;
                }

                void rewrite(Binder binder, PrivateElements privateElements, Set<Key<?>> set) {
                    PrivateBinder privateBinder = binder.withSource(privateElements.getSource()).newPrivateBinder();
                    HashSet hashSet2 = Sets.newHashSet();
                    for (Key<?> object : privateElements.getExposedKeys()) {
                        if (set.remove(object)) {
                            hashSet2.add(object);
                            continue;
                        }
                        privateBinder.withSource(privateElements.getExposedSource(object)).expose(object);
                    }
                    for (Element element : privateElements.getElements()) {
                        if (element instanceof Binding && hashSet2.remove(((Binding)element).getKey())) continue;
                        if (element instanceof PrivateElements) {
                            this.rewrite(privateBinder, (PrivateElements)element, hashSet2);
                            continue;
                        }
                        element.applyTo(privateBinder);
                    }
                }

                @Override
                public Void visit(PrivateElements privateElements) {
                    this.rewrite(this.binder, privateElements, hashSet);
                    return null;
                }

                @Override
                public Void visit(ScopeBinding scopeBinding) {
                    arrayList.add(scopeBinding);
                    return null;
                }
            }.writeAll((Iterable<? extends Element>)((Object)privateElements));
            new ModuleWriter(this, (Binder)object3){

                @Override
                public Void visit(ScopeBinding scopeBinding) {
                    ScopeBinding scopeBinding2 = (ScopeBinding)hashMap.remove(scopeBinding.getAnnotationType());
                    if (scopeBinding2 == null) {
                        super.visit(scopeBinding);
                    } else {
                        List list = (List)hashMap2.get(scopeBinding.getScope());
                        if (list != null) {
                            StringBuilder stringBuilder = new StringBuilder("The scope for @%s is bound directly and cannot be overridden.");
                            stringBuilder.append("\n     original binding at " + Errors.convert(scopeBinding.getSource()));
                            for (Object e : list) {
                                stringBuilder.append("\n     bound directly at " + Errors.convert(e) + "");
                            }
                            this.binder.withSource(scopeBinding2.getSource()).addError(stringBuilder.toString(), scopeBinding.getAnnotationType().getSimpleName());
                        }
                    }
                    return null;
                }
            }.writeAll(arrayList);
        }

        private Scope getScopeInstanceOrNull(Binding<?> binding) {
            return binding.acceptScopingVisitor(new DefaultBindingScopingVisitor<Scope>(this){

                @Override
                public Scope visitScope(Scope scope) {
                    return scope;
                }
            });
        }
    }

    private static final class RealOverriddenModuleBuilder
    implements OverriddenModuleBuilder {
        private final ImmutableSet<Module> baseModules;

        private RealOverriddenModuleBuilder(Iterable<? extends Module> iterable) {
            this.baseModules = ImmutableSet.copyOf(iterable);
        }

        @Override
        public Module with(Module ... moduleArray) {
            return this.with(Arrays.asList(moduleArray));
        }

        @Override
        public Module with() {
            return this.with(Arrays.asList(new Module[0]));
        }

        @Override
        public Module with(Iterable<? extends Module> iterable) {
            return new OverrideModule(iterable, this.baseModules);
        }
    }

    public static interface OverriddenModuleBuilder {
        public Module with(Module ... var1);

        @Deprecated
        public Module with();

        public Module with(Iterable<? extends Module> var1);
    }

    private static class CombinedModule
    implements Module {
        final Set<Module> modulesSet;

        CombinedModule(Iterable<? extends Module> iterable) {
            this.modulesSet = ImmutableSet.copyOf(iterable);
        }

        @Override
        public void configure(Binder binder) {
            binder = binder.skipSources(this.getClass());
            for (Module module : this.modulesSet) {
                binder.install(module);
            }
        }
    }

    private static class EmptyModule
    implements Module {
        private EmptyModule() {
        }

        @Override
        public void configure(Binder binder) {
        }
    }
}

