/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.DistanceCalculator;
import com.plotsquared.prtree.DistanceResult;
import com.plotsquared.prtree.MBR;
import com.plotsquared.prtree.MBRConverter;
import com.plotsquared.prtree.MinDist;
import com.plotsquared.prtree.MinDistComparator;
import com.plotsquared.prtree.Node;
import com.plotsquared.prtree.NodeBase;
import com.plotsquared.prtree.NodeFilter;
import java.util.List;
import java.util.PriorityQueue;

class InternalNode<T>
extends NodeBase<Node<T>, T> {
    public InternalNode(Object[] objectArray) {
        super(objectArray);
    }

    @Override
    public MBR computeMBR(MBRConverter<T> mBRConverter) {
        MBR mBR = null;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            mBR = this.getUnion(mBR, ((Node)this.get(i)).getMBR(mBRConverter));
        }
        return mBR;
    }

    @Override
    public void expand(MBR mBR, MBRConverter<T> mBRConverter, List<T> list, List<Node<T>> list2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.get(i);
            if (!mBR.intersects(node.getMBR(mBRConverter))) continue;
            list2.add(node);
        }
    }

    @Override
    public void find(MBR mBR, MBRConverter<T> mBRConverter, List<T> list) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.get(i);
            if (!mBR.intersects(node.getMBR(mBRConverter))) continue;
            node.find(mBR, mBRConverter, list);
        }
    }

    @Override
    public void nnExpand(DistanceCalculator<T> distanceCalculator, NodeFilter<T> nodeFilter, List<DistanceResult<T>> list, int n, PriorityQueue<Node<T>> priorityQueue, MinDistComparator<T, Node<T>> minDistComparator) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Node node = (Node)this.get(i);
            MBR mBR = node.getMBR(minDistComparator.converter);
            double d = MinDist.get(mBR, minDistComparator.p);
            int n3 = list.size();
            if (n3 >= n && !(d <= list.get(n3 - 1).getDistance())) continue;
            priorityQueue.add(node);
        }
    }
}

