/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.Circle;
import com.plotsquared.prtree.NodeComparators;
import com.plotsquared.prtree.NodeFactory;
import com.plotsquared.prtree.NodeUsage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class LeafBuilder {
    private final int dimensions;
    private final int branchFactor;

    public LeafBuilder(int n, int n2) {
        this.dimensions = n;
        this.branchFactor = n2;
    }

    public <T, N> void buildLeafs(Collection<? extends T> collection, NodeComparators<T> nodeComparators, NodeFactory<N> nodeFactory, List<N> list) {
        int n;
        ArrayList<NodeUsage<T>> arrayList = new ArrayList<NodeUsage<T>>(collection.size());
        for (T t : collection) {
            arrayList.add(new NodeUsage<T>(t, 1));
        }
        Circle circle = new Circle(this.dimensions * 2);
        for (n = 0; n < this.dimensions; ++n) {
            this.addGetterAndSplitter(arrayList, nodeComparators.getMinComparator(n), circle);
        }
        for (n = 0; n < this.dimensions; ++n) {
            this.addGetterAndSplitter(arrayList, nodeComparators.getMaxComparator(n), circle);
        }
        this.getLeafs(1, collection.size(), circle, nodeFactory, list);
    }

    private <T, N> void addGetterAndSplitter(List<NodeUsage<T>> list, Comparator<T> comparator, Circle<Noder<T, N>> circle) {
        NodeUsageComparator<T> nodeUsageComparator = new NodeUsageComparator<T>(comparator);
        Collections.sort(list, nodeUsageComparator);
        ArrayList<NodeUsage<T>> arrayList = new ArrayList<NodeUsage<T>>(list);
        circle.add(new Noder(arrayList));
    }

    private <T, N> void getLeafs(int n, int n2, Circle<Noder<T, N>> circle, NodeFactory<N> nodeFactory, List<N> list) {
        ArrayList<Partition> arrayList = new ArrayList<Partition>();
        int[] nArray = new int[2 * this.dimensions];
        arrayList.add(new Partition(n, n2, nArray));
        while (!arrayList.isEmpty()) {
            int n3;
            int n4;
            Partition partition = (Partition)arrayList.remove(0);
            circle.reset();
            for (n4 = 0; n4 < circle.getNumElements() && (n3 = Math.min(partition.numElementsLeft, this.branchFactor)) != 0; ++n4) {
                Noder<T, N> noder = circle.getNext();
                list.add(((Noder)noder).getNextNode(partition, n4, n3, nodeFactory));
                Partition partition2 = partition;
                partition2.numElementsLeft = partition2.numElementsLeft - n3;
            }
            if (partition.numElementsLeft <= 0) continue;
            n4 = this.getSplitPos(partition.id) % circle.getNumElements();
            Noder<T, N> noder = circle.get(n4);
            ((Noder)noder).split(partition, n4, partition.numElementsLeft, partition.id, 2 * partition.id, 2 * partition.id + 1, arrayList);
        }
    }

    private int getSplitPos(int n) {
        int n2 = 0;
        while (n >= 2) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    private static class Partition {
        private final int id;
        private int numElementsLeft;
        private int[] currentPositions;

        public Partition(int n, int n2, int[] nArray) {
            this.id = n;
            this.numElementsLeft = n2;
            this.currentPositions = nArray;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{id: " + this.id + ", numElementsLeft: " + this.numElementsLeft + ", currentPositions: " + Arrays.toString(this.currentPositions) + "}";
        }
    }

    private static class Noder<T, N> {
        private final List<NodeUsage<T>> data;

        private Noder(List<NodeUsage<T>> list) {
            this.data = list;
        }

        private N getNextNode(Partition partition, int n, int n2, NodeFactory<N> nodeFactory) {
            int n3;
            Object[] objectArray = new Object[n2];
            int n4 = this.data.size();
            for (n3 = 0; n3 < n2; ++n3) {
                while (partition.currentPositions[n] < n4 && this.isUsedNode(partition, partition.currentPositions[n])) {
                    int[] nArray = partition.currentPositions;
                    int n5 = n;
                    nArray[n5] = nArray[n5] + 1;
                }
                NodeUsage nodeUsage = this.data.set(partition.currentPositions[n], null);
                objectArray[n3] = nodeUsage.getData();
                nodeUsage.use();
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (objectArray[n3] != null) continue;
                for (int i = 0; i < this.data.size(); ++i) {
                    System.err.println(i + ": " + this.data.get(i));
                }
                throw new NullPointerException("Null data found at: " + n3);
            }
            return nodeFactory.create(objectArray);
        }

        private boolean isUsedNode(Partition partition, int n) {
            NodeUsage<T> nodeUsage = this.data.get(n);
            return nodeUsage == null || nodeUsage.isUsed() || nodeUsage.getOwner() != partition.id;
        }

        private void split(Partition partition, int n, int n2, int n3, int n4, int n5, List<Partition> list) {
            int n6 = n2 / 2;
            int n7 = n2 - n6;
            int n8 = partition.currentPositions[n];
            int n9 = this.markPart(n7, n3, n4, n8);
            this.markPart(n6, n3, n5, n9);
            list.add(0, new Partition(n4, n7, partition.currentPositions));
            int[] nArray = (int[])partition.currentPositions.clone();
            nArray[n] = n9;
            list.add(1, new Partition(n5, n6, nArray));
        }

        private int markPart(int n, int n2, int n3, int n4) {
            while (n > 0) {
                NodeUsage<T> nodeUsage;
                while ((nodeUsage = this.data.get(n4)) == null || nodeUsage.getOwner() != n2) {
                    ++n4;
                }
                nodeUsage.changeOwner(n3);
                --n;
            }
            return n4;
        }
    }

    private static class NodeUsageComparator<T>
    implements Comparator<NodeUsage<T>> {
        private Comparator<T> sorter;

        public NodeUsageComparator(Comparator<T> comparator) {
            this.sorter = comparator;
        }

        @Override
        public int compare(NodeUsage<T> nodeUsage, NodeUsage<T> nodeUsage2) {
            return this.sorter.compare(nodeUsage.getData(), nodeUsage2.getData());
        }
    }
}

