/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.MBR;
import com.plotsquared.prtree.MBRConverter;
import java.util.Arrays;

public class SimpleMBR
implements MBR {
    private final double[] values;

    private SimpleMBR(int n) {
        this.values = new double[n * 2];
    }

    public SimpleMBR(double ... dArray) {
        this.values = (double[])dArray.clone();
    }

    public <T> SimpleMBR(T t, MBRConverter<T> mBRConverter) {
        int n = mBRConverter.getDimensions();
        this.values = new double[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.values[n2++] = mBRConverter.getMin(i, t);
            this.values[n2++] = mBRConverter.getMax(i, t);
        }
    }

    @Override
    public int getDimensions() {
        return this.values.length / 2;
    }

    @Override
    public double getMin(int n) {
        return this.values[n * 2];
    }

    @Override
    public double getMax(int n) {
        return this.values[n * 2 + 1];
    }

    @Override
    public MBR union(MBR mBR) {
        int n = this.getDimensions();
        SimpleMBR simpleMBR = new SimpleMBR(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            simpleMBR.values[n2] = Math.min(this.getMin(i), mBR.getMin(i));
            simpleMBR.values[++n2] = Math.max(this.getMax(i), mBR.getMax(i));
            ++n2;
        }
        return simpleMBR;
    }

    @Override
    public boolean intersects(MBR mBR) {
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (!(mBR.getMax(i) < this.getMin(i)) && !(mBR.getMin(i) > this.getMax(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean intersects(T t, MBRConverter<T> mBRConverter) {
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (!(mBRConverter.getMax(i, t) < this.getMin(i)) && !(mBRConverter.getMin(i, t) > this.getMax(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{values: " + Arrays.toString(this.values) + "}";
    }
}

