/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.util.TimeDateUtils;
import cc.carm.lib.easysql.hikari.HikariConfig;
import cc.carm.lib.easysql.hikari.HikariDataSource;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EasySQL {
    public static SQLManagerImpl createManager(@NotNull String string, @NotNull String string2, @NotNull String string3, @Nullable String string4) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(string);
        hikariConfig.setJdbcUrl(string2);
        hikariConfig.setUsername(string3);
        hikariConfig.setPassword(string4);
        return EasySQL.createManager(hikariConfig);
    }

    public static SQLManagerImpl createManager(@NotNull Properties properties) {
        return EasySQL.createManager(new HikariConfig(properties));
    }

    public static SQLManagerImpl createManager(@NotNull HikariConfig hikariConfig) {
        return new SQLManagerImpl(new HikariDataSource(hikariConfig));
    }

    public static void shutdownManager(SQLManager sQLManager, boolean bl, boolean bl2) {
        if (!sQLManager.getActiveQuery().isEmpty()) {
            sQLManager.getLogger().warn("There are " + sQLManager.getActiveQuery().size() + " connections still running");
            for (SQLQuery sQLQuery : sQLManager.getActiveQuery().values()) {
                if (bl2) {
                    sQLManager.getLogger().warn(String.format("#%s -> %s", sQLQuery.getAction().getShortID(), sQLQuery.getSQLContent()));
                    sQLManager.getLogger().warn(String.format("- execute at %s", TimeDateUtils.getTimeString(sQLQuery.getExecuteTime())));
                }
                if (!bl) continue;
                sQLQuery.close();
            }
        }
        if (sQLManager.getDataSource() instanceof HikariDataSource) {
            ((HikariDataSource)sQLManager.getDataSource()).close();
        }
    }

    public static void shutdownManager(SQLManager sQLManager) {
        EasySQL.shutdownManager(sQLManager, true, sQLManager.isDebugMode());
    }
}

