/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.action.query;

import cc.carm.lib.easysql.action.AbstractSQLAction;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.query.QueryAction;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import cc.carm.lib.easysql.query.SQLQueryImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class QueryActionImpl
extends AbstractSQLAction<SQLQuery>
implements QueryAction {
    public QueryActionImpl(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string) {
        super(sQLManagerImpl, string);
    }

    @Override
    @NotNull
    public SQLQueryImpl execute() {
        Statement statement;
        this.debugMessage(new ArrayList<Object[]>());
        Connection connection = this.getManager().getConnection();
        try {
            statement = connection.createStatement();
        }
        catch (SQLException sQLException) {
            connection.close();
            throw sQLException;
        }
        try {
            SQLQueryImpl sQLQueryImpl = new SQLQueryImpl(this.getManager(), this, connection, statement, statement.executeQuery(this.getSQLContent()));
            this.getManager().getActiveQuery().put(this.getActionUUID(), sQLQueryImpl);
            return sQLQueryImpl;
        }
        catch (SQLException sQLException) {
            statement.close();
            connection.close();
            throw sQLException;
        }
    }

    @Override
    public void executeAsync(SQLHandler<SQLQuery> sQLHandler, SQLExceptionHandler sQLExceptionHandler) {
        this.getManager().getExecutorPool().submit(() -> {
            try (SQLQueryImpl sQLQueryImpl = this.execute();){
                if (sQLHandler != null) {
                    sQLHandler.accept(sQLQueryImpl);
                }
            }
            catch (SQLException sQLException) {
                this.handleException(sQLExceptionHandler, sQLException);
            }
        });
    }
}

