/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.api;

import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateBatchAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.InsertBuilder;
import cc.carm.lib.easysql.api.builder.ReplaceBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.api.function.SQLHandler;
import cc.carm.lib.easysql.api.table.NamedSQLTable;
import java.sql.SQLException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SQLTable {
    @NotNull
    public static NamedSQLTable of(@NotNull String tableName, final @Nullable SQLHandler<TableCreateBuilder> table) {
        return new NamedSQLTable(tableName){

            @Override
            public boolean create(@NotNull SQLManager sQLManager, String string) {
                if (this.manager == null) {
                    this.manager = sQLManager;
                }
                this.tablePrefix = string;
                TableCreateBuilder tableCreateBuilder = sQLManager.createTable(this.getTableName());
                if (table != null) {
                    table.accept(tableCreateBuilder);
                }
                return tableCreateBuilder.build().executeFunction(n -> n > 0, false);
            }
        };
    }

    @NotNull
    public static NamedSQLTable of(@NotNull String tableName, @NotNull String[] columns) {
        return SQLTable.of(tableName, columns, null);
    }

    @NotNull
    public static NamedSQLTable of(@NotNull String tableName, @NotNull String[] columns, @Nullable String tableSettings) {
        return SQLTable.of(tableName, builder -> {
            builder.setColumns(columns);
            if (tableSettings != null) {
                builder.setTableSettings(tableSettings);
            }
        });
    }

    public boolean create(SQLManager var1) throws SQLException;

    @Nullable
    public SQLManager getSQLManager();

    @NotNull
    public String getTableName();

    @NotNull
    default public TableQueryBuilder createQuery() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createQuery).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public TableQueryBuilder createQuery(@NotNull SQLManager sqlManager) {
        return sqlManager.createQuery().inTable(this.getTableName());
    }

    @NotNull
    default public DeleteBuilder createDelete() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createDelete).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public DeleteBuilder createDelete(@NotNull SQLManager sqlManager) {
        return sqlManager.createDelete(this.getTableName());
    }

    @NotNull
    default public UpdateBuilder createUpdate() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createUpdate).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public UpdateBuilder createUpdate(@NotNull SQLManager sqlManager) {
        return sqlManager.createUpdate(this.getTableName());
    }

    @NotNull
    default public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createInsert).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert(@NotNull SQLManager sqlManager) {
        return sqlManager.createInsert(this.getTableName());
    }

    @NotNull
    default public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createInsertBatch).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch(@NotNull SQLManager sqlManager) {
        return sqlManager.createInsertBatch(this.getTableName());
    }

    @NotNull
    default public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createReplace).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace(@NotNull SQLManager sqlManager) {
        return sqlManager.createReplace(this.getTableName());
    }

    @NotNull
    default public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch() {
        return Optional.ofNullable(this.getSQLManager()).map(this::createReplaceBatch).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch(@NotNull SQLManager sqlManager) {
        return sqlManager.createReplaceBatch(this.getTableName());
    }

    @NotNull
    default public TableAlterBuilder alter() {
        return Optional.ofNullable(this.getSQLManager()).map(this::alter).orElseThrow(() -> new NullPointerException("This table doesn't have a SQLManger."));
    }

    @NotNull
    default public TableAlterBuilder alter(@NotNull SQLManager sqlManager) {
        return sqlManager.alterTable(this.getTableName());
    }
}

