/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.builder.InsertBuilder;
import cc.carm.lib.easysql.builder.AbstractSQLBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class InsertBuilderImpl<T extends SQLAction<?>>
extends AbstractSQLBuilder
implements InsertBuilder<T> {
    protected final String tableName;

    public InsertBuilderImpl(@NotNull SQLManagerImpl sQLManagerImpl, String string) {
        super(sQLManagerImpl);
        Objects.requireNonNull(string);
        this.tableName = string;
    }

    protected static String buildSQL(String string, List<String> list) {
        return InsertBuilderImpl.buildSQL("INSERT IGNORE INTO", string, list);
    }

    protected static String buildSQL(String string, String string2, List<String> list) {
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(" ").append(SQLBuilder.withBackQuote(string2)).append("(");
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(SQLBuilder.withBackQuote(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(") VALUES (");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("?");
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }
}

