/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.SQLUpdateActionImpl;
import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.enums.IndexType;
import cc.carm.lib.easysql.builder.AbstractSQLBuilder;
import cc.carm.lib.easysql.builder.impl.TableCreateBuilderImpl;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableAlterBuilderImpl
extends AbstractSQLBuilder
implements TableAlterBuilder {
    @NotNull
    protected final String tableName;

    public TableAlterBuilderImpl(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string) {
        super(sQLManagerImpl);
        this.tableName = string;
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public SQLAction<Integer> renameTo(@NotNull String string) {
        Objects.requireNonNull(string, "table name could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.tableName) + " RENAME TO " + SQLBuilder.withBackQuote(string));
    }

    @Override
    public SQLAction<Integer> changeComment(@NotNull String string) {
        Objects.requireNonNull(string, "table comment could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " COMMENT " + SQLBuilder.withQuote(string));
    }

    @Override
    public SQLAction<Integer> setAutoIncrementIndex(int n) {
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " AUTO_INCREMENT=" + n);
    }

    @Override
    public SQLAction<Integer> addIndex(@NotNull IndexType indexType, @Nullable String string, @NotNull String string2, String ... stringArray) {
        Objects.requireNonNull(indexType, "indexType could not be null");
        Objects.requireNonNull(string2, "column names could not be null");
        Objects.requireNonNull(stringArray, "column names could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ADD " + TableCreateBuilderImpl.buildIndexSettings(indexType, string, string2, stringArray));
    }

    @Override
    public SQLAction<Integer> dropIndex(@NotNull String string) {
        Objects.requireNonNull(string, "indexName could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP INDEX " + SQLBuilder.withBackQuote(string));
    }

    @Override
    public SQLAction<Integer> dropForeignKey(@NotNull String string) {
        Objects.requireNonNull(string, "keySymbol could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP FOREIGN KEY " + SQLBuilder.withBackQuote(string));
    }

    @Override
    public SQLAction<Integer> dropPrimaryKey() {
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP PRIMARY KEY");
    }

    @Override
    public SQLAction<Integer> addColumn(@NotNull String string, @NotNull String string2, @Nullable String string3) {
        Objects.requireNonNull(string, "columnName could not be null");
        Objects.requireNonNull(string2, "settings could not be null");
        String string4 = null;
        if (string3 != null) {
            string4 = string3.length() > 0 ? "AFTER " + SQLBuilder.withBackQuote(string3) : "FIRST";
        }
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ADD " + SQLBuilder.withBackQuote(string) + " " + string2 + (string4 != null ? " " + string4 : ""));
    }

    @Override
    public SQLAction<Integer> renameColumn(@NotNull String string, @NotNull String string2) {
        Objects.requireNonNull(string, "columnName could not be null");
        Objects.requireNonNull(string2, "please specify new column name");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " RENAME COLUMN " + SQLBuilder.withBackQuote(string) + " TO " + SQLBuilder.withBackQuote(string2));
    }

    @Override
    public SQLAction<Integer> modifyColumn(@NotNull String string, @NotNull String string2) {
        Objects.requireNonNull(string, "columnName could not be null");
        Objects.requireNonNull(string2, "please specify new column settings");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " MODIFY COLUMN " + SQLBuilder.withBackQuote(string) + " " + string2);
    }

    @Override
    public SQLAction<Integer> removeColumn(@NotNull String string) {
        Objects.requireNonNull(string, "columnName could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " DROP " + SQLBuilder.withBackQuote(string));
    }

    @Override
    public SQLAction<Integer> setColumnDefault(@NotNull String string, @NotNull String string2) {
        Objects.requireNonNull(string, "columnName could not be null");
        Objects.requireNonNull(string2, "defaultValue could not be null, if you need to remove the default value, please use #removeColumnDefault().");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ALTER " + SQLBuilder.withBackQuote(string) + " SET DEFAULT " + string2);
    }

    @Override
    public SQLAction<Integer> removeColumnDefault(@NotNull String string) {
        Objects.requireNonNull(string, "columnName could not be null");
        return this.createAction("ALTER TABLE " + SQLBuilder.withBackQuote(this.getTableName()) + " ALTER " + SQLBuilder.withBackQuote(string) + " DROP DEFAULT");
    }

    private SQLUpdateActionImpl<Integer> createAction(@NotNull String string) {
        return new SQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, string);
    }
}

