/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.builder.impl;

import cc.carm.lib.easysql.action.PreparedSQLUpdateActionImpl;
import cc.carm.lib.easysql.api.SQLAction;
import cc.carm.lib.easysql.api.SQLBuilder;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.builder.impl.AbstractConditionalBuilder;
import cc.carm.lib.easysql.manager.SQLManagerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateBuilderImpl
extends AbstractConditionalBuilder<UpdateBuilder, SQLAction<Integer>>
implements UpdateBuilder {
    @NotNull
    protected final String tableName;
    @NotNull
    LinkedHashMap<String, Object> columnData;

    public UpdateBuilderImpl(@NotNull SQLManagerImpl sQLManagerImpl, @NotNull String string) {
        super(sQLManagerImpl);
        this.tableName = string;
        this.columnData = new LinkedHashMap();
    }

    @Override
    public PreparedSQLUpdateAction<Integer> build() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ").append(SQLBuilder.withBackQuote(this.getTableName())).append(" SET ");
        Iterator<String> iterator = this.columnData.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(SQLBuilder.withBackQuote(iterator.next())).append(" = ?");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" , ");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.columnData.values());
        if (this.hasConditions()) {
            stringBuilder.append(" ").append(this.buildConditionSQL());
            arrayList.addAll(this.getConditionParams());
        }
        if (this.limit > 0) {
            stringBuilder.append(" ").append(this.buildLimitSQL());
        }
        return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, stringBuilder.toString(), arrayList);
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public UpdateBuilder addColumnValue(@NotNull String string, Object object) {
        Objects.requireNonNull(string, "columnName could not be null");
        this.columnData.put(string, object);
        return this;
    }

    @Override
    public UpdateBuilder setColumnValues(LinkedHashMap<String, Object> linkedHashMap) {
        this.columnData = linkedHashMap;
        return this;
    }

    @Override
    public UpdateBuilder setColumnValues(@NotNull String[] stringArray, @Nullable Object[] objectArray) {
        Objects.requireNonNull(stringArray, "columnName could not be null");
        if (stringArray.length != objectArray.length) {
            throw new RuntimeException("columnNames are not match with columnValues");
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashMap.put(stringArray[i], objectArray[i]);
        }
        return this.setColumnValues(linkedHashMap);
    }

    @Override
    protected UpdateBuilder getThis() {
        return this;
    }
}

