/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.manager;

import cc.carm.lib.easysql.action.PreparedSQLBatchUpdateActionImpl;
import cc.carm.lib.easysql.action.PreparedSQLUpdateActionImpl;
import cc.carm.lib.easysql.action.SQLUpdateActionImpl;
import cc.carm.lib.easysql.action.SQLUpdateBatchActionImpl;
import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateAction;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateBatchAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.InsertBuilder;
import cc.carm.lib.easysql.api.builder.QueryBuilder;
import cc.carm.lib.easysql.api.builder.ReplaceBuilder;
import cc.carm.lib.easysql.api.builder.TableAlterBuilder;
import cc.carm.lib.easysql.api.builder.TableCreateBuilder;
import cc.carm.lib.easysql.api.builder.UpdateBuilder;
import cc.carm.lib.easysql.api.function.SQLDebugHandler;
import cc.carm.lib.easysql.api.function.SQLExceptionHandler;
import cc.carm.lib.easysql.builder.impl.DeleteBuilderImpl;
import cc.carm.lib.easysql.builder.impl.InsertBuilderImpl;
import cc.carm.lib.easysql.builder.impl.QueryBuilderImpl;
import cc.carm.lib.easysql.builder.impl.ReplaceBuilderImpl;
import cc.carm.lib.easysql.builder.impl.TableAlterBuilderImpl;
import cc.carm.lib.easysql.builder.impl.TableCreateBuilderImpl;
import cc.carm.lib.easysql.builder.impl.UpdateBuilderImpl;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLManagerImpl
implements SQLManager {
    private final Logger LOGGER;
    private final DataSource dataSource;
    private final ConcurrentHashMap<UUID, SQLQuery> activeQuery = new ConcurrentHashMap();
    protected ExecutorService executorPool;
    @NotNull
    Supplier<Boolean> debugMode = () -> Boolean.FALSE;
    @NotNull
    SQLExceptionHandler exceptionHandler;
    @NotNull
    SQLDebugHandler debugHandler;

    public SQLManagerImpl(@NotNull DataSource dataSource) {
        this(dataSource, null);
    }

    public SQLManagerImpl(@NotNull DataSource dataSource, @Nullable String string) {
        this(dataSource, LoggerFactory.getLogger(SQLManagerImpl.class), string);
    }

    public SQLManagerImpl(@NotNull DataSource dataSource, @NotNull Logger logger, @Nullable String string) {
        String string2 = "SQLManager" + (string != null ? "#" + string : "");
        this.LOGGER = logger;
        this.dataSource = dataSource;
        this.executorPool = Executors.newFixedThreadPool(3, runnable -> {
            Thread thread = new Thread(runnable, string2);
            thread.setDaemon(true);
            return thread;
        });
        this.exceptionHandler = SQLExceptionHandler.detailed(this.getLogger());
        this.debugHandler = SQLDebugHandler.defaultHandler(this.getLogger());
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode.get();
    }

    @Override
    public void setDebugMode(@NotNull @NotNull Supplier<@NotNull Boolean> supplier) {
        this.debugMode = supplier;
    }

    @Override
    @NotNull
    public SQLDebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    @Override
    public void setDebugHandler(@NotNull SQLDebugHandler sQLDebugHandler) {
        this.debugHandler = sQLDebugHandler;
    }

    public void debug(String string) {
        if (this.isDebugMode()) {
            this.getLogger().info("[DEBUG] " + string);
        }
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    @NotNull
    public ExecutorService getExecutorPool() {
        return this.executorPool;
    }

    @Override
    public void setExecutorPool(@NotNull ExecutorService executorService) {
        this.executorPool = executorService;
    }

    @Override
    @NotNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public Connection getConnection() {
        return this.getDataSource().getConnection();
    }

    @Override
    @NotNull
    public Map<UUID, SQLQuery> getActiveQuery() {
        return this.activeQuery;
    }

    @Override
    @NotNull
    public SQLExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(@Nullable SQLExceptionHandler sQLExceptionHandler) {
        this.exceptionHandler = sQLExceptionHandler == null ? SQLExceptionHandler.detailed(this.getLogger()) : sQLExceptionHandler;
    }

    @Override
    public Integer executeSQL(String string) {
        return (Integer)new SQLUpdateActionImpl<Integer>(this, Integer.class, string).execute(null);
    }

    @Override
    public Integer executeSQL(String string, Object[] objectArray) {
        return (Integer)new PreparedSQLUpdateActionImpl<Integer>(this, Integer.class, string, objectArray).execute(null);
    }

    @Override
    public List<Integer> executeSQLBatch(String string, Iterable<Object[]> iterable) {
        return (List)new PreparedSQLBatchUpdateActionImpl<Integer>(this, Integer.class, string).setAllParams((Iterable)iterable).execute(null);
    }

    @Override
    public List<Integer> executeSQLBatch(@NotNull String string, String ... stringArray) {
        SQLUpdateBatchActionImpl sQLUpdateBatchActionImpl = new SQLUpdateBatchActionImpl(this, string);
        if (stringArray != null && stringArray.length > 0) {
            Arrays.stream(stringArray).forEach(sQLUpdateBatchActionImpl::addBatch);
        }
        return (List)sQLUpdateBatchActionImpl.execute(null);
    }

    @Override
    @Nullable
    public List<Integer> executeSQLBatch(@NotNull Iterable<String> iterable) {
        Iterator<String> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        SQLUpdateBatchActionImpl sQLUpdateBatchActionImpl = new SQLUpdateBatchActionImpl(this, iterator.next());
        while (iterator.hasNext()) {
            sQLUpdateBatchActionImpl.addBatch(iterator.next());
        }
        return (List)sQLUpdateBatchActionImpl.execute(null);
    }

    @Override
    public TableCreateBuilder createTable(@NotNull String string) {
        return new TableCreateBuilderImpl(this, string);
    }

    @Override
    public TableAlterBuilder alterTable(@NotNull String string) {
        return new TableAlterBuilderImpl(this, string);
    }

    @Override
    public QueryBuilder createQuery() {
        return new QueryBuilderImpl(this);
    }

    @Override
    public InsertBuilder<PreparedSQLUpdateBatchAction<Integer>> createInsertBatch(@NotNull String string) {
        return new InsertBuilderImpl<PreparedSQLUpdateBatchAction<Integer>>(this, string){

            @Override
            public PreparedSQLUpdateBatchAction<Integer> setColumnNames(List<String> list) {
                return new PreparedSQLBatchUpdateActionImpl<Integer>(this.getManager(), Integer.class, 1.buildSQL(this.getTableName(), list));
            }
        };
    }

    @Override
    public InsertBuilder<PreparedSQLUpdateAction<Integer>> createInsert(@NotNull String string) {
        return new InsertBuilderImpl<PreparedSQLUpdateAction<Integer>>(this, string){

            @Override
            public PreparedSQLUpdateAction<Integer> setColumnNames(List<String> list) {
                return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, 2.buildSQL(this.getTableName(), list));
            }
        };
    }

    @Override
    public ReplaceBuilder<PreparedSQLUpdateBatchAction<Integer>> createReplaceBatch(@NotNull String string) {
        return new ReplaceBuilderImpl<PreparedSQLUpdateBatchAction<Integer>>(this, string){

            @Override
            public PreparedSQLUpdateBatchAction<Integer> setColumnNames(List<String> list) {
                return new PreparedSQLBatchUpdateActionImpl<Integer>(this.getManager(), Integer.class, 3.buildSQL(this.getTableName(), list));
            }
        };
    }

    @Override
    public ReplaceBuilder<PreparedSQLUpdateAction<Integer>> createReplace(@NotNull String string) {
        return new ReplaceBuilderImpl<PreparedSQLUpdateAction<Integer>>(this, string){

            @Override
            public PreparedSQLUpdateAction<Integer> setColumnNames(List<String> list) {
                return new PreparedSQLUpdateActionImpl<Integer>(this.getManager(), Integer.class, 4.buildSQL(this.getTableName(), list));
            }
        };
    }

    @Override
    public UpdateBuilder createUpdate(@NotNull String string) {
        return new UpdateBuilderImpl(this, string);
    }

    @Override
    public DeleteBuilder createDelete(@NotNull String string) {
        return new DeleteBuilderImpl(this, string);
    }
}

