/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.easysql.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StatementUtil {
    public static PreparedStatement createPrepareStatement(Connection connection, String string, Object[] objectArray) {
        return StatementUtil.createPrepareStatement(connection, string, objectArray, false);
    }

    public static PreparedStatement createPrepareStatement(Connection connection, String string, Object[] objectArray, boolean bl) {
        string = string.trim();
        PreparedStatement preparedStatement = connection.prepareStatement(string, bl ? 1 : 2);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (objectArray != null) {
            StatementUtil.fillParams(preparedStatement, Arrays.asList(objectArray), hashMap);
        }
        preparedStatement.addBatch();
        return preparedStatement;
    }

    public static PreparedStatement createPrepareStatementBatch(Connection connection, String string, Iterable<Object[]> iterable) {
        return StatementUtil.createPrepareStatementBatch(connection, string, iterable, false);
    }

    public static PreparedStatement createPrepareStatementBatch(Connection connection, String string, Iterable<Object[]> iterable, boolean bl) {
        string = string.trim();
        PreparedStatement preparedStatement = connection.prepareStatement(string, bl ? 1 : 2);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Object[] objectArray : iterable) {
            StatementUtil.fillParams(preparedStatement, Arrays.asList(objectArray), hashMap);
            preparedStatement.addBatch();
        }
        return preparedStatement;
    }

    public static PreparedStatement fillParams(PreparedStatement preparedStatement, Iterable<?> iterable) {
        return StatementUtil.fillParams(preparedStatement, iterable, null);
    }

    public static PreparedStatement fillParams(PreparedStatement preparedStatement, Iterable<?> iterable, Map<Integer, Integer> map) {
        if (null == iterable) {
            return preparedStatement;
        }
        int n = 1;
        for (Object obj : iterable) {
            StatementUtil.setParam(preparedStatement, n++, obj, map);
        }
        return preparedStatement;
    }

    public static int getNullType(PreparedStatement preparedStatement, int n) {
        try {
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            return parameterMetaData.getParameterType(n);
        }
        catch (SQLException sQLException) {
            return 12;
        }
    }

    private static void setParam(PreparedStatement preparedStatement, int n, Object object, Map<Integer, Integer> map) {
        if (object == null) {
            Integer n2;
            Integer n3 = n2 = null == map ? null : map.get(n);
            if (null == n2) {
                n2 = StatementUtil.getNullType(preparedStatement, n);
                if (null != map) {
                    map.put(n, n2);
                }
            }
            preparedStatement.setNull(n, n2);
        }
        if (object instanceof UUID) {
            preparedStatement.setString(n, object.toString());
            return;
        }
        if (object instanceof StringBuilder || object instanceof StringBuffer) {
            preparedStatement.setString(n, object.toString());
            return;
        }
        if (object instanceof Date) {
            if (object instanceof java.sql.Date) {
                preparedStatement.setDate(n, (java.sql.Date)object);
            } else if (object instanceof Time) {
                preparedStatement.setTime(n, (Time)object);
            } else {
                preparedStatement.setTimestamp(n, new Timestamp(((Date)object).getTime()));
            }
            return;
        }
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                preparedStatement.setBigDecimal(n, (BigDecimal)object);
                return;
            }
            if (object instanceof BigInteger) {
                preparedStatement.setBigDecimal(n, new BigDecimal((BigInteger)object));
                return;
            }
        }
        if (object instanceof Enum) {
            preparedStatement.setString(n, ((Enum)object).name());
            return;
        }
        preparedStatement.setObject(n, object);
    }
}

