/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.manager;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.gui.DisplayGui;
import cn.myrealm.flipcard.gui.InvGui;
import cn.myrealm.flipcard.gui.MainGui;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.manager.RewardManager;
import cn.myrealm.flipcard.util.Card;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimateManager {
    public static int animate(MainGui mainGui, int n, Card card, String string) {
        mainGui.getPlayer().playSound(mainGui.getPlayer().getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 10.0f, 1.0f);
        List<Integer> list = card.getAnimateFrame();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            AnimateManager.DoAnimateTask(mainGui, n, card, i, string);
        }
        AnimateManager.DoAwardCardTask(mainGui, n, card, n2 * 2 - 2, true);
        RewardManager.showReward(mainGui, n, mainGui.getAwardItemStackBySlot(n), mainGui.getAwardBySlot(n).getEdge(), n2 * 2 - 2);
        RewardManager.doFlipActions(mainGui.getAwardBySlot(n), n2 * 2 - 2);
        RewardManager.sendAnnouncement(mainGui.getAwardBySlot(n), n2 * 2 - 2);
        return n2 * 2;
    }

    public static void failAnimate(MainGui mainGui, int n, Card card, String string) {
        mainGui.getPlayer().playSound(mainGui.getPlayer().getLocation(), Sound.ITEM_BOOK_PUT, 10.0f, 1.0f);
        List<Integer> list = card.getFailAnimateFrame();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            AnimateManager.DoFailAnimateTask(mainGui, n, card, i, string);
        }
        AnimateManager.DoGuiRefreshTask(mainGui, n2 * 2 - 2);
    }

    private static void DoAnimateTask(final InvGui invGui, final int n, Card card, final int n2, final String string) {
        final List<Integer> list = card.getAnimateFrame();
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                ItemStack itemStack = invGui.getInv().getItem(n);
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setCustomModelData((Integer)list.get(n2));
                itemMeta.setDisplayName(LanguageManager.getText("animation-flipping"));
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(FlipCard.parseColor("&f" + string));
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
                invGui.getInv().setItem(n, itemStack);
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)(n2 * 2));
    }

    private static void DoFailAnimateTask(final InvGui invGui, final int n, Card card, final int n2, final String string) {
        final List<Integer> list = card.getFailAnimateFrame();
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                ItemStack itemStack = invGui.getInv().getItem(n);
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setCustomModelData((Integer)list.get(n2));
                itemMeta.setDisplayName(LanguageManager.getText("animation-flip-fail"));
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(FlipCard.parseColor("&f" + string));
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
                invGui.getInv().setItem(n, itemStack);
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)(n2 * 2));
    }

    private static void DoAwardCardTask(final InvGui invGui, final int n, final Card card, int n2, final boolean bl) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                RewardManager.AwardCardHandel(invGui.getInv(), n, card);
                if (bl) {
                    invGui.getPlayer().playSound(invGui.getPlayer().getLocation(), Sound.BLOCK_WOOD_PLACE, 10.0f, 1.0f);
                    invGui.getPlayer().playSound(invGui.getPlayer().getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                }
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)n2);
    }

    private static void DoGuiRefreshTask(final MainGui mainGui, int n) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                mainGui.refreshGui();
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)n);
    }

    public static void displayAnimate1(DisplayGui displayGui) {
        List<Integer> list = displayGui.getUsedSlotList();
        for (int n : list) {
            Card card = displayGui.getMainGui().getCardBySlot(n);
            int n2 = card.getAnimateFrame().size();
            for (int i = 0; i < n2; ++i) {
                AnimateManager.DoDisplayAnimate1Task(displayGui, n, card, i);
            }
            AnimateManager.DoAwardCardTask(displayGui, n, card, n2 * 2 - 2, false);
            RewardManager.showReward(displayGui, n, displayGui.getAwardItemStackBySlot(n), displayGui.getAwardBySlot(n).getEdge(), n2 * 2 - 2);
        }
    }

    public static void closeAnimate(MainGui mainGui, int n, Card card) {
        int n2 = card.getAnimateFrame().size();
        for (int i = 0; i < n2; ++i) {
            AnimateManager.DoDisplayAnimate1Task(mainGui, n, card, i);
        }
        AnimateManager.DoAwardCardTask(mainGui, n, card, n2 * 2 - 2, false);
        RewardManager.showReward(mainGui, n, mainGui.getAwardItemStackBySlot(n), mainGui.getAwardBySlot(n).getEdge(), n2 * 2 - 2);
    }

    private static void DoDisplayAnimate1Task(final InvGui invGui, final int n, Card card, final int n2) {
        final List<Integer> list = card.getAnimateFrame();
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                ItemStack itemStack = invGui.getInv().getItem(n);
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setCustomModelData((Integer)list.get(n2));
                itemMeta.setDisplayName(" ");
                itemMeta.setLore(null);
                itemStack.setItemMeta(itemMeta);
                invGui.getInv().setItem(n, itemStack);
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)(n2 * 2));
    }

    public static void displayAnimate2(DisplayGui displayGui) {
        List<Integer> list = displayGui.getUsedSlotList();
        for (int n : list) {
            Card card = displayGui.getMainGui().getCardBySlot(n);
            int n2 = card.getAnimateFrame().size();
            displayGui.getInv().setItem(n - 9, null);
            displayGui.getInv().setItem(n + 9, null);
            displayGui.getInv().setItem(n, card.getItemStack());
            for (int i = 0; i < n2; ++i) {
                AnimateManager.DoDisplayAnimate2Task(displayGui, n, card, i);
            }
        }
    }

    private static void DoDisplayAnimate2Task(final InvGui invGui, final int n, Card card, final int n2) {
        final List<Integer> list = card.getAnimateFrame();
        Collections.reverse(list);
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                ItemStack itemStack = invGui.getInv().getItem(n);
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setCustomModelData((Integer)list.get(n2));
                itemMeta.setDisplayName(" ");
                itemMeta.setLore(null);
                itemStack.setItemMeta(itemMeta);
                invGui.getInv().setItem(n, itemStack);
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)(n2 * 2));
    }

    public static void DisplayCloseAnimateTask(Player player) {
        player.sendTitle(LanguageManager.getText("animation-shuffling"), "", 1, 20, 1);
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0, true, false));
        player.playSound(player.getLocation(), Sound.ENTITY_SPLASH_POTION_BREAK, 10.0f, 1.0f);
        for (int i = 0; i < 5; ++i) {
            AnimateManager.DoWashingSoundTask(player, i);
        }
    }

    private static void DoWashingSoundTask(final Player player, int n) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                player.playSound(player.getLocation(), Sound.BLOCK_DISPENSER_DISPENSE, 10.0f, 1.0f);
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)(n * 2));
    }
}

