/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.manager;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.util.Cache;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerCacheManager {
    private static PlayerCacheManager playerCacheManager = new PlayerCacheManager();
    private static Map<Player, Cache> playerCacheMap;

    public static void reload() {
        if (!ConfigManager.getMySQL() && Objects.nonNull(playerCacheMap) && !playerCacheMap.isEmpty()) {
            for (Player player2 : playerCacheMap.keySet()) {
                PlayerCacheManager.savePlayerCache(player2);
            }
        }
        playerCacheMap = new HashMap<Player, Cache>();
        Bukkit.getOnlinePlayers().forEach(player -> PlayerCacheManager.addPlayerCache(player));
    }

    public static Cache getPlayerCache(Player player) {
        return playerCacheMap.get(player);
    }

    public static void addPlayerCache(Player player) {
        if (ConfigManager.getMySQL()) {
            playerCacheMap.put(player, new Cache(player));
        } else if (!PlayerCacheManager.loadPlayerCache(player)) {
            playerCacheMap.put(player, new Cache(player));
        }
    }

    public static boolean loadPlayerCache(Player player) {
        File file;
        File file2 = new File(FlipCard.instance.getDataFolder() + "/data");
        if (!file2.exists()) {
            file2.mkdir();
        }
        String string = player.getName();
        if (ConfigManager.getUseUUID()) {
            string = player.getUniqueId().toString();
        }
        if (!(file = new File(file2, string + ".yml")).exists()) {
            return false;
        }
        playerCacheMap.put(player, new Cache(player, YamlConfiguration.loadConfiguration((File)file)));
        return true;
    }

    public static void saveAll() {
        for (Player player : playerCacheMap.keySet()) {
            PlayerCacheManager.savePlayerCache(player);
        }
    }

    public static void savePlayerCache(Player player) {
        File file;
        File file2 = new File(FlipCard.instance.getDataFolder() + "/data");
        if (!file2.exists()) {
            file2.mkdir();
        }
        Cache cache = PlayerCacheManager.getPlayerCache(player);
        cache.closeInv();
        String string = player.getName();
        if (ConfigManager.getUseUUID()) {
            string = player.getUniqueId().toString();
        }
        if ((file = new File(file2, string + ".yml")).exists()) {
            file.delete();
        }
        Map<String, Integer> map = cache.getCache();
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        for (String string2 : map.keySet()) {
            yamlConfiguration.set(string2, (Object)map.get(string2));
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void removePlayerCache(Player player) {
        playerCacheMap.remove(player);
    }

    public static void closeInv() {
        for (Player player : playerCacheMap.keySet()) {
            playerCacheMap.get(player).closeInv();
        }
    }
}

