/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.manager;

import cc.carm.lib.easysql.CheckUpdates;
import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.gui.InvGui;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.util.Action;
import cn.myrealm.flipcard.util.Card;
import cn.myrealm.flipcard.util.Reward;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RewardManager {
    public static void showAwardCard(Inventory inventory, int n, int n2) {
        ItemStack itemStack = inventory.getItem(n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setCustomModelData(Integer.valueOf(n2));
        itemMeta.setDisplayName(" ");
        itemMeta.setLore(null);
        itemStack.setItemMeta(itemMeta);
        inventory.setItem(n - 9, itemStack);
    }

    public static void removeAnimateCard(Inventory inventory, int n) {
        inventory.setItem(n, null);
    }

    public static void AwardCardHandel(Inventory inventory, int n, Card card) {
        RewardManager.showAwardCard(inventory, n, card.getAwardCardCmd());
        RewardManager.removeAnimateCard(inventory, n);
    }

    public static Reward AwardHandel(Card card) {
        List<Reward> list = card.getAwards();
        double d = 0.0;
        for (Reward reward : list) {
            if (reward.isLimited()) continue;
            d += reward.getRate();
        }
        double d2 = Math.random() * d;
        Reward reward = null;
        for (Reward reward2 : list) {
            if (reward2.isLimited() || !((d2 -= reward2.getRate()) <= 1.0E-5)) continue;
            reward = reward2;
            break;
        }
        reward.addUseTime();
        ItemStack itemStack = reward.getItemStack();
        if (itemStack == null) {
            card.getPlayer().sendMessage(LanguageManager.getText("reward-get-fail"));
        }
        return reward;
    }

    public static void showReward(final InvGui invGui, final int n, final ItemStack itemStack, final ItemStack itemStack2, int n2) {
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                invGui.getInv().setItem(n, itemStack);
                if (itemStack2 != null) {
                    invGui.getInv().setItem(n + 9, itemStack2);
                }
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)n2);
    }

    @Deprecated
    public static void sendAnnouncement(Reward reward, int n) {
        String string = reward.getAnnouncement();
        if (string == null || string.equals("")) {
            return;
        }
        String[] stringArray = string.split("%");
        string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("player")) {
                stringArray[i] = reward.getPlayer().getName();
            } else if (stringArray[i].equals("display")) {
                stringArray[i] = reward.getDisplayName();
            } else if (stringArray[i].equals("amount")) {
                stringArray[i] = String.valueOf(reward.getAmount());
            }
            string = string + stringArray[i];
        }
        final String string2 = string = FlipCard.parseColor(string);
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                Collection collection = Bukkit.getOnlinePlayers();
                for (Player player : collection) {
                    player.sendMessage(string2);
                }
            }
        };
        bukkitRunnable.runTaskLater((Plugin)FlipCard.instance, (long)n);
    }

    public static void doFlipActions(Reward reward, int n) {
        Bukkit.getScheduler().runTaskLater((Plugin)FlipCard.instance, () -> {
            Action action = new Action(reward.getFlipActions(), reward);
            action.doAction(reward.getPlayer());
        }, (long)n);
    }

    public static void sendRewards(List<Reward> list) {
        if (CheckUpdates.t.contains(".")) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        for (Reward reward : list) {
            Object object;
            ItemStack itemStack = reward.getItemStack();
            if (itemStack == null || !reward.getGiveItem()) continue;
            reward.getPlayer().playSound(reward.getPlayer().getLocation(), Sound.ITEM_ARMOR_EQUIP_GOLD, 10.0f, 1.0f);
            if (reward.getPlayer().getInventory().addItem(new ItemStack[]{itemStack}).size() != 0) {
                reward.getPlayer().getWorld().dropItem(reward.getPlayer().getLocation(), itemStack);
                object = LanguageManager.getText("main-gui-no-enough-space-dropped");
                object = LanguageManager.varHandle((String)object, "amount", String.valueOf(itemStack.getAmount()));
                object = itemStack.getItemMeta().hasDisplayName() ? LanguageManager.varHandle((String)object, "display", itemStack.getItemMeta().getDisplayName()) : LanguageManager.varHandle((String)object, "display", itemStack.getType().name());
                reward.getPlayer().sendMessage(FlipCard.parseColor((String)object));
            }
            object = new Action(reward.getActions(), reward);
            ((Action)object).doAction(reward.getPlayer());
        }
    }

    @Deprecated
    public static void sendCommandAwards(List<Reward> list) {
        if (list.isEmpty()) {
            return;
        }
        for (Reward reward : list) {
            if (!reward.getHasCommand()) continue;
            for (int i = 0; i < reward.getTimes(); ++i) {
                for (String string : reward.getCommand()) {
                    string = LanguageManager.varHandle(string, "player", reward.getPlayer().getName());
                    string = LanguageManager.varHandle(string, "amount", String.valueOf(reward.getAmount()));
                    if ((string = LanguageManager.varHandle(string, "display", reward.getDisplayName())).startsWith("kill")) {
                        reward.getPlayer().sendMessage(LanguageManager.getText("no-kill"));
                        continue;
                    }
                    if (string.startsWith("[p] ")) {
                        Bukkit.dispatchCommand((CommandSender)reward.getPlayer(), (String)LanguageManager.getPlaceholder(reward.getPlayer(), string.substring(4)));
                        continue;
                    }
                    if (string.startsWith("[c] ")) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)LanguageManager.getPlaceholder(reward.getPlayer(), string.substring(4)));
                        continue;
                    }
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)LanguageManager.getPlaceholder(reward.getPlayer(), string));
                }
            }
        }
    }
}

