/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.manager.PriceManager;
import cn.myrealm.flipcard.papi.PlaceholderAPISupport;
import cn.myrealm.flipcard.util.Price;
import cn.myrealm.flipcard.util.Reward;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Card {
    private ConfigurationSection section;
    private String name;
    private List<String> lore;
    private String type;
    private ItemStack itemStack;
    private List<Reward> awards = new ArrayList<Reward>();
    private List<Price> prices = new ArrayList<Price>();
    private int times = 1;
    private Player player;

    public Card(ConfigurationSection configurationSection, Player player) {
        this.type = configurationSection.getString("animate") != null ? "custom" : "card";
        this.section = configurationSection;
        this.name = configurationSection.getString("name", null);
        this.lore = configurationSection.getStringList("lore");
        this.player = player;
    }

    private ItemStack buildCard() {
        Object object;
        ItemStack itemStack = null;
        itemStack = this.type.equals("custom") ? ConfigManager.getAnimation(this.section.getString("animate", "")) : ConfigManager.getCard(this.section.getString("back", ""));
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (this.name != null) {
            object = this.name.split("%");
            String string = "";
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].equals("price")) {
                    object[i] = PriceManager.getPriceExplain(this);
                }
                string = string + (String)object[i];
            }
            if (PlaceholderAPISupport.isPlaceholderAPILoaded()) {
                itemMeta.setDisplayName(PlaceholderAPI.setPlaceholders((Player)this.player, (String)FlipCard.parseColor(string)));
            } else {
                itemMeta.setDisplayName(FlipCard.parseColor(string));
            }
        }
        if (this.lore != null) {
            int n;
            object = new ArrayList<String>(this.lore);
            if (PlaceholderAPISupport.isPlaceholderAPILoaded()) {
                for (n = 0; n < object.size(); ++n) {
                    object.set(n, PlaceholderAPI.setPlaceholders((Player)this.player, (String)FlipCard.parseColor("&f" + (String)object.get(n))));
                }
            } else {
                for (n = 0; n < object.size(); ++n) {
                    object.set(n, FlipCard.parseColor("&f" + (String)object.get(n)));
                }
            }
            for (n = 0; n < object.size(); ++n) {
                String[] stringArray = ((String)object.get(n)).split("%");
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("price")) {
                        stringArray[i] = PriceManager.getPriceExplain(this);
                    }
                    string = string + stringArray[i];
                }
                object.set(n, string);
            }
            itemMeta.setLore((List)object);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public ItemStack getItemStack() {
        this.itemStack = this.buildCard();
        return this.itemStack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getAmount() {
        return this.section.getInt("amount", 0);
    }

    public int getMax() {
        return this.section.getInt("max", this.getAmount());
    }

    public List<Integer> getAnimateFrame() {
        if (this.type.equals("custom")) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("animations." + this.section.getString("animate"));
            for (String string : configurationSection.getKeys(false)) {
                int n = configurationSection.getConfigurationSection(string).getInt("cmd", 0);
                if (n == 0) continue;
                arrayList.add(configurationSection.getConfigurationSection(string).getInt("cmd"));
            }
            arrayList.remove(arrayList.size() - 1);
            return arrayList;
        }
        List list = FlipCard.instance.getConfig().getConfigurationSection(this.section.getString("back")).getIntegerList("frame");
        List list2 = FlipCard.instance.getConfig().getConfigurationSection(this.section.getString("front")).getIntegerList("frame");
        Collections.reverse(list2);
        list.addAll(list2.subList(1, list2.size() - 1));
        return list;
    }

    public List<Integer> getFailAnimateFrame() {
        List<Integer> list = this.getAnimateFrame();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.subList(0, 2));
        Collections.reverse(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(list.subList(0, 3));
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    public int getAwardCardCmd() {
        if (this.type.equals("custom")) {
            ConfigurationSection configurationSection = FlipCard.instance.getConfig().getConfigurationSection("animations." + this.section.getString("animate"));
            int n = 0;
            for (String string : configurationSection.getKeys(false)) {
                n = configurationSection.getConfigurationSection(string).getInt("cmd", 0);
            }
            return n;
        }
        return FlipCard.instance.getConfig().getConfigurationSection(this.section.getString("front")).getInt("reward");
    }

    public void buildAwards() {
        int n = 1;
        this.awards.clear();
        while (this.section.getConfigurationSection("rewards").getConfigurationSection(String.valueOf(n)) != null) {
            this.awards.add(new Reward(this.section.getConfigurationSection("rewards").getConfigurationSection(String.valueOf(n)), this.player));
            ++n;
        }
    }

    public List<Reward> getAwards() {
        if (this.awards.isEmpty()) {
            this.buildAwards();
        }
        return this.awards;
    }

    public void buildPrices() {
        int n = 1;
        this.prices.clear();
        while (this.section.getConfigurationSection("prices").getConfigurationSection(String.valueOf(n)) != null) {
            this.prices.add(new Price(this.section.getConfigurationSection("prices").getConfigurationSection(String.valueOf(n)), this.player));
            ++n;
        }
    }

    public List<Price> getPrices() {
        if (this.prices.isEmpty()) {
            this.buildPrices();
        }
        return this.prices;
    }

    public void timesPlusOne() {
        ++this.times;
    }

    public int getTimes() {
        return this.times;
    }
}

