/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.hooks.ItemsHook;
import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.manager.SavedItemManager;
import cn.myrealm.flipcard.util.StringMath;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Reward {
    private ConfigurationSection section;
    private String type;
    private int amount = -1;
    private int useTime = 0;
    private int times = 1;
    private boolean hasCommand = false;
    private boolean giveItem = true;
    private Player player;
    private ItemStack itemStack;

    public Reward(ConfigurationSection configurationSection, Player player) {
        this.player = player;
        this.section = configurationSection;
        if (configurationSection.contains("give-item")) {
            this.giveItem = configurationSection.getBoolean("give-item");
        }
        if (configurationSection.contains("commands")) {
            this.times = this.initTimes();
            this.hasCommand = true;
        }
        if (configurationSection.contains("hook-plugin") && configurationSection.contains("hook-item")) {
            this.amount = this.initAmount();
            this.type = "hook";
        } else if (configurationSection.contains("material")) {
            this.amount = this.initAmount();
            this.type = "vanilla";
        } else {
            this.type = "unknown";
            Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cThere is something wrong in your UI configs!");
        }
        this.buildItemStack();
    }

    public boolean checkRateCondition(String string) {
        boolean bl = true;
        List list = new ArrayList();
        if (this.section.getStringList("rates-conditions." + string).isEmpty()) {
            return false;
        }
        list = this.section.getStringList("rates-conditions." + string);
        block0: for (String string2 : list) {
            if (string2.startsWith("none")) {
                return true;
            }
            if (string2.startsWith("world: ")) {
                int n = 0;
                for (String string3 : string2.substring(7).split(";;")) {
                    if (string3.equals(this.player.getWorld().getName())) break;
                    ++n;
                }
                if (n != string2.substring(7).split(";;").length) continue;
                bl = false;
                break;
            }
            if (string2.startsWith("permission: ")) {
                for (String string4 : string2.substring(12).split(";;")) {
                    if (this.player.hasPermission(string4)) continue;
                    bl = false;
                    continue block0;
                }
                continue;
            }
            if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") || !string2.startsWith("placeholder: ")) continue;
            String[] stringArray = string2.substring(13).split(";;");
            Object object = stringArray[0];
            String string5 = stringArray[1];
            String string6 = stringArray[2];
            if (string5.equals("==") && !((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))).equals(string6)) {
                bl = false;
                break;
            }
            if (string5.equals("*=") && !((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))).contains(string6)) {
                bl = false;
                break;
            }
            if (string5.equals(">=") && Integer.parseInt((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) < Integer.parseInt(string6)) {
                bl = false;
                break;
            }
            if (string5.equals(">") && Integer.parseInt((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) <= Integer.parseInt(string6)) {
                bl = false;
                break;
            }
            if (string5.equals("<=") && Integer.parseInt((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) > Integer.parseInt(string6)) {
                bl = false;
                break;
            }
            if (string5.equals("<") && Integer.parseInt((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) >= Integer.parseInt(string6)) {
                bl = false;
                break;
            }
            if (!string5.equals("=") || Integer.parseInt((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) == Integer.parseInt(string6)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public double getRate() {
        if (!this.section.getString("rate", "-1").equals("-1")) {
            return StringMath.doCalculate(LanguageManager.getPlaceholder(this.player, this.section.getString("rate", "0")));
        }
        if (!this.section.getString("chance", "-1").equals("-1")) {
            return StringMath.doCalculate(LanguageManager.getPlaceholder(this.player, this.section.getString("chance", "0")));
        }
        if (Objects.nonNull(this.section.getConfigurationSection("rates"))) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (String string : this.section.getConfigurationSection("rates").getKeys(false)) {
                if (!string.equals("default") && this.checkRateCondition(string)) {
                    arrayList.add(StringMath.doCalculate(LanguageManager.getPlaceholder(this.player, this.section.getString("rates." + string, "0"))));
                    continue;
                }
                if (this.section.getDouble("rates.default", -1.0) == -1.0) continue;
                arrayList.add(StringMath.doCalculate(LanguageManager.getPlaceholder(this.player, this.section.getString("rates.default", "0"))));
            }
            if (arrayList.size() == 0) {
                arrayList.add(0.0);
            }
            return (Double)Collections.max(arrayList);
        }
        return 0.0;
    }

    public int initAmount() {
        String string = this.section.getString("amount", "1");
        String[] stringArray = string.split("~");
        if (stringArray.length == 1) {
            return Integer.parseInt(stringArray[0]);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        return n + (int)(Math.random() * (double)(n2 - n + 1));
    }

    private int initTimes() {
        String string = this.section.getString("times", "1");
        String[] stringArray = string.split("~");
        if (stringArray.length == 1) {
            return Integer.parseInt(stringArray[0]);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        return n + (int)(Math.random() * (double)(n2 - n + 1));
    }

    public boolean getGiveItem() {
        return this.giveItem;
    }

    public ItemStack getEdge() {
        return ConfigManager.getEdge(this.section.getString("edge", ""));
    }

    public void buildItemStack() {
        int n;
        List list;
        String string;
        String string2;
        ItemStack itemStack = null;
        if (this.type.equals("vanilla")) {
            string2 = this.section.getString("material", "").toUpperCase();
            if (!string2.equals("")) {
                if (string2.equals("SKULL")) {
                    itemStack = new ItemStack(Material.getMaterial((String)"PLAYER_HEAD"));
                    string = (SkullMeta)itemStack.getItemMeta();
                    list = new GameProfile(UUID.randomUUID(), null);
                    list.getProperties().put((Object)"textures", (Object)new Property("textures", this.section.getString("skull_meta")));
                    try {
                        Method method = string.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                        method.setAccessible(true);
                        method.invoke((Object)string, list);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                    }
                    itemStack.setItemMeta((ItemMeta)string);
                } else {
                    string = Material.getMaterial((String)string2);
                    itemStack = string == null ? SavedItemManager.getItemByKey(this.section.getString("material", "")) : new ItemStack((Material)string);
                }
            }
        } else if (this.type.equals("hook")) {
            string2 = this.section.getString("hook-plugin");
            string = this.section.getString("hook-item");
            if (string2.equals("MMOItems") && !string.contains(";;")) {
                string = this.section.getString("hook-item-type") + ";;" + string;
            } else if (string2.equals("EcoArmor") && !string.contains(";;")) {
                string = string + ";;" + this.section.getString("hook-item-type");
            }
            itemStack = ItemsHook.getHookItem(string2, string);
        }
        if (itemStack == null) {
            itemStack = new ItemStack(Material.getMaterial((String)"STONE"));
        }
        if ((string2 = itemStack.getItemMeta()) == null) {
            this.itemStack = itemStack;
            this.giveItem = false;
        }
        if (!(string = this.section.getString("display", "")).equals("")) {
            string = FlipCard.parseColor(string);
            string = LanguageManager.varHandle(string, "times", String.valueOf(this.times));
            string2.setDisplayName(string);
        }
        if (!(list = this.section.getStringList("lore")).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                string3 = LanguageManager.varHandle(string3, "times", String.valueOf(this.times));
                string3 = FlipCard.parseColor("&f" + string3);
                list.set(i, string3);
            }
            string2.setLore(list);
        }
        if ((n = this.section.getInt("cmd", 0)) != 0) {
            string2.setCustomModelData(Integer.valueOf(n));
        }
        if (this.amount != -1) {
            itemStack.setAmount(this.amount);
        }
        itemStack.setItemMeta((ItemMeta)string2);
        this.itemStack = itemStack;
    }

    public boolean getHasCommand() {
        return this.hasCommand;
    }

    public int getAmount() {
        return this.amount;
    }

    public List<String> getCommand() {
        return this.section.getStringList("commands");
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getAnnouncement() {
        String string = this.section.getString("announcement", "");
        return string;
    }

    public List<String> getActions() {
        return this.section.getStringList("actions");
    }

    public List<String> getFlipActions() {
        return this.section.getStringList("flip-actions");
    }

    public String getDisplayName() {
        String string = this.getItemStack().getType().name();
        if (this.getItemStack().getItemMeta().hasDisplayName()) {
            string = this.getItemStack().getItemMeta().getDisplayName();
        }
        return string;
    }

    public void addUseTime() {
        ++this.useTime;
    }

    public boolean isLimited() {
        int n = this.section.getInt("limit", -1);
        return n != -1 && n <= this.useTime;
    }

    public int getTimes() {
        return this.times;
    }
}

