/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch;

import redempt.crunch.CompiledExpression;
import redempt.crunch.ShuntingYard;
import redempt.crunch.Variable;
import redempt.crunch.data.FastNumberParsing;
import redempt.crunch.exceptions.ExpressionCompilationException;
import redempt.crunch.functional.ArgumentList;
import redempt.crunch.functional.ExpressionEnv;
import redempt.crunch.functional.Function;
import redempt.crunch.functional.FunctionCall;
import redempt.crunch.token.BinaryOperator;
import redempt.crunch.token.LiteralValue;
import redempt.crunch.token.Token;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.UnaryOperation;
import redempt.crunch.token.UnaryOperator;
import redempt.crunch.token.Value;

public class ExpressionParser {
    public final String str;
    public int cur = 0;
    public final ExpressionEnv env;
    private CompiledExpression expr = new CompiledExpression();
    private int maxVarIndex;

    ExpressionParser(String string, ExpressionEnv expressionEnv) {
        if (string == null) {
            throw new ExpressionCompilationException(null, "Expression is null");
        }
        if (expressionEnv == null) {
            throw new ExpressionCompilationException(null, "Environment is null");
        }
        this.maxVarIndex = expressionEnv.getVariableCount() - 1;
        this.str = string;
        this.env = expressionEnv;
    }

    public char peek() {
        return this.str.charAt(this.cur);
    }

    public char advance() {
        return this.str.charAt(this.cur++);
    }

    public void advanceCursor() {
        ++this.cur;
    }

    public boolean isAtEnd() {
        return this.cur >= this.str.length();
    }

    public void expectChar(char c) {
        if (this.isAtEnd() || this.advance() != c) {
            throw new ExpressionCompilationException(this, "Expected '" + c + "'");
        }
    }

    private void error(String string) {
        throw new ExpressionCompilationException(this, string);
    }

    private boolean whitespace() {
        while (!this.isAtEnd() && Character.isWhitespace(this.peek())) {
            ++this.cur;
        }
        return true;
    }

    private Value parseExpression() {
        if (this.isAtEnd()) {
            this.error("Expected expression");
        }
        Value value = this.parseTerm();
        if (this.isAtEnd() || this.peek() == ')') {
            return value;
        }
        ShuntingYard shuntingYard = new ShuntingYard();
        shuntingYard.addValue(value);
        while (this.whitespace() && !this.isAtEnd() && this.peek() != ')' && this.peek() != ',') {
            BinaryOperator binaryOperator = this.env.getBinaryOperators().getWith(this);
            if (binaryOperator == null) {
                this.error("Expected binary operator");
            }
            shuntingYard.addOperator(binaryOperator);
            this.whitespace();
            shuntingYard.addValue(this.parseTerm());
        }
        return shuntingYard.finish();
    }

    private Value parseNestedExpression() {
        this.expectChar('(');
        this.whitespace();
        Value value = this.parseExpression();
        this.expectChar(')');
        return value;
    }

    private Value parseAnonymousVariable() {
        this.expectChar('$');
        double d = this.parseLiteral().getValue();
        if (d % 1.0 != 0.0) {
            this.error("Decimal variable indices are not allowed");
        }
        if (d < 1.0) {
            this.error("Zero and negative variable indices are not allowed");
        }
        int n = (int)d - 1;
        this.maxVarIndex = Math.max(n, this.maxVarIndex);
        return new Variable(this.expr, n);
    }

    private Value parseTerm() {
        switch (this.peek()) {
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseLiteral();
            }
            case '(': {
                return this.parseNestedExpression();
            }
            case '$': {
                return this.parseAnonymousVariable();
            }
        }
        Token token = this.env.getLeadingOperators().getWith(this);
        if (token != null) {
            return this.parseLeadingOperation(token);
        }
        Value value = this.env.getValues().getWith(this);
        if (value == null) {
            this.error("Expected value");
        }
        if (value instanceof Variable) {
            ((Variable)value).expression = this.expr;
        }
        return value;
    }

    private LiteralValue parseLiteral() {
        char c;
        int n = this.cur;
        while (Character.isDigit(c = this.peek()) || c == '.') {
            this.advanceCursor();
            if (!this.isAtEnd()) continue;
        }
        return new LiteralValue(FastNumberParsing.parseDouble(this.str, n, this.cur));
    }

    private Value parseLeadingOperation(Token token) {
        this.whitespace();
        switch (token.getType()) {
            case UNARY_OPERATOR: {
                UnaryOperator unaryOperator = (UnaryOperator)token;
                Value value = this.parseTerm();
                if (unaryOperator.isPure() && value.getType() == TokenType.LITERAL_VALUE) {
                    return new LiteralValue(unaryOperator.operate.applyAsDouble(value.getValue()));
                }
                return new UnaryOperation((UnaryOperator)token, value);
            }
            case FUNCTION: {
                Function function = (Function)token;
                ArgumentList argumentList = this.parseArgumentList(function.getArgCount());
                return new FunctionCall(function, argumentList.getArguments());
            }
        }
        this.error("Expected leading operation");
        return null;
    }

    private ArgumentList parseArgumentList(int n) {
        this.expectChar('(');
        this.whitespace();
        Value[] valueArray = new Value[n];
        if (n == 0) {
            this.expectChar(')');
            return new ArgumentList(new Value[0]);
        }
        valueArray[0] = this.parseExpression();
        this.whitespace();
        for (int i = 1; i < n; ++i) {
            this.expectChar(',');
            this.whitespace();
            valueArray[i] = this.parseExpression();
            this.whitespace();
        }
        this.expectChar(')');
        return new ArgumentList(valueArray);
    }

    public CompiledExpression parse() {
        this.whitespace();
        Value value = this.parseExpression();
        this.whitespace();
        if (!this.isAtEnd()) {
            this.error("Dangling term");
        }
        this.expr.initialize(value, this.maxVarIndex + 1);
        return this.expr;
    }
}

