/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.token;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleUnaryOperator;
import redempt.crunch.token.Token;
import redempt.crunch.token.TokenType;

public enum UnaryOperator implements Token
{
    NEGATE("-", d -> -d),
    NOT("!", d -> d == 1.0 ? 0.0 : 1.0),
    SIN("sin", Math::sin),
    COS("cos", Math::cos),
    TAN("tan", Math::tan),
    SINH("sinh", Math::sinh),
    COSH("cosh", Math::cosh),
    TANH("tanh", Math::tanh),
    ASIN("asin", Math::asin),
    ACOS("acos", Math::acos),
    ATAN("atan", Math::atan),
    ABS("abs", Math::abs),
    ROUND("round", Math::round),
    FLOOR("floor", Math::floor),
    CEIL("ceil", Math::ceil),
    LOG("log", Math::log),
    SQRT("sqrt", Math::sqrt),
    CBRT("cbrt", Math::cbrt),
    RAND("rand", d -> ThreadLocalRandom.current().nextDouble() * d, false);

    public final String symbol;
    public final DoubleUnaryOperator operate;
    private boolean pure = true;

    private UnaryOperator(String string2, DoubleUnaryOperator doubleUnaryOperator) {
        this.symbol = string2;
        this.operate = doubleUnaryOperator;
    }

    private UnaryOperator(String string2, DoubleUnaryOperator doubleUnaryOperator, boolean bl) {
        this(string2, doubleUnaryOperator);
        this.pure = bl;
    }

    @Override
    public TokenType getType() {
        return TokenType.UNARY_OPERATOR;
    }

    public int getPriority() {
        return 6;
    }

    public boolean isPure() {
        return this.pure;
    }

    public String toString() {
        return this.symbol;
    }
}

