/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.easterentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class KillerChicken
extends CustomEntity {
    private Chicken chicken;
    private UUID chickenUUID;
    public List<KillerChicken> chickenList;

    public KillerChicken(Zombie zombie, Main main) {
        super((Mob)zombie, main);
        this.entityType = CustomEntityType.KILLERCHICKEN;
        this.species = this.entityType.species;
        zombie.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        zombie.setHealth(this.entityType.getHealth());
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(30.0);
        zombie.setCanPickupItems(false);
        zombie.setSilent(true);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        if (main.mcVersion >= 1.16) {
            zombie.setBaby();
        } else {
            zombie.setBaby(true);
        }
        zombie.setMetadata("dd-killerchicken", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        zombie.setMetadata("dd-unburnable", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        zombie.setMetadata("dd-eastermobs", (MetadataValue)main.fixedData);
        if (zombie.getCustomName() == null) {
            zombie.setCustomName(Languages.getString("easter.killerChicken"));
        }
        this.chicken = (Chicken)zombie.getWorld().spawnEntity(zombie.getLocation(), EntityType.CHICKEN);
        this.chicken.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        this.chicken.setHealth(this.entityType.getHealth());
        this.chicken.setMetadata("dd-eastermobs", (MetadataValue)main.fixedData);
        this.chicken.setMetadata("dd-killerchickenghost", (MetadataValue)main.fixedData);
        this.chicken.setMetadata("dd-customentity", (MetadataValue)main.fixedData);
        this.chicken.setCollidable(false);
        this.chickenUUID = this.chicken.getUniqueId();
        this.chicken.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        zombie.setRemoveWhenFarAway(true);
    }

    @Override
    public void tick() {
        if (this.entity == null || this.chicken == null) {
            return;
        }
        this.chicken.teleport((Entity)this.entity);
        if (this.entity.getHealth() < this.chicken.getHealth()) {
            this.chicken.damage(1.0E-5);
            this.chicken.setHealth(this.entity.getHealth());
        } else if (this.chicken.getHealth() < this.entity.getHealth()) {
            this.entity.setHealth(this.chicken.getHealth());
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.chicken == null) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        this.chicken = (Chicken)this.plugin.getServer().getEntity(this.chickenUUID);
    }

    @Override
    public void clean() {
        if (this.chicken != null) {
            this.chicken.remove();
        }
        if (this.chickenList != null) {
            this.chickenList.remove(this);
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    public static void createEgg(Location location, Main main, LivingEntity livingEntity, List<KillerChicken> list) {
        Item item = location.getWorld().dropItemNaturally(location, new ItemStack(Material.EGG));
        item.setPickupDelay(100000);
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> {
            KillerChicken killerChicken;
            if (item == null || item.isDead()) {
                return;
            }
            location.getWorld().spawnParticle(Particle.ITEM_CRACK, item.getLocation(), 5, 0.3, 0.3, 0.3, 0.001, (Object)new ItemStack(Material.EGG));
            location.getWorld().playSound(item.getLocation(), Sound.ENTITY_TURTLE_EGG_HATCH, SoundCategory.HOSTILE, 1.0f, 0.7f);
            int n = 0;
            while (n < 8) {
                killerChicken = new Particle.DustTransition(Color.fromRGB((int)(main.random.nextInt(125) + 25), (int)255, (int)(main.random.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(main.random.nextInt(155) + 100), (int)255), main.random.nextFloat());
                if (main.random.nextInt(2) == 0) {
                    killerChicken = new Particle.DustTransition(Color.fromRGB((int)(main.random.nextInt(105) + 150), (int)25, (int)255), Color.fromRGB((int)25, (int)(main.random.nextInt(155) + 100), (int)255), main.random.nextFloat() / 2.0f);
                }
                location.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, item.getLocation().add(0.0, 0.2, 0.0).add(main.random.nextDouble() - 0.5, main.random.nextDouble() - 0.5, main.random.nextDouble() - 0.5), 1, 0.0, 0.0, 0.0, 0.001, (Object)killerChicken);
                ++n;
            }
            Zombie zombie = (Zombie)location.getWorld().spawnEntity(item.getLocation(), EntityType.ZOMBIE, false);
            item.remove();
            killerChicken = new KillerChicken(zombie, main);
            killerChicken.chickenList = list;
            main.handler.addEntity(killerChicken);
            zombie.setTarget(livingEntity);
        }, 60L);
    }
}

