/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.EulerAngle;

public class InfestedEnderman
extends CustomEntity {
    private Particle.DustOptions dust = new Particle.DustOptions(Color.fromRGB((int)9, (int)74, (int)72), 1.0f);
    private ArmorStand stand;

    public InfestedEnderman(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.INFESTEDENDERMAN;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        this.stand = (ArmorStand)mob.getWorld().spawnEntity(mob.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (main.mcVersion >= 1.16) {
            this.stand.setInvisible(true);
        } else {
            this.stand.setVisible(false);
        }
        this.stand.setMarker(true);
        this.stand.setGravity(false);
        if (main.mcVersion >= 1.16) {
            this.stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.stand.getEquipment().setHelmet(CustomHead.INFESTEDENDERMAN.getHead());
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        mob.setMetadata("dd-infestedenderman", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.infestedEnderman"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null || this.stand == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.REDSTONE, this.entity.getLocation().add(0.0, 1.2, 0.0), 7, 0.25, 0.8, 0.25, 0.001, (Object)this.dust);
        if (this.entity.getTarget() == null) {
            this.stand.teleport(this.entity.getLocation().add(0.0, 0.9, 0.0).add(this.entity.getLocation().getDirection().multiply(0.1)));
        } else {
            this.stand.teleport(this.entity.getLocation().add(0.0, 1.15, 0.0).add(this.entity.getLocation().getDirection().multiply(0.2)));
        }
        this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead() || this.stand == null) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.stand.getUniqueId());
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

