/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ShadowLeech
extends CustomEntity {
    private ArmorStand stand;
    private int cooldown = 3;
    private Random rand;
    private boolean attached;
    private boolean bloodleech;
    private LivingEntity attachedTo;
    private Vector offsetOfAttach;
    private Vector facingDirection;
    private double damage;
    private Location step;
    private Team team;

    public ShadowLeech(Zombie zombie, Main main, Random random) {
        super((Mob)zombie, main);
        this.rand = random;
        this.entityType = CustomEntityType.SHADOWLEECH;
        this.species = this.entityType.species;
        this.stand = (ArmorStand)zombie.getWorld().spawnEntity(zombie.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (main.mcVersion >= 1.16) {
            this.stand.setInvisible(true);
        } else {
            this.stand.setVisible(false);
        }
        this.stand.setMarker(true);
        this.stand.setGravity(false);
        this.stand.setSmall(true);
        if (main.mcVersion >= 1.16) {
            this.stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        if (random.nextDouble() * 100.0 < (Double)this.entityType.grabCustomSetting("blood_leech_conversion")) {
            this.bloodleech = true;
            this.damage = this.entityType.getDamage() * 1.5;
            this.stand.getEquipment().setHelmet(CustomHead.BLOODYLEECH.getHead());
        } else {
            this.damage = this.entityType.getDamage();
            this.stand.getEquipment().setHelmet(CustomHead.SHADOWLEECH.getHead());
        }
        this.initZombie();
        this.step = zombie.getLocation();
    }

    @Override
    public void tick() {
        Block block;
        Location location;
        if (this.entity == null || this.stand == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_FOX_SCREECH, SoundCategory.HOSTILE, 1.0f, 1.8f);
        }
        if (this.entity.isDead()) {
            this.entity.remove();
            this.entity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, this.entity.getLocation().add(0.0, 0.25, 0.0), 30, 0.15, 0.15, 0.15, 1.0E-6);
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VEX_DEATH, SoundCategory.HOSTILE, 0.25f, 0.7f);
            this.clean();
            return;
        }
        if (this.bloodleech) {
            this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation(), 1, 0.0, 0.0, 0.0, 1.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
        }
        if (this.attached) {
            if (this.attachedTo == null || this.attachedTo.isDead()) {
                this.attachedTo = null;
                this.attached = false;
                this.entity.setAI(true);
                this.entity.setGravity(true);
                this.entity.setTarget(null);
                this.removeTeam();
                return;
            }
            this.entity.teleport(this.attachedTo.getLocation().add(this.offsetOfAttach).setDirection(this.facingDirection));
            this.entity.setVelocity(this.attachedTo.getVelocity());
        } else if (this.entity.getTarget() != null) {
            if (this.cooldown <= 0 && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 6.25) {
                this.cooldown = 3;
                this.entity.setVelocity(Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation().add(0.0, this.rand.nextDouble() + 1.0, 0.0)));
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ITEM_FRAME_BREAK, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
            location = this.entity.getTarget().getLocation();
            location.setY(this.entity.getLocation().getY());
            if (location.getWorld().equals(this.entity.getTarget().getWorld()) && location.distanceSquared(this.entity.getLocation()) < 0.3) {
                this.attachedTo = this.entity.getTarget();
                this.offsetOfAttach = this.entity.getLocation().toVector().setY(0).subtract(this.attachedTo.getLocation().toVector().setY(0)).normalize().multiply((this.entity.getLocation().getY() - this.attachedTo.getLocation().getY()) * 0.25).setY(Math.min(this.entity.getLocation().toVector().subtract(this.attachedTo.getLocation().toVector()).getY(), this.attachedTo.getHeight()));
                try {
                    this.offsetOfAttach.checkFinite();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                this.attached = true;
                this.entity.setAI(false);
                this.entity.setGravity(false);
                Utils.makeEntityFaceLocation((Entity)this.entity, this.attachedTo.getLocation().add(0.0, 1.5, 0.0));
                this.facingDirection = this.entity.getLocation().getDirection();
                block = Bukkit.getScoreboardManager().getMainScoreboard();
                this.team = block.registerNewTeam(("col-" + this.entity.getUniqueId()).substring(0, 16));
                this.team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                char c = '\"';
                Location location2 = this.entity.getLocation();
                Utils.runConsoleCommand("team join col-" + this.entity.getUniqueId() + " @e[x=" + location2.getX() + ",y=" + location2.getY() + ",z=" + location2.getZ() + ",distance=..0.2,limit=1,name=" + c + this.entity.getName() + c + "]", this.entity.getWorld());
            }
        }
        if (!this.bloodleech && this.entity.getNoDamageTicks() == 0 && this.entity.getLocation().getBlock().getLightFromBlocks() >= 11) {
            if (this.attached) {
                this.attachedTo = null;
                this.attached = false;
                this.entity.setAI(true);
                this.entity.setGravity(true);
                this.removeTeam();
            }
            if (this.entity.getTarget() != null) {
                this.entity.setTarget(null);
            }
            location = this.entity.getLocation().getBlock();
            block = this.entity.getLocation().add(this.entity.getVelocity().normalize().multiply(-1)).getBlock();
            if (location.getRelative(BlockFace.NORTH).getLightFromBlocks() < block.getLightFromBlocks()) {
                block = location.getRelative(BlockFace.NORTH);
            }
            if (location.getRelative(BlockFace.EAST).getLightFromBlocks() < block.getLightFromBlocks()) {
                block = location.getRelative(BlockFace.EAST);
            }
            if (location.getRelative(BlockFace.SOUTH).getLightFromBlocks() < block.getLightFromBlocks()) {
                block = location.getRelative(BlockFace.SOUTH);
            }
            if (location.getRelative(BlockFace.WEST).getLightFromBlocks() < block.getLightFromBlocks()) {
                block = location.getRelative(BlockFace.WEST);
            }
            Utils.makeEntityFaceLocation((Entity)this.entity, block.getLocation().add(0.5, 1.0, 0.5));
            this.entity.setVelocity(Utils.getVectorTowards(this.entity.getLocation(), block.getLocation().add(0.5, 0.0, 0.5)).multiply(0.75).setY(0.3));
            this.entity.damage(2.0);
            this.entity.getWorld().spawnParticle(Particle.CLOUD, this.entity.getLocation().add(0.0, 0.4, 0.0), 4, 0.15, 0.15, 0.15, 1.0E-6);
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.HOSTILE, 0.5f, 2.0f);
        }
        this.stand.teleport(this.entity.getLocation().subtract(0.0, 0.75, 0.0));
        this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
        if (this.step.distanceSquared(this.entity.getLocation()) > 0.8 && this.entity.isOnGround()) {
            this.step = this.entity.getLocation();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_STEP, SoundCategory.HOSTILE, 0.15f, 0.8f);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.stand == null) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.stand.getUniqueId());
        if (this.attached) {
            if (this.attachedTo instanceof Player && Utils.isPlayerImmune((Player)this.attachedTo)) {
                this.attachedTo = null;
                this.entity.setTarget(null);
                this.removeTeam();
                return;
            }
            if (!this.bloodleech) {
                this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation(), 3, 0.1, 0.1, 0.1, 1.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
            } else {
                this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation(), 8, 0.1, 0.1, 0.1, 1.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
            }
            Utils.pureDamageEntity(this.attachedTo, this.damage, this.bloodleech ? "dd-bloodleechdeath" : "dd-leechdeath", false, null);
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_DEATH, SoundCategory.HOSTILE, 0.5f, 0.8f);
        } else {
            if (this.rand.nextInt(8) == 0) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
        this.removeTeam();
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void initZombie() {
        this.entity.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.entity.setMetadata("dd-shadowleech", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
        this.entity.setCanPickupItems(false);
        this.entity.setSilent(true);
        if (this.plugin.mcVersion >= 1.16) {
            ((Zombie)this.entity).setBaby();
        } else {
            ((Zombie)this.entity).setBaby(true);
        }
        this.entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        this.entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
        this.entity.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(30.0);
        Utils.clearEntityOfItems((LivingEntity)this.entity);
        if (!this.bloodleech) {
            this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
            this.entity.setHealth(this.entityType.getHealth());
            this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.15);
            this.entity.setCustomName(Languages.getString("entities.shadowLeech"));
        } else {
            this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth() * 2.0);
            this.entity.setHealth(this.entityType.getHealth() * 2.0);
            this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
            this.entity.setCustomName(Languages.getString("entities.bloodyLeech"));
        }
    }

    private void removeTeam() {
        if (this.team != null) {
            this.team.unregister();
        }
        this.team = null;
    }
}

