/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SwampBeast
extends CustomEntity {
    private int mudCooldown = 0;
    private int tpCooldown = 10;
    private int mudRadius;
    private Material mud;
    private LivingEntity target;

    public SwampBeast(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.SWAMPBEAST;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getEquipment().setHelmet(CustomHead.SWAMPMONSTER.getHead());
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.2);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.setCanPickupItems(false);
        mob.setMetadata("dd-swampbeast", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.swampBeast"));
        }
        this.mudRadius = (Integer)this.entityType.grabCustomSetting("mud_patch_radius");
        this.mud = main.mcVersion >= 1.19 ? Material.MUD : Material.SOUL_SAND;
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation().add(0.0, 1.1, 0.0), 10, 0.3, 0.3, 0.3, 1.0, (Object)this.mud.createBlockData());
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().add(0.0, 1.2, 0.0), 7, 0.3, 0.3, 0.3, 1.0, (Object)Material.SOUL_SAND.createBlockData());
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.mudCooldown > 0) {
            --this.mudCooldown;
        } else if (this.tpCooldown <= 11 && this.entity.getTarget() != null && this.entity.getWorld().equals(this.entity.getTarget().getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 36.0) {
            this.createMudSpell(this.entity.getLocation(), Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation()), this.mudRadius);
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.swingMainHand();
            }
            this.mudCooldown = 12;
            return;
        }
        if (this.tpCooldown > 0) {
            --this.tpCooldown;
        } else if (this.mudCooldown <= 4 && this.entity.getTarget() != null && this.entity.isOnGround() && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) >= 100.0 && !this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN).isPassable() && !this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN, 2).isPassable() && !this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN, 3).isPassable()) {
            Location location = null;
            int n = 0;
            while (n < 10) {
                location = Utils.findSmartYSpawn(this.entity.getTarget().getLocation(), Utils.getSpotInSquareRadius(this.entity.getTarget().getLocation(), 3), 2, 4);
                if (location != null && !location.getBlock().getRelative(BlockFace.DOWN).isPassable() && !location.getBlock().getRelative(BlockFace.DOWN, 2).isPassable() && !location.getBlock().getRelative(BlockFace.DOWN, 3).isPassable()) break;
                ++n;
            }
            if (location == null) {
                return;
            }
            final Location location2 = location.getBlock().getRelative(BlockFace.DOWN).getLocation();
            final Material material = location2.getBlock().getType();
            this.target = this.entity.getTarget();
            this.tpCooldown = 15;
            this.entity.setAI(false);
            this.entity.setGravity(false);
            float f = this.entity.getLocation().getYaw();
            this.entity.teleport(this.entity.getLocation().getBlock().getLocation().add(0.5, 0.0, 0.5));
            this.entity.setRotation(f, 70.0f);
            final Block block = this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
            final Material material2 = block.getType();
            if (!(block.getState() instanceof InventoryHolder || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                block.setType(this.mud);
            }
            final int[] nArray = new int[1];
            new RepeatingTask(this.plugin, 0, 1){

                @Override
                public void run() {
                    if (SwampBeast.this.entity == null) {
                        if (block != null && block.getType() == SwampBeast.this.mud) {
                            block.setType(material2);
                        }
                        if (location2 != null && location2.getBlock().getType() == SwampBeast.this.mud) {
                            location2.getBlock().setType(material);
                        }
                        this.cancel();
                        return;
                    }
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] <= 30) {
                        SwampBeast.this.entity.teleport(SwampBeast.this.entity.getLocation().add(0.0, -0.07, 0.0));
                        SwampBeast.this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 7, 0.3, 0.2, 0.3, 1.0, (Object)SwampBeast.this.mud.createBlockData());
                        if (nArray[0] % 5 == 0 && ((SwampBeast)SwampBeast.this).plugin.mcVersion >= 1.19) {
                            SwampBeast.this.entity.getWorld().playSound(block.getLocation(), Sound.BLOCK_MUD_HIT, SoundCategory.HOSTILE, 1.0f, 0.5f);
                        }
                        return;
                    }
                    if (nArray[0] == 40) {
                        if (!(block.getState() instanceof InventoryHolder || Utils.isBlockImmune(location2.getBlock().getType()) || Utils.isZoneProtected(location2.getBlock().getLocation()))) {
                            location2.getBlock().setType(SwampBeast.this.mud);
                        }
                        SwampBeast.this.entity.teleport(location2.getBlock().getRelative(BlockFace.DOWN).getLocation().add(0.5, 0.0, 0.5));
                        return;
                    }
                    if (nArray[0] > 40 && nArray[0] <= 60) {
                        SwampBeast.this.entity.teleport(SwampBeast.this.entity.getLocation().add(0.0, 0.0666, 0.0));
                        SwampBeast.this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, location2.clone().add(0.5, 1.0, 0.5), 7, 0.3, 0.2, 0.3, 1.0, (Object)SwampBeast.this.mud.createBlockData());
                        if (nArray[0] % 5 == 0 && ((SwampBeast)SwampBeast.this).plugin.mcVersion >= 1.19) {
                            SwampBeast.this.entity.getWorld().playSound(location2, Sound.BLOCK_MUD_HIT, SoundCategory.HOSTILE, 1.0f, 0.5f);
                        }
                        if (SwampBeast.this.target != null && SwampBeast.this.target.getWorld().equals(SwampBeast.this.entity.getWorld())) {
                            Utils.makeEntityFaceLocation((Entity)SwampBeast.this.entity, SwampBeast.this.target.getLocation());
                        }
                        return;
                    }
                    if (nArray[0] > 60) {
                        SwampBeast.this.entity.setAI(true);
                        SwampBeast.this.entity.setGravity(true);
                        SwampBeast.this.entity.setTarget(SwampBeast.this.target);
                        this.cancel();
                        SwampBeast.this.plugin.getServer().getScheduler().runTaskLater((Plugin)SwampBeast.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                if (block.getType() == (this).SwampBeast.this.mud) {
                                    block.setType(material2);
                                }
                                if (location2.getBlock().getType() == (this).SwampBeast.this.mud) {
                                    location2.getBlock().setType(material);
                                }
                            }
                        }, 200L);
                    }
                }
            };
            return;
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void createMudSpell(Location location, final Vector vector, final int n) {
        final World world = location.getWorld();
        final Vector vector2 = new Vector(vector.getZ(), 0.0, -vector.getX());
        final Location location2 = location.clone().add(vector.clone().multiply(-1)).add(vector2.clone().multiply(-2));
        final HashMap hashMap = new HashMap();
        int[] nArray = new int[2];
        nArray[0] = n * 2 + 2;
        final int[] nArray2 = nArray;
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (nArray2[1] % 3 == 0 && nArray2[0] >= 0) {
                    Block block;
                    int n2;
                    if (nArray2[0] <= 1 || nArray2[0] == n + 2) {
                        n2 = 1;
                        while (n2 < 4) {
                            block = Utils.getHighestExposedBlock(location2.clone().add(vector2.clone().multiply(n2)), 3);
                            if (!(block == null || hashMap.containsKey(block) || block.getState() instanceof InventoryHolder || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                hashMap.put(block, block.getType());
                                block.setType(SwampBeast.this.mud);
                                world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 5, 0.4, 0.3, 0.4, 1.0, (Object)SwampBeast.this.mud.createBlockData());
                            }
                            ++n2;
                        }
                    } else {
                        n2 = 0;
                        while (n2 < 5) {
                            block = Utils.getHighestExposedBlock(location2.clone().add(vector2.clone().multiply(n2)), 3);
                            if (!(block == null || hashMap.containsKey(block) || block.getState() instanceof InventoryHolder || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                hashMap.put(block, block.getType());
                                block.setType(SwampBeast.this.mud);
                                world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 5, 0.4, 0.3, 0.4, 1.0, (Object)SwampBeast.this.mud.createBlockData());
                            }
                            ++n2;
                        }
                    }
                    if (((SwampBeast)SwampBeast.this).plugin.mcVersion >= 1.19) {
                        world.playSound(location2, Sound.BLOCK_MUD_BREAK, SoundCategory.BLOCKS, 1.0f, 0.5f);
                    }
                    location2.add(vector.clone().multiply(0.5));
                    nArray2[0] = nArray2[0] - 1;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (((Block)entry.getKey()).getType() != SwampBeast.this.mud) continue;
                    world.spawnParticle(Particle.FALLING_DUST, ((Block)entry.getKey()).getLocation().add(0.5, 1.0, 0.5), 1, 0.3, 0.1, 0.3, 1.0, (Object)SwampBeast.this.mud.createBlockData());
                    for (Entity entity : world.getNearbyEntities(((Block)entry.getKey()).getLocation().add(0.5, 1.5, 0.5), 0.5, 0.5, 0.5)) {
                        if (entity.hasMetadata("dd-swampbeast") || entity.hasMetadata("dd-halloweenmobs")) continue;
                        Vector vector3 = new Vector(entity.getVelocity().getX() / 8.0, entity.getVelocity().getY(), entity.getVelocity().getZ() / 8.0);
                        if (vector3.getY() > 0.0) {
                            vector3.setY(vector3.getY() / 8.0);
                        }
                        entity.setVelocity(vector3);
                        if (!(entity instanceof Player) || nArray2[1] % 5 != 0 || !(((SwampBeast)SwampBeast.this).plugin.mcVersion >= 1.19)) continue;
                        world.playSound(entity.getLocation(), Sound.BLOCK_MUD_PLACE, SoundCategory.BLOCKS, 0.3f, 0.5f);
                    }
                }
                if (nArray2[1] >= 200) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (((Block)entry.getKey()).getType() != SwampBeast.this.mud) continue;
                        ((Block)entry.getKey()).setType((Material)entry.getValue());
                    }
                    this.cancel();
                }
                nArray2[1] = nArray2[1] + 1;
            }
        };
    }
}

