/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.solarstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FirePhantom
extends CustomEntity {
    private Random rand;
    private double igniteChance;
    private Item[] items = new Item[6];

    public FirePhantom(Mob mob, Main main, Random random) {
        super(mob, main);
        this.rand = random;
        this.entityType = CustomEntityType.FIREPHANTOM;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(30.0);
        mob.setMetadata("dd-firephantom", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.setMetadata("dd-unburnable", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        if (main.mcVersion >= 1.17) {
            mob.setVisualFire(true);
        }
        this.igniteChance = (Double)this.entityType.grabCustomSetting("ignite_chance");
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.firePhantom"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null || this.entity.isDead()) {
            return;
        }
        Location location = this.entity.getLocation().clone();
        World world = location.getWorld();
        int n = 0;
        while (n < 15) {
            location.setY(location.getY() - 1.75);
            if (!location.getBlock().isPassable()) break;
            world.spawnParticle(Particle.FLAME, location, 1, 0.5, 1.0, 0.5, 0.3);
            world.playSound(location, Sound.BLOCK_FIRE_AMBIENT, SoundCategory.HOSTILE, 1.0f, 1.0f);
            for (Entity entity : world.getNearbyEntities(location, 1.0, 1.0, 1.0)) {
                entity.setFireTicks(200);
            }
            ++n;
        }
        location = this.entity.getLocation();
        n = 0;
        while (n < 15) {
            if (!location.getBlock().isPassable()) break;
            world.spawnParticle(Particle.FLAME, location, 1, 0.5, 1.0, 0.5, 0.3);
            world.playSound(location, Sound.BLOCK_FIRE_AMBIENT, SoundCategory.HOSTILE, 1.0f, 1.0f);
            for (Entity entity : world.getNearbyEntities(location, 1.0, 1.0, 1.0)) {
                entity.setFireTicks(100);
            }
            location.setY(location.getY() + 1.75);
            ++n;
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_PREPARE_ATTACK, SoundCategory.HOSTILE, 1.0f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.entity.getWorld().spawnParticle(Particle.SMOKE_LARGE, this.entity.getLocation(), 60, 0.7, 0.5, 0.7, 1.0E-4);
            this.explode();
            iterator.remove();
            return;
        }
        if (this.plugin.mcVersion < 1.17) {
            this.entity.setFireTicks(600);
        }
        Location location = this.entity.getLocation().clone();
        int n = 0;
        while (n < 20) {
            location.setY(location.getY() - 1.0);
            if (!location.getBlock().isPassable()) {
                Block block;
                if (!(this.rand.nextDouble() * 100.0 < this.igniteChance) || (block = location.add(0.0, 1.0, 0.0).getBlock()).getType() != Material.AIR && Utils.isBlockImmune(block.getType())) break;
                block.setType(Material.FIRE);
                break;
            }
            ++n;
        }
    }

    @Override
    public void clean() {
        Item[] itemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (item != null) {
                item.remove();
            }
            ++n2;
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void explode() {
        final World world = this.entity.getWorld();
        world.spawnParticle(Particle.FLAME, this.entity.getLocation(), 300, 0.0, 0.0, 0.0, 0.5);
        int n = 0;
        while (n < 6) {
            this.items[n] = world.dropItemNaturally(this.entity.getLocation(), new ItemStack(Material.BLAZE_POWDER));
            if (this.plugin.mcVersion >= 1.17) {
                this.items[n].setVisualFire(true);
            }
            this.items[n].setPickupDelay(100000);
            this.items[n].setMetadata("dd-invulnerable", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
            this.items[n].setVelocity(this.items[n].getVelocity().multiply(2));
            ++n;
        }
        final int[] nArray = new int[]{(Integer)this.entityType.grabCustomSetting("death_flames_life_ticks")};
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                Item item;
                int n;
                int n2;
                Item[] itemArray;
                nArray[0] = nArray[0] - 1;
                if (nArray[0] <= 0) {
                    this.cancel();
                    itemArray = FirePhantom.this.items;
                    n2 = FirePhantom.this.items.length;
                    n = 0;
                    while (n < n2) {
                        item = itemArray[n];
                        if (item != null) {
                            item.remove();
                        }
                        ++n;
                    }
                }
                itemArray = FirePhantom.this.items;
                n2 = FirePhantom.this.items.length;
                n = 0;
                while (n < n2) {
                    item = itemArray[n];
                    if (item != null) {
                        for (Entity entity : world.getNearbyEntities(item.getLocation(), 0.3, 0.3, 0.3)) {
                            entity.setFireTicks(6000);
                        }
                    }
                    ++n;
                }
            }
        };
    }
}

