/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.handlers.DifficultyLevel;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.BlockRegenHandler;
import deadlydisasters.utils.ChannelDataHolder;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class DestructionDisaster
extends DisasterEvent {
    protected Location loc;
    protected Player p;
    public Main plugin = Main.getInstance();
    public double volume;
    public static Map<World, Queue<Player>> currentLocations = new HashMap<World, Queue<Player>>();

    public DestructionDisaster(int n) {
        this.level = n;
        this.configFile = this.plugin.getConfig();
        this.dropItems = this.configFile.getBoolean("regeneration.drop_container_items");
    }

    public DestructionDisaster(int n, World world) {
        this.level = n;
        this.configFile = WorldObject.findWorldObject((World)world).configFile;
        this.dropItems = this.configFile.getBoolean("regeneration.drop_container_items");
    }

    public Disaster getType() {
        return this.type;
    }

    public abstract void start(Location var1, Player var2);

    public void broadcastMessage(Location location, Player player) {
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "destructive", this.type, location, player);
        }
    }

    public abstract void startAdjustment(Location var1, Player var2);

    public abstract Location findApplicableLocation(Location var1, Player var2);

    public void createTimedStart(int n, final Vector vector, final Player player) {
        this.loc = player.getLocation();
        if (!currentLocations.containsKey(this.loc.getWorld())) {
            currentLocations.put(this.loc.getWorld(), new ArrayDeque());
        }
        currentLocations.get(this.loc.getWorld()).add(player);
        this.inputPlayerToMap(n, player);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!currentLocations.containsKey(DestructionDisaster.this.loc.getWorld()) || !currentLocations.get(DestructionDisaster.this.loc.getWorld()).contains(player)) {
                    return;
                }
                currentLocations.get(DestructionDisaster.this.loc.getWorld()).remove(player);
                if (currentLocations.get(DestructionDisaster.this.loc.getWorld()).isEmpty()) {
                    currentLocations.remove(DestructionDisaster.this.loc.getWorld());
                }
                if (!player.isOnline()) {
                    return;
                }
                WorldObject worldObject = WorldObject.findWorldObject(player.getWorld());
                if (Utils.isPlayerImmune(player) || !worldObject.naturalAllowed || !worldObject.allowed.contains((Object)DestructionDisaster.this.type)) {
                    return;
                }
                final Location location = DestructionDisaster.this.findApplicableLocation(player.getLocation().clone().add(vector), player);
                if (location == null) {
                    return;
                }
                if (((Boolean)worldObject.settings.get("event_broadcast")).booleanValue() && DestructionDisaster.this.type != Disaster.GEYSER && DestructionDisaster.this.type != Disaster.PURGE && DestructionDisaster.this.type != Disaster.INFESTEDCAVES) {
                    Utils.broadcastEvent(DestructionDisaster.this.level, "destructive", DestructionDisaster.this.type, location, player);
                }
                if (currentLocations.containsKey(player.getWorld())) {
                    for (Entity entity : player.getNearbyEntities((double)worldObject.maxRadius, (double)worldObject.maxRadius, (double)worldObject.maxRadius)) {
                        if (!(entity instanceof Player) || !currentLocations.get(player.getWorld()).contains(entity)) continue;
                        currentLocations.get(player.getWorld()).remove(entity);
                    }
                    if (currentLocations.get(player.getWorld()).isEmpty()) {
                        currentLocations.remove(player.getWorld());
                    }
                }
                DestructionDisaster.this.plugin.getServer().getScheduler().runTaskLater((Plugin)DestructionDisaster.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DestructionDisaster.this.start(location, player);
                        Metrics.incrementValue(Metrics.disasterOccurredMap, (this).DestructionDisaster.this.type.getMetricsLabel());
                    }
                }, (long)DestructionDisaster.this.type.getDelayTicks());
            }
        }, (long)(n * 20));
    }

    public void triggerRegen(boolean bl) {
        RepeatingTask[] repeatingTaskArray;
        if (WorldObject.findWorldObject((World)this.loc.getWorld()).difficulty != DifficultyLevel.CUSTOM || (Integer)WorldObject.findWorldObject((World)this.loc.getWorld()).settings.get("regenDelay") < 0) {
            return;
        }
        this.UUIDToFalling.forEach((uUID, block) -> {
            if (Bukkit.getEntity((UUID)uUID) != null) {
                Bukkit.getEntity((UUID)uUID).remove();
            }
        });
        regeneratingDisasters.add(this);
        final DestructionDisaster destructionDisaster = this;
        if (bl) {
            this.reverseList();
        }
        this.damagedBlocks.putAll(this.physicBlocks);
        final double d = this.type.getDefaultRegenTickRate() * this.configFile.getDouble(String.valueOf(this.type.name().toLowerCase()) + ".regen_rate");
        final double[] dArray = new double[]{0.0};
        final HashMap hashMap = new HashMap();
        repeatingTaskArray = new RepeatingTask[]{new RepeatingTask(this.plugin, (Integer)WorldObject.findWorldObject((World)this.loc.getWorld()).settings.get("regenDelay") * 20, 1){

            @Override
            public void run() {
                dArray[0] = dArray[0] + d;
                while (dArray[0] >= 1.0) {
                    dArray[0] = dArray[0] - 1.0;
                    if (DestructionDisaster.this.damagedBlocks.isEmpty()) {
                        this.cancel();
                        regeneratingTasks.remove(repeatingTaskArray[0]);
                        regeneratingDisasters.remove(destructionDisaster);
                        BlockRegenHandler.gravityHold.removeAll(DestructionDisaster.this.gravityHoldBlocks);
                        break;
                    }
                    try {
                        Map.Entry entry = DestructionDisaster.this.damagedBlocks.entrySet().iterator().next();
                        Block block = (Block)entry.getKey();
                        Iterator iterator = DestructionDisaster.this.blockToBlock.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry2 = iterator.next();
                            if (((Block)entry2.getKey()).equals(block)) {
                                Block block2 = (Block)entry2.getValue();
                                if (block.equals(block2)) {
                                    iterator.remove();
                                    break;
                                }
                                if (block2.getState() instanceof InventoryHolder) {
                                    ItemStack[] itemStackArray = ((InventoryHolder)block2.getState()).getInventory().getContents();
                                    DestructionDisaster.this.plugin.getServer().getScheduler().runTaskLater((Plugin)DestructionDisaster.this.plugin, () -> ((InventoryHolder)block.getState()).getInventory().setContents(itemStackArray), 7L);
                                }
                                block2.setType(Material.AIR);
                                iterator.remove();
                                while (iterator.hasNext()) {
                                    entry2 = iterator.next();
                                    if (!((Block)entry2.getValue()).equals(block)) continue;
                                    if (block.getState() instanceof InventoryHolder) {
                                        hashMap.put((Block)entry2.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                                    }
                                    iterator.remove();
                                }
                                break;
                            }
                            if (!((Block)entry2.getValue()).equals(block)) continue;
                            if (block.getState() instanceof InventoryHolder) {
                                hashMap.put((Block)entry2.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                            }
                            iterator.remove();
                        }
                        if (Utils.isMaterialGravity(((BlockState)entry.getValue()).getType())) {
                            DestructionDisaster.this.gravityHoldBlocks.add(block);
                            BlockRegenHandler.gravityHold.add(block);
                        }
                        ((BlockState)entry.getValue()).update(true);
                        if (hashMap.containsKey(block)) {
                            DestructionDisaster.this.plugin.getServer().getScheduler().runTaskLater((Plugin)DestructionDisaster.this.plugin, () -> ((InventoryHolder)block.getState()).getInventory().setContents((ItemStack[])hashMap.get(block)), 7L);
                        }
                        DestructionDisaster.this.damagedBlocks.remove(block);
                        disasterBlocks.remove(block);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
            }
        }};
        regeneratingTasks.put(repeatingTaskArray[0], destructionDisaster);
    }

    public void awardPlayersInSet(Set<ChannelDataHolder> set, int n, String string) {
        if (!this.plugin.achievementsHandler.isEnabled) {
            return;
        }
        for (ChannelDataHolder channelDataHolder : set) {
            this.plugin.achievementsHandler.awardToSurvivalChannel(channelDataHolder, n, string);
        }
    }

    public void awardPlayersInSet(Set<ChannelDataHolder> set, int n, String string, int n2) {
        if (!this.plugin.achievementsHandler.isEnabled) {
            return;
        }
        for (ChannelDataHolder channelDataHolder : set) {
            this.plugin.achievementsHandler.awardToSurvivalChannel(channelDataHolder, n, string, n2);
        }
    }

    public void addPlayersToSurvivalChannel(Location location, double d, Set<ChannelDataHolder> set) {
        if (!this.plugin.achievementsHandler.isEnabled) {
            return;
        }
        for (Entity entity2 : location.getWorld().getNearbyEntities(location, d, d, d, entity -> entity instanceof Player && !Utils.isPlayerImmune((Player)entity))) {
            ChannelDataHolder channelDataHolder = new ChannelDataHolder((Player)entity2);
            set.add(channelDataHolder);
            this.plugin.achievementsHandler.addToSurvivalChannel(channelDataHolder);
        }
    }

    public void removePlayersFromSurvivalChannel(Set<ChannelDataHolder> set) {
        for (ChannelDataHolder channelDataHolder : set) {
            this.plugin.achievementsHandler.removeFromSurvivalChannel(channelDataHolder);
        }
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double d) {
        this.volume = d;
    }

    public Location getLocation() {
        return this.loc;
    }

    public void setLocation(Location location) {
        this.loc = location;
    }

    public Player getP() {
        return this.p;
    }

    public void setP(Player player) {
        this.p = player;
    }
}

