/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events;

import deadlydisasters.Main;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;

public enum Disaster {
    SINKHOLE("&eSinkHole", 2.0),
    CAVEIN("&7Cave In", 0.2),
    TORNADO("&fTornado", 1.0),
    GEYSER("&9Water Geyser/&cLava Geyser", 0.5),
    PLAGUE("&0Black Plague", 0.0),
    ACIDSTORM("&aAcid Storm", 0.5),
    EXTREMEWINDS("&fExtreme Winds", 0.3),
    SOULSTORM("&3Soul Storm", 0.0),
    BLIZZARD("&9Blizzard", 0.05),
    SANDSTORM("&eSandstorm", 0.0),
    EARTHQUAKE("&8Earthquake", 6.0),
    TSUNAMI("&1Tsunami", 0.5),
    METEORSHOWERS("&5Meteor Shower", 3.0),
    ENDSTORM("&5End Storm", 0.0),
    SUPERNOVA("&3Supernova", 25.0),
    HURRICANE("&7Hurricane", 0.3),
    PURGE("&8Purge", 0.0),
    SOLARSTORM("&eSolar Storm", 1.0),
    MONSOON("&9Monsoon", 0.7),
    INFESTEDCAVES("&3Infested Caves", 3.0),
    LANDSLIDE("&eLand Slide/&bAvalanche", 0.2),
    CUSTOM("&fCustom", 5.0);

    private String label;
    private String tip;
    private String metricsLabel;
    private int maxLevel;
    private int delayTicks;
    private int minHeight;
    private double frequency;
    private double defaultRegenTickRate;
    private static final Disaster[] copyOfValues;

    static {
        copyOfValues = Disaster.values();
    }

    private Disaster(String string2, double d) {
        this.label = string2;
        this.metricsLabel = string2.substring(2);
        this.defaultRegenTickRate = d;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public int getDelayTicks() {
        return this.delayTicks;
    }

    public void setDelayTicks(int n) {
        this.delayTicks = n;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int n) {
        this.minHeight = n;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double d) {
        this.frequency = d;
    }

    public double getDefaultRegenTickRate() {
        return this.defaultRegenTickRate;
    }

    public void setDefaultRegenTickRate(double d) {
        this.defaultRegenTickRate = d;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String string) {
        this.tip = string;
    }

    public String getMetricsLabel() {
        return this.metricsLabel;
    }

    public void setMetricsLabel(String string) {
        this.metricsLabel = string;
    }

    public static void reload(Main main) {
        Disaster[] disasterArray = Disaster.values();
        int n = disasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Disaster disaster = disasterArray[n2];
            if (disaster != CUSTOM) {
                if (disaster != PURGE) {
                    if (!Main.isSpigot()) {
                        disaster.setLabel(Utils.chat(main.getConfig().getString(String.valueOf(disaster.name().toLowerCase()) + ".name")));
                    } else {
                        disaster.setLabel(Utils.translateTextColor(main.getConfig().getString(String.valueOf(disaster.name().toLowerCase()) + ".name")));
                    }
                }
                disaster.setMaxLevel(main.getConfig().getInt(String.valueOf(disaster.name().toLowerCase()) + ".max_level"));
                if (disaster != INFESTEDCAVES) {
                    disaster.setDelayTicks(main.getConfig().getInt(String.valueOf(disaster.name().toLowerCase()) + ".start_delay") * 20);
                }
                disaster.setFrequency(main.getConfig().getDouble(String.valueOf(disaster.name().toLowerCase()) + ".frequency"));
                if (main.getConfig().contains(String.valueOf(disaster.name().toLowerCase()) + ".min_height")) {
                    disaster.setMinHeight(main.getConfig().getInt(String.valueOf(disaster.name().toLowerCase()) + ".min_height"));
                }
                if (Languages.langFile.contains("tips." + disaster.name().toLowerCase())) {
                    disaster.setTip(String.valueOf(Utils.chat("&7&o")) + Languages.getString("tips." + disaster.name().toLowerCase()));
                }
            }
            ++n2;
        }
    }

    public static Disaster forName(String string) {
        Disaster[] disasterArray = copyOfValues;
        int n = copyOfValues.length;
        int n2 = 0;
        while (n2 < n) {
            Disaster disaster = disasterArray[n2];
            if (disaster.name().equals(string)) {
                return disaster;
            }
            ++n2;
        }
        return null;
    }
}

