/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events;

import com.mojang.datafixers.util.Pair;
import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.listeners.BlockRegenHandler;
import deadlydisasters.utils.BlockStateParser;
import deadlydisasters.utils.ChannelDataHolder;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DisasterEvent {
    public Disaster type;
    public int level;
    public World world;
    public FileConfiguration configFile;
    public boolean dropItems;
    public static Queue<DisasterEvent> ongoingDisasters = new ArrayDeque<DisasterEvent>();
    public static Queue<DisasterEvent> regeneratingDisasters = new ArrayDeque<DisasterEvent>();
    public static Map<UUID, Map<DisasterEvent, Integer>> countdownMap = new HashMap<UUID, Map<DisasterEvent, Integer>>();
    public static Map<RepeatingTask, DisasterEvent> regeneratingTasks = new HashMap<RepeatingTask, DisasterEvent>();
    public Map<Block, BlockState> damagedBlocks = new LinkedHashMap<Block, BlockState>();
    public Map<Block, BlockState> physicBlocks = new LinkedHashMap<Block, BlockState>();
    public Map<Block, Block> blockToBlock = new HashMap<Block, Block>();
    public Set<Block> gravityHoldBlocks = new HashSet<Block>();
    public Map<UUID, Block> UUIDToFalling = new HashMap<UUID, Block>();
    public Set<UUID> fallingUUID = new HashSet<UUID>();
    public Map<Block, Pair<BlockData, String>> threadSafeRegen = new LinkedHashMap<Block, Pair<BlockData, String>>();
    public static Map<Block, DisasterEvent> disasterBlocks = new ConcurrentHashMap<Block, DisasterEvent>();
    protected Set<ChannelDataHolder> survivingPlayers = new HashSet<ChannelDataHolder>();

    public void addBlockToList(Block block, BlockState blockState) {
        if (disasterBlocks.containsKey(block) || this.damagedBlocks.containsKey(block)) {
            return;
        }
        if (this.dropItems && blockState instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)blockState;
            Location location = block.getLocation().add(0.5, 0.5, 0.5);
            ItemStack[] itemStackArray = blockInventoryHolder.getInventory().getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack itemStack = itemStackArray[n2];
                if (itemStack != null) {
                    block.getWorld().dropItemNaturally(location, itemStack.clone());
                }
                ++n2;
            }
            blockInventoryHolder.getInventory().setContents(new ItemStack[blockInventoryHolder.getInventory().getSize()]);
        }
        this.damagedBlocks.put(block, blockState);
        disasterBlocks.put(block, this);
    }

    public void addBlockWithTopToList(Block block, BlockState blockState) {
        if (!disasterBlocks.containsKey(block) && !this.damagedBlocks.containsKey(block)) {
            if (this.dropItems && blockState instanceof BlockInventoryHolder) {
                BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)blockState;
                Location location = block.getLocation().add(0.5, 0.5, 0.5);
                ItemStack[] itemStackArray = blockInventoryHolder.getInventory().getContents();
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack itemStack = itemStackArray[n2];
                    if (itemStack != null) {
                        block.getWorld().dropItemNaturally(location, itemStack.clone());
                    }
                    ++n2;
                }
                blockInventoryHolder.getInventory().setContents(new ItemStack[blockInventoryHolder.getInventory().getSize()]);
            }
            this.damagedBlocks.put(block, block.getState());
            disasterBlocks.put(block, this);
        }
        int n = 0;
        while (n < 5) {
            if ((block = block.getRelative(BlockFace.UP)).getType() == Material.AIR || block.isLiquid() || !block.isPassable() && !Utils.isMaterialGravity(block.getType())) {
                return;
            }
            if (!disasterBlocks.containsKey(block) && !this.damagedBlocks.containsKey(block)) {
                this.physicBlocks.put(block, block.getState());
                disasterBlocks.put(block, this);
            }
            ++n;
        }
    }

    public void addBlockWithTopToListAsync(Block block, BlockState blockState) {
        if (disasterBlocks.containsKey(block) || !this.damagedBlocks.containsKey(block)) {
            if (this.dropItems && blockState instanceof BlockInventoryHolder) {
                BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)blockState;
                Location location = block.getLocation().add(0.5, 0.5, 0.5);
                ItemStack[] itemStackArray = blockInventoryHolder.getInventory().getContents();
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack itemStack = itemStackArray[n2];
                    if (itemStack != null) {
                        block.getWorld().dropItemNaturally(location, itemStack.clone());
                    }
                    ++n2;
                }
                blockInventoryHolder.getInventory().setContents(new ItemStack[blockInventoryHolder.getInventory().getSize()]);
            }
            this.damagedBlocks.put(block, blockState);
            disasterBlocks.put(block, this);
        }
        Main.getInstance().getServer().getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            Block block2 = block;
            int n = 0;
            while (n < 5) {
                block2 = block2.getRelative(BlockFace.UP);
                if (block.getType() == Material.AIR || block.isLiquid() || !block.isPassable() && !Utils.isMaterialGravity(block.getType())) {
                    return;
                }
                if (!disasterBlocks.containsKey(block2) && !this.damagedBlocks.containsKey(block2)) {
                    this.physicBlocks.put(block2, block2.getState());
                    disasterBlocks.put(block2, this);
                }
                ++n;
            }
        });
    }

    public void reverseList() {
        if (this.damagedBlocks.size() <= 0) {
            return;
        }
        ArrayList<Block> arrayList = new ArrayList<Block>(this.damagedBlocks.keySet());
        Collections.reverse(arrayList);
        LinkedHashMap<Block, BlockState> linkedHashMap = new LinkedHashMap<Block, BlockState>();
        for (Block block : arrayList) {
            linkedHashMap.put(block, this.damagedBlocks.get(block));
        }
        this.damagedBlocks.clear();
        this.damagedBlocks.putAll(linkedHashMap);
    }

    public void inputPlayerToMap(int n, Player player) {
        if (!countdownMap.containsKey(player.getUniqueId())) {
            countdownMap.put(player.getUniqueId(), new HashMap());
        }
        countdownMap.get(player.getUniqueId()).put(this, n);
    }

    public void continueRegen(final Main main) {
        RepeatingTask[] repeatingTaskArray;
        this.dropItems = this.configFile.getBoolean("regeneration.drop_container_items");
        this.UUIDToFalling.forEach((uUID, block) -> {
            if (Bukkit.getEntity((UUID)uUID) != null) {
                Bukkit.getEntity((UUID)uUID).remove();
            }
        });
        final DisasterEvent disasterEvent = this;
        final double d = this.type.getDefaultRegenTickRate() * this.configFile.getDouble(String.valueOf(this.type.name().toLowerCase()) + ".regen_rate");
        final double[] dArray = new double[]{0.0};
        final HashMap hashMap = new HashMap();
        repeatingTaskArray = new RepeatingTask[]{new RepeatingTask(main, 0, 1){

            @Override
            public void run() {
                dArray[0] = dArray[0] + d;
                while (dArray[0] >= 1.0) {
                    dArray[0] = dArray[0] - 1.0;
                    if (DisasterEvent.this.threadSafeRegen.isEmpty()) {
                        this.cancel();
                        regeneratingTasks.remove(repeatingTaskArray[0]);
                        regeneratingDisasters.remove(disasterEvent);
                        BlockRegenHandler.gravityHold.removeAll(DisasterEvent.this.gravityHoldBlocks);
                        break;
                    }
                    try {
                        Map.Entry<Block, Pair<BlockData, String>> entry = DisasterEvent.this.threadSafeRegen.entrySet().iterator().next();
                        Block block = entry.getKey();
                        Iterator<Map.Entry<Block, Block>> iterator = DisasterEvent.this.blockToBlock.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<Block, Block> entry2 = iterator.next();
                            if (entry2.getKey().equals(block)) {
                                Block block2 = entry2.getValue();
                                if (block.equals(block2)) {
                                    iterator.remove();
                                    break;
                                }
                                if (block2.getState() instanceof InventoryHolder) {
                                    ItemStack[] itemStackArray = ((InventoryHolder)block2.getState()).getInventory().getContents();
                                    main.getServer().getScheduler().runTaskLater((Plugin)main, () -> ((InventoryHolder)block.getState()).getInventory().setContents(itemStackArray), 7L);
                                }
                                block2.setType(Material.AIR);
                                iterator.remove();
                                while (iterator.hasNext()) {
                                    entry2 = iterator.next();
                                    if (!entry2.getValue().equals(block)) continue;
                                    if (block.getState() instanceof InventoryHolder) {
                                        hashMap.put(entry2.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                                    }
                                    iterator.remove();
                                }
                                break;
                            }
                            if (!entry2.getValue().equals(block)) continue;
                            if (block.getState() instanceof InventoryHolder) {
                                hashMap.put(entry2.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                            }
                            iterator.remove();
                        }
                        if (Utils.isMaterialGravity(((BlockData)entry.getValue().getFirst()).getMaterial())) {
                            DisasterEvent.this.gravityHoldBlocks.add(block);
                            BlockRegenHandler.gravityHold.add(block);
                        }
                        block.setBlockData((BlockData)entry.getValue().getFirst());
                        if (entry.getValue().getSecond() != null) {
                            BlockStateParser.deserializeToBlock((String)entry.getValue().getSecond(), block);
                        }
                        if (hashMap.containsKey(block)) {
                            main.getServer().getScheduler().runTaskLater((Plugin)main, () -> ((InventoryHolder)block.getState()).getInventory().setContents((ItemStack[])hashMap.get(block)), 7L);
                        }
                        DisasterEvent.this.threadSafeRegen.remove(block);
                        disasterBlocks.remove(block);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
            }
        }};
        regeneratingTasks.put(repeatingTaskArray[0], disasterEvent);
    }
}

