/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class Geyser
extends DestructionDisaster {
    private boolean finished;
    private boolean overworld;
    private boolean push;
    private Location mem;
    private Geyser me = this;
    private double damageAmount;
    private int amount;
    private int width = 1;
    private Material material;
    private int tickSpeed = 1;
    private Particle particleType;
    private Vector velocity = new Vector(0, 3, 0);
    private int minReach;
    private int maxReach;
    private int range;
    private Sound sound;
    private int spawnInterval = 10;
    private int blocksDestroyed;

    public Geyser(int n) {
        super(n);
        this.damageAmount = this.configFile.getDouble("geyser.water_damage");
        this.volume = this.configFile.getDouble("geyser.volume");
        this.amount = n;
        this.material = Material.WATER;
        this.range = n * 2;
        this.sound = Sound.BLOCK_FIRE_EXTINGUISH;
        this.type = Disaster.GEYSER;
    }

    public Geyser(int n, Particle particle, double d, Vector vector, int n2, Material material, int n3, int n4, int n5, double d2, Sound sound) {
        super(n);
        this.damageAmount = d;
        this.material = material;
        this.particleType = particle;
        this.velocity = vector;
        this.tickSpeed = n2;
        this.width = n3;
        this.minReach = n4;
        this.maxReach = n5;
        this.volume = d2;
        this.sound = sound;
        this.type = Disaster.GEYSER;
    }

    @Override
    public void start(final Location location, Player player) {
        if (location.getWorld().getEnvironment() == World.Environment.NETHER && location.getBlockY() >= 128) {
            return;
        }
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        this.loc = location;
        double d = this.plugin.mcVersion;
        if (Utils.isEnvironment(location.getWorld(), World.Environment.NORMAL)) {
            this.overworld = true;
            if (this.particleType == null) {
                this.particleType = d >= 1.14 ? Particle.FALLING_WATER : Particle.WATER_SPLASH;
            }
            if (this.minReach == 0 || this.maxReach == 0) {
                this.minReach = 100;
                this.maxReach = 256;
            }
        } else {
            if (this.material == Material.WATER) {
                this.material = Material.LAVA;
            }
            if (this.particleType == null) {
                this.particleType = d >= 1.14 ? Particle.FALLING_LAVA : Particle.FLAME;
            }
            if (this.velocity.getY() == 3.0) {
                this.velocity = new Vector(0, 1, 0);
            }
            if (this.minReach == 0 || this.maxReach == 0) {
                this.minReach = 60;
                this.maxReach = 120;
            }
        }
        this.maxReach -= this.minReach;
        final Random random = this.plugin.random;
        new RepeatingTask(this.plugin, 0, this.spawnInterval){

            @Override
            public void run() {
                Geyser geyser = new Geyser(1, Geyser.this.particleType, Geyser.this.damageAmount, Geyser.this.velocity, Geyser.this.tickSpeed, Geyser.this.material, Geyser.this.width, Geyser.this.minReach, Geyser.this.maxReach, Geyser.this.volume, Geyser.this.sound);
                Location location2 = new Location(location.getWorld(), (double)ThreadLocalRandom.current().nextInt(location.getBlockX() - Geyser.this.range, location.getBlockX() + Geyser.this.range + 1), location.getY(), (double)ThreadLocalRandom.current().nextInt(location.getBlockZ() - Geyser.this.range, location.getBlockZ() + Geyser.this.range + 1));
                if (Geyser.this.overworld) {
                    geyser.createWater(location2, random);
                } else {
                    geyser.createLava(location2, random);
                }
                --Geyser.this.amount;
                if (Geyser.this.amount <= 0) {
                    this.cancel();
                }
            }
        };
    }

    public void createWater(Location location, final Random random) {
        ongoingDisasters.add(this);
        this.loc = location.clone();
        this.mem = location.clone();
        final int n = location.getBlockY();
        while (n > this.plugin.maxDepth + 5) {
            this.loc.setY((double)n);
            if (this.loc.getBlock().getType() == Material.WATER) break;
            --n;
        }
        n = random.nextInt(this.maxReach) + this.minReach;
        this.mem.setY(this.loc.getY());
        final int[] nArray = new int[]{this.loc.getBlockX(), this.loc.getBlockX() + this.width};
        final int[] nArray2 = new int[]{this.loc.getBlockZ(), this.loc.getBlockZ() + this.width};
        if (this.plugin.RegionProtection) {
            Location location2 = location.clone();
            int n2 = nArray[0] - 3;
            while (n2 < nArray[1] + 3) {
                int n3 = nArray2[0] - 3;
                while (n3 < nArray2[1] + 3) {
                    location2.setX((double)n2);
                    location2.setZ((double)n3);
                    if (Utils.isZoneProtected(location2)) {
                        return;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        DeathMessages.geysers.add(this);
        new RepeatingTask(this.plugin, 0, this.tickSpeed){

            @Override
            public void run() {
                int n4 = 0;
                while (n4 < 3) {
                    if (Geyser.this.loc.getBlockY() <= n) {
                        Geyser.this.loc.setY(Geyser.this.loc.getY() + 1.0);
                        int n2 = nArray[0];
                        while (n2 <= nArray[1]) {
                            int n3 = nArray2[0];
                            while (n3 <= nArray2[1]) {
                                Location location = new Location(Geyser.this.loc.getWorld(), (double)n2, Geyser.this.loc.getY(), (double)n3);
                                Block block = location.getBlock();
                                if (block.getType() != Geyser.this.material && !Utils.passStrengthTest(location.getBlock().getType()) && !Utils.isZoneProtected(location)) {
                                    if (Geyser.this.plugin.CProtect) {
                                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", location, block.getType(), block.getBlockData());
                                    }
                                    Geyser.this.addBlockWithTopToList(block, block.getState());
                                    block.setType(Geyser.this.material);
                                    ++Geyser.this.blocksDestroyed;
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                    } else {
                        new RepeatingTask(Geyser.this.plugin, 40, Geyser.this.tickSpeed){

                            @Override
                            public void run() {
                                if (!(this).Geyser.this.push) {
                                    (this).Geyser.this.push = true;
                                }
                                int n = 0;
                                while (n < 3) {
                                    if (Geyser.this.loc.getBlockY() >= (this).Geyser.this.mem.getBlockY()) {
                                        int n2 = nArray[0] - 2;
                                        while (n2 <= nArray[1] + 2) {
                                            int n3 = nArray2[0] - 2;
                                            while (n3 <= nArray2[1] + 2) {
                                                Block block = new Location(Geyser.this.loc.getWorld(), (double)n2, Geyser.this.loc.getY(), (double)n3).getBlock();
                                                if (block.getType() == (this).Geyser.this.material) {
                                                    block.setType(Material.AIR);
                                                    ++(this).Geyser.this.blocksDestroyed;
                                                } else if (random.nextInt(3) == 0 && block.getType() != Material.AIR && !Utils.passStrengthTest(block.getType()) && !Utils.isZoneProtected(block.getLocation())) {
                                                    if ((this).Geyser.this.plugin.CProtect) {
                                                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                                    }
                                                    Geyser.this.addBlockWithTopToList(block, block.getState());
                                                    block.setType(Material.AIR);
                                                    ++(this).Geyser.this.blocksDestroyed;
                                                }
                                                ++n3;
                                            }
                                            ++n2;
                                        }
                                    } else {
                                        DeathMessages.geysers.remove((this).Geyser.this.me);
                                        (this).Geyser.this.finished = true;
                                        this.cancel();
                                        ongoingDisasters.remove((this).Geyser.this.me);
                                        Geyser.this.reverseList();
                                        Geyser.this.triggerRegen(true);
                                        Metrics.incrementValue(Metrics.disasterDestroyedMap, (this).Geyser.this.type.getMetricsLabel(), (this).Geyser.this.blocksDestroyed);
                                        return;
                                    }
                                    Geyser.this.loc.getWorld().spawnParticle((this).Geyser.this.particleType, Geyser.this.loc.getX() - 0.5, Geyser.this.loc.getY(), Geyser.this.loc.getZ() - 0.5, 10, 1.5, 0.5, 1.5, 1.0);
                                    Geyser.this.loc.setY(Geyser.this.loc.getY() - 1.0);
                                    ++n;
                                }
                                for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 20.0, 256.0, 20.0)) {
                                    if (!(entity instanceof Player) || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() + 20) continue;
                                    ((Player)entity).playSound(Geyser.this.loc, (this).Geyser.this.sound, (float)(1.0 * (this).Geyser.this.volume), 0.5f);
                                }
                            }
                        };
                        new RepeatingTask(Geyser.this.plugin, 0, 1){

                            @Override
                            public void run() {
                                if (Geyser.this.loc.getBlockY() <= n + 20) {
                                    Geyser.this.loc.setY((double)(Geyser.this.loc.getBlockY() + 1));
                                    Geyser.this.loc.getWorld().spawnParticle((this).Geyser.this.particleType, (double)nArray[0] + 0.5, Geyser.this.loc.getY(), (double)nArray2[0] + 0.5, 10, 1.5, 0.5, 1.5, 1.0);
                                    return;
                                }
                                Geyser.this.loc.setY(Geyser.this.loc.getY() - 20.0);
                                this.cancel();
                            }
                        };
                        this.cancel();
                        break;
                    }
                    ++n4;
                }
                for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 20.0, Geyser.this.loc.getY(), 20.0)) {
                    if (!(entity instanceof Player) || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() + 20) continue;
                    ((Player)entity).playSound(Geyser.this.loc, Geyser.this.sound, (float)(1.0 * Geyser.this.volume), 0.5f);
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 2.0, Geyser.this.loc.getY(), 2.0)) {
                    if (entity.getLocation().getBlockX() < nArray[0] - 1 || entity.getLocation().getBlockX() > nArray[1] + 1 || entity.getLocation().getBlockZ() < nArray2[0] - 1 || entity.getLocation().getBlockZ() > nArray2[1] + 1 || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() || entity.getLocation().getBlockY() < Geyser.this.mem.getBlockY()) continue;
                    entity.setVelocity(Geyser.this.velocity);
                }
                if (Geyser.this.push) {
                    this.cancel();
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 10){

            @Override
            public void run() {
                for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 2.0, Geyser.this.loc.getY(), 2.0)) {
                    if (!(entity instanceof LivingEntity) || entity.getLocation().getBlockX() < nArray[0] - 1 || entity.getLocation().getBlockX() > nArray[1] + 1 || entity.getLocation().getBlockZ() < nArray2[0] - 1 || entity.getLocation().getBlockZ() > nArray2[1] + 1 || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() || entity.getLocation().getBlockY() < Geyser.this.mem.getBlockY() || ((LivingEntity)entity).hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) continue;
                    Utils.pureDamageEntity((LivingEntity)entity, Geyser.this.damageAmount, "dd-geyserdeath", false, null);
                }
                if (Geyser.this.finished) {
                    this.cancel();
                }
            }
        };
    }

    public void createLava(Location location, final Random random) {
        ongoingDisasters.add(this);
        this.loc = location.clone();
        this.mem = location.clone();
        final int n = location.getBlockY();
        while (n > 5) {
            this.loc.setY((double)n);
            if (this.loc.getBlock().getType() == Material.LAVA) break;
            --n;
        }
        n = random.nextInt(this.maxReach) + this.minReach;
        this.mem.setY(this.loc.getY());
        final int[] nArray = new int[]{this.loc.getBlockX(), this.loc.getBlockX() + this.width};
        final int[] nArray2 = new int[]{this.loc.getBlockZ(), this.loc.getBlockZ() + this.width};
        if (this.plugin.RegionProtection) {
            Location location2 = location.clone();
            int n2 = nArray[0] - 3;
            while (n2 < nArray[1] + 3) {
                int n3 = nArray2[0] - 3;
                while (n3 < nArray2[1] + 3) {
                    location2.setX((double)n2);
                    location2.setZ((double)n3);
                    if (Utils.isZoneProtected(location2)) {
                        return;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        DeathMessages.geysers.add(this);
        new RepeatingTask(this.plugin, 0, this.tickSpeed){

            @Override
            public void run() {
                if (Geyser.this.loc.getBlockY() < n) {
                    Geyser.this.loc.setY(Geyser.this.loc.getY() + 1.0);
                    int n3 = nArray[0];
                    while (n3 <= nArray[1]) {
                        int n2 = nArray2[0];
                        while (n2 <= nArray2[1]) {
                            Location location = new Location(Geyser.this.loc.getWorld(), (double)n3, Geyser.this.loc.getY(), (double)n2);
                            Block block = location.getBlock();
                            if (block.getType() != Geyser.this.material && !Utils.passStrengthTest(block.getType()) && !Utils.isZoneProtected(location)) {
                                if (Geyser.this.plugin.CProtect) {
                                    Utils.getCoreProtect().logRemoval("Deadly-Disasters", location, block.getType(), block.getBlockData());
                                }
                                Geyser.this.addBlockWithTopToList(block, block.getState());
                                block.setType(Geyser.this.material);
                                ++Geyser.this.blocksDestroyed;
                            }
                            ++n2;
                        }
                        ++n3;
                    }
                    for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 2.0, 128.0, 2.0)) {
                        if (entity.getLocation().getBlockX() < nArray[0] || entity.getLocation().getBlockX() > nArray[1] || entity.getLocation().getBlockZ() < nArray2[0] || entity.getLocation().getBlockZ() > nArray2[1] || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() || entity.getLocation().getBlockY() < Geyser.this.mem.getBlockY()) continue;
                        entity.setVelocity(new Vector(0, 1, 0));
                    }
                } else {
                    new RepeatingTask(Geyser.this.plugin, 100, Geyser.this.tickSpeed){

                        @Override
                        public void run() {
                            if (!(this).Geyser.this.push) {
                                (this).Geyser.this.push = true;
                            }
                            if (Geyser.this.loc.getBlockY() >= (this).Geyser.this.mem.getBlockY()) {
                                int n = nArray[0] - 2;
                                while (n <= nArray[1] + 2) {
                                    int n2 = nArray2[0] - 2;
                                    while (n2 <= nArray2[1] + 2) {
                                        Location location = new Location(Geyser.this.loc.getWorld(), (double)n, Geyser.this.loc.getY(), (double)n2);
                                        if (location.getBlock().getType() == (this).Geyser.this.material) {
                                            location.getBlock().setType(Material.AIR);
                                            ++(this).Geyser.this.blocksDestroyed;
                                        } else if (random.nextInt(3) == 0 && location.getBlock().getType() != Material.AIR && !Utils.passStrengthTest(location.getBlock().getType()) && !Utils.isZoneProtected(location)) {
                                            if ((this).Geyser.this.plugin.CProtect) {
                                                Utils.getCoreProtect().logRemoval("Deadly-Disasters", location, location.getBlock().getType(), location.getBlock().getBlockData());
                                            }
                                            Geyser.this.addBlockWithTopToList(location.getBlock(), location.getBlock().getState());
                                            location.getBlock().setType(Material.AIR);
                                            ++(this).Geyser.this.blocksDestroyed;
                                        }
                                        ++n2;
                                    }
                                    ++n;
                                }
                            } else {
                                (this).Geyser.this.finished = true;
                                DeathMessages.geysers.remove((this).Geyser.this.me);
                                this.cancel();
                                ongoingDisasters.remove((this).Geyser.this.me);
                                Geyser.this.reverseList();
                                Geyser.this.triggerRegen(true);
                                Metrics.incrementValue(Metrics.disasterDestroyedMap, (this).Geyser.this.type.getMetricsLabel(), (this).Geyser.this.blocksDestroyed);
                                return;
                            }
                            Geyser.this.loc.getWorld().spawnParticle((this).Geyser.this.particleType, (double)nArray[0] + 0.5, Geyser.this.loc.getY(), (double)nArray2[0] + 0.5, 10, 1.5, 0.5, 1.5, 1.0);
                            Geyser.this.loc.setY(Geyser.this.loc.getY() - 1.0);
                            for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 20.0, 128.0, 20.0)) {
                                if (!(entity instanceof Player) || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() + 20) continue;
                                ((Player)entity).playSound(Geyser.this.loc, (this).Geyser.this.sound, (float)(1.0 * (this).Geyser.this.volume), 0.5f);
                            }
                        }
                    };
                    new RepeatingTask(Geyser.this.plugin, 0, 1){

                        @Override
                        public void run() {
                            if (Geyser.this.loc.getBlockY() <= n + 10) {
                                Geyser.this.loc.setY((double)(Geyser.this.loc.getBlockY() + 1));
                                Geyser.this.loc.getWorld().spawnParticle((this).Geyser.this.particleType, Geyser.this.loc.getX() - 0.5, Geyser.this.loc.getY(), Geyser.this.loc.getZ() - 0.5, 10, 1.5, 0.5, 1.5, 1.0);
                                return;
                            }
                            Geyser.this.loc.setY(Geyser.this.loc.getY() - 10.0);
                            this.cancel();
                        }
                    };
                    this.cancel();
                }
                for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 20.0, 128.0, 20.0)) {
                    if (!(entity instanceof Player) || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() + 20) continue;
                    ((Player)entity).playSound(Geyser.this.loc, Geyser.this.sound, (float)(1.0 * Geyser.this.volume), 0.5f);
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                for (Entity entity : Geyser.this.loc.getWorld().getNearbyEntities(Geyser.this.loc, 2.0, Geyser.this.loc.getY(), 2.0)) {
                    if (entity.getLocation().getBlockX() < nArray[0] - 1 || entity.getLocation().getBlockX() > nArray[1] + 1 || entity.getLocation().getBlockZ() < nArray2[0] - 1 || entity.getLocation().getBlockZ() > nArray2[1] + 1 || entity.getLocation().getBlockY() > Geyser.this.loc.getBlockY() || entity.getLocation().getBlockY() < Geyser.this.mem.getBlockY()) continue;
                    entity.setVelocity(Geyser.this.velocity);
                }
                if (Geyser.this.push) {
                    this.cancel();
                }
            }
        };
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = Utils.getBlockBelow(location).getLocation()).getBlockY() < this.type.getMinHeight() || location.getWorld().getEnvironment() == World.Environment.THE_END) {
            return null;
        }
        this.broadcastMessage(location, player);
        return location;
    }

    @Override
    public void broadcastMessage(Location location, Player player) {
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            String string = this.configFile.getString("messages.destructive.level " + this.level);
            string = string.replace("%location%", String.valueOf(location.getBlockX()) + " " + location.getBlockY() + " " + location.getBlockZ());
            string = player != null ? string.replace("%player%", player.getName()) : string.replace("%player%", "");
            string = location.getWorld().getEnvironment() == World.Environment.NORMAL ? string.replace("%disaster%", this.type.getLabel().substring(0, this.type.getLabel().indexOf(47))) : string.replace("%disaster%", this.type.getLabel().substring(this.type.getLabel().indexOf(47) + 1));
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            if (this.configFile.getBoolean("messages.disaster_tips")) {
                string = String.valueOf(string) + "\n" + this.type.getTip();
            }
            for (Player player2 : location.getWorld().getPlayers()) {
                player2.sendMessage(string);
            }
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string + ChatColor.GREEN + " (" + location.getWorld().getName() + ")");
        }
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(location, player);
    }

    public int getX() {
        return this.loc.getBlockX();
    }

    public int getZ() {
        return this.loc.getBlockZ();
    }

    public int getY() {
        return this.loc.getBlockY();
    }

    public int getMemory() {
        return this.mem.getBlockY();
    }

    public double getDamage() {
        return this.damageAmount;
    }

    public void setDamage(double d) {
        this.damageAmount = d;
    }

    public int getMiniGeyserAmount() {
        return this.amount;
    }

    public void setMiniGeyserAmount(int n) {
        this.amount = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public int getTickSpeed() {
        return this.tickSpeed;
    }

    public void setTickSpeed(int n) {
        this.tickSpeed = n;
    }

    public Particle getParticle() {
        return this.particleType;
    }

    public void setParticle(Particle particle) {
        this.particleType = particle;
    }

    public void setYVelocity(double d) {
        this.velocity = new Vector(0.0, d, 0.0);
    }

    public int getMinReach() {
        return this.minReach;
    }

    public void setMinReach(int n) {
        this.minReach = n;
    }

    public int getMaxReach() {
        return this.maxReach;
    }

    public void setMaxReach(int n) {
        this.maxReach = n;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int n) {
        this.range = n;
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    public int getSpawnInterval() {
        return this.spawnInterval;
    }

    public void setSpawnInterval(int n) {
        this.spawnInterval = n;
    }
}

