/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.events.disasters.Meteor;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MeteorShower
extends WeatherDisaster {
    private MeteorShower me;
    private boolean night;
    private int max;
    private int tick_speed;
    private int cycle;
    public int smokeTime;
    private BukkitTask id;
    private long timeMemory;
    public double version;
    public FixedMetadataValue fixdata;
    public boolean customized;
    private int[] allowedTypes = new int[]{1, 2, 3};
    public Material normalMaterial;
    public Material explodingMaterial;
    public Material splittingMaterial;
    public Particle particle;
    public double explosionDamage = 10.0;
    public double splitImpact = 1.0;
    public double[] speeds = new double[]{1.0, 1.0, 1.0};
    public int[][] meteorSizes = new int[][]{{2, 6}, {2, 6}, {2, 6}};
    private int spawnRate = 7;
    public int blocksDestroyed;
    public boolean spawnOres = true;
    public List<Meteor> list = new ArrayList<Meteor>();
    public Map<Location, List<Integer>> smoke = new HashMap<Location, List<Integer>>();

    public MeteorShower(int n) {
        super(n);
        this.night = this.configFile.getBoolean("meteorshowers.set_night");
        this.max = this.configFile.getInt("meteorshowers.max_meteors");
        this.time = this.configFile.getInt("meteorshowers.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("meteorshowers.start_delay") * 20;
        this.tick_speed = this.configFile.getInt("meteorshowers.tick_speed");
        this.smokeTime = this.configFile.getInt("meteorshowers.smoke_time") * 20;
        this.volume = this.configFile.getDouble("meteorshowers.volume");
        this.cycle = this.tick_speed;
        this.me = this;
        this.version = this.plugin.mcVersion;
        this.fixdata = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
        this.particle = Particle.SMOKE_LARGE;
        this.normalMaterial = this.plugin.mcVersion >= 1.17 ? Material.DEEPSLATE : Material.STONE;
        this.explodingMaterial = Material.MAGMA_BLOCK;
        this.splittingMaterial = this.plugin.mcVersion >= 1.17 ? Material.CALCITE : Material.DIORITE;
        this.type = Disaster.METEORSHOWERS;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        ongoingDisasters.add(this);
        int[] nArray = this.meteorSizes[0];
        nArray[1] = nArray[1] - this.meteorSizes[0][0];
        int[] nArray2 = this.meteorSizes[1];
        nArray2[1] = nArray2[1] - this.meteorSizes[1][0];
        int[] nArray3 = this.meteorSizes[2];
        nArray3[1] = nArray3[1] - this.meteorSizes[2][0];
        int n = 0;
        while (n < this.allowedTypes.length) {
            if (this.allowedTypes[n] == 0) {
                this.allowedTypes = Utils.removeElement(this.allowedTypes, n);
                --n;
            }
            ++n;
        }
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.meteorshowers.add(this);
        if (this.night) {
            this.timeMemory = world.getTime();
        }
        final Random random = new Random();
        this.id = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (MeteorShower.this.time <= 20) {
                    DeathMessages.meteorshowers.remove(MeteorShower.this.me);
                }
                if (MeteorShower.this.time <= 0) {
                    MeteorShower.this.id.cancel();
                    DeathMessages.meteorshowers.remove(MeteorShower.this.me);
                    for (Meteor meteor : MeteorShower.this.list) {
                        meteor.removeBlocks();
                    }
                    MeteorShower.this.list.clear();
                    return;
                }
                MeteorShower meteorShower = MeteorShower.this;
                meteorShower.time = meteorShower.time - 20;
                if (MeteorShower.this.time > 0 && random.nextInt(MeteorShower.this.spawnRate) == 0) {
                    if (Bukkit.getOnlinePlayers().size() == 0) {
                        return;
                    }
                    int n = 0;
                    while (n < MeteorShower.this.max / 3) {
                        Player player = (Player)Bukkit.getOnlinePlayers().toArray()[random.nextInt(Bukkit.getOnlinePlayers().size())];
                        if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
                            Location location = new Location(world, (double)(player.getLocation().getBlockX() + (random.nextInt(30) - 15)), (double)player.getLocation().getBlockY(), (double)(player.getLocation().getBlockZ() + (random.nextInt(30) - 15)));
                            Location location2 = new Location(world, (double)(player.getLocation().getBlockX() + (random.nextInt(100) - 50)), (double)Math.min(player.getLocation().getBlockY() + 70, 320), (double)(player.getLocation().getBlockZ() + (random.nextInt(100) - 50)));
                            if (!Utils.isZoneProtected(player.getLocation()) && !Utils.isZoneProtected(location)) {
                                MeteorShower.this.list.add(new Meteor(location2, location, MeteorShower.this.allowedTypes[random.nextInt(MeteorShower.this.allowedTypes.length)], world, MeteorShower.this.me, random, 0));
                                if (n >= Bukkit.getOnlinePlayers().size() - 1) break;
                            }
                        }
                        ++n;
                    }
                }
            }
        }, (long)this.delay, 20L);
        new RepeatingTask(this.plugin, this.delay, 1){

            @Override
            public void run() {
                long l = world.getTime();
                if (MeteorShower.this.time <= 0 && MeteorShower.this.list.isEmpty()) {
                    if (MeteorShower.this.night && (l < MeteorShower.this.timeMemory - 300L || l > MeteorShower.this.timeMemory + 300L)) {
                        world.setTime(l + 200L);
                        if (DeathMessages.meteorshowers.stream().anyMatch(meteorShower -> meteorShower.getWorld().equals(world))) {
                            this.cancel();
                        }
                        return;
                    }
                    ongoingDisasters.remove(MeteorShower.this.me);
                    MeteorShower.this.triggerRegen(true);
                    this.cancel();
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, MeteorShower.this.type.getMetricsLabel(), MeteorShower.this.blocksDestroyed);
                    return;
                }
                int n = MeteorShower.this.list.size() / MeteorShower.this.tick_speed * MeteorShower.this.cycle;
                while (n > MeteorShower.this.list.size() / MeteorShower.this.tick_speed * (MeteorShower.this.cycle - 1)) {
                    MeteorShower.this.list.get(n - 1).tick(random);
                    --n;
                }
                if (MeteorShower.this.list.size() == 1) {
                    MeteorShower.this.list.get(0).tick(random);
                }
                MeteorShower.this.cycle = MeteorShower.this.cycle <= 1 ? MeteorShower.this.tick_speed : --MeteorShower.this.cycle;
                Iterator<Map.Entry<Location, List<Integer>>> iterator = MeteorShower.this.smoke.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Location, List<Integer>> entry = iterator.next();
                    List<Integer> list = entry.getValue();
                    int n2 = list.get(1);
                    world.spawnParticle(MeteorShower.this.particle, entry.getKey(), n2 * 5, (double)n2, (double)n2, (double)n2, 0.001);
                    if (list.get(0) <= 0) {
                        iterator.remove();
                    } else {
                        list.set(0, list.get(0) - 1);
                    }
                    entry.setValue(list);
                }
                if (MeteorShower.this.night && (l < 19700L || l > 20300L)) {
                    world.setTime(l + 200L);
                }
            }
        };
    }

    @Override
    public void clear() {
        this.time = 0;
    }

    public static void spawnMeteor(final int n, Location location, Location location2, int n2) {
        World world;
        final MeteorShower meteorShower = new MeteorShower(1);
        meteorShower.world = world = location.getWorld();
        ongoingDisasters.add(meteorShower);
        final Random random = new Random();
        if (n2 <= 0) {
            n2 = random.nextInt(meteorShower.meteorSizes[n - 1][1]) + meteorShower.meteorSizes[n - 1][0];
        }
        final Meteor meteor = new Meteor(location, location2, n, world, meteorShower, random, n2);
        new RepeatingTask(Main.getInstance(), 0, 1){

            @Override
            public void run() {
                if (!meteor.exists) {
                    this.cancel();
                    ongoingDisasters.remove(meteorShower);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, Disaster.METEORSHOWERS.getMetricsLabel(), meteorShower.blocksDestroyed);
                    if (n == 1) {
                        new RepeatingTask(Main.getInstance(), 0, 1){

                            @Override
                            public void run() {
                                Iterator<Map.Entry<Location, List<Integer>>> iterator = meteorShower.smoke.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry<Location, List<Integer>> entry = iterator.next();
                                    List<Integer> list = entry.getValue();
                                    int n = list.get(1);
                                    world.spawnParticle(meteorShower.particle, entry.getKey(), n * 5, (double)n, (double)n, (double)n, 0.001);
                                    if (list.get(0) <= 0) {
                                        iterator.remove();
                                    } else {
                                        list.set(0, list.get(0) - 1);
                                    }
                                    entry.setValue(list);
                                }
                                if (meteorShower.smoke.isEmpty()) {
                                    this.cancel();
                                    meteorShower.triggerRegen(true);
                                }
                            }
                        };
                    } else {
                        meteorShower.triggerRegen(true);
                    }
                    return;
                }
                meteor.tick(random);
            }
        };
    }

    public boolean isNight() {
        return this.night;
    }

    public void setNight(boolean bl) {
        this.night = bl;
    }

    public int getSmokeTime() {
        return this.smokeTime;
    }

    public void setSmokeTime(int n) {
        this.smokeTime = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int[] getAllowedTypes() {
        return this.allowedTypes;
    }

    public void setAllowedTypes(int[] nArray) {
        this.allowedTypes = nArray;
    }

    public Material getNormalMaterial() {
        return this.normalMaterial;
    }

    public void setNormalMaterial(Material material) {
        this.normalMaterial = material;
        this.customized = true;
    }

    public Material getExplodingMaterial() {
        return this.explodingMaterial;
    }

    public void setExplodingMaterial(Material material) {
        this.explodingMaterial = material;
        this.customized = true;
    }

    public Material getSplittingMaterial() {
        return this.splittingMaterial;
    }

    public void setSplittingMaterial(Material material) {
        this.splittingMaterial = material;
        this.customized = true;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public double getExplosionDamage() {
        return this.explosionDamage;
    }

    public void setExplosionDamage(double d) {
        this.explosionDamage = d;
    }

    public double getSplitImpact() {
        return this.splitImpact;
    }

    public void setSplitImpact(double d) {
        this.splitImpact = d;
    }

    public boolean isSpawnOres() {
        return this.spawnOres;
    }

    public void setSpawnOres(boolean bl) {
        this.spawnOres = bl;
    }

    public double[] getSpeeds() {
        return this.speeds;
    }

    public void setSpeeds(double[] dArray) {
        this.speeds = dArray;
    }

    public int[][] getMeteorSizes() {
        return this.meteorSizes;
    }

    public void setMeteorSizes(int[][] nArray) {
        this.meteorSizes = nArray;
    }

    public int getSpawnRate() {
        return this.spawnRate;
    }

    public void setSpawnRate(int n) {
        this.spawnRate = n;
    }
}

