/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.disasters.Places;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Sinkhole
extends DestructionDisaster {
    private Queue<Places> placements = new ArrayDeque<Places>();
    private Location memory;
    private int speed;
    public int maxD;
    public int blocksDestroyed;
    private double radius = 0.0;
    private double size;
    public Random rand;
    public Map<Block, Integer> liquidBlocks = new HashMap<Block, Integer>();
    public static Set<Material> treeBlocks = new HashSet<Material>();

    public Sinkhole(int n) {
        super(n);
        this.rand = this.plugin.random;
        this.maxD = this.plugin.maxDepth + 5;
        this.speed = this.configFile.getInt("sinkhole.speed");
        this.size = this.configFile.getDouble("sinkhole.size");
        this.volume = this.configFile.getDouble("sinkhole.volume");
        switch (n) {
            default: {
                this.radius = 4.0;
                break;
            }
            case 2: {
                this.radius = 6.0;
                break;
            }
            case 3: {
                this.radius = 10.0;
                break;
            }
            case 4: {
                this.radius = 15.0;
                break;
            }
            case 5: {
                this.radius = 20.0;
                break;
            }
            case 6: {
                this.radius = 50.0;
            }
        }
        this.type = Disaster.SINKHOLE;
    }

    @Override
    public void start(final Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        ongoingDisasters.add(this);
        this.loc = location;
        this.radius *= this.size;
        World world = location.getWorld();
        this.memory = location.clone();
        DeathMessages.sinkholes.add(this);
        final Sinkhole sinkhole = this;
        this.addPlayersToSurvivalChannel(location.clone().subtract(0.0, this.radius / 2.0, 0.0), this.radius + 5.0, this.survivingPlayers);
        final ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>();
        BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
        final int n = (int)(-this.radius);
        while ((double)n < this.radius) {
            int n2 = (int)(-this.radius);
            while ((double)n2 < this.radius) {
                Vector vector = blockVector.clone().add(new Vector(n, 0, n2));
                if (blockVector.distance(vector) <= this.radius) {
                    arrayDeque.add(world.getBlockAt(vector.toLocation(world)));
                }
                ++n2;
            }
            ++n;
        }
        n = Math.min(arrayDeque.size() / 10, 150);
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                Iterator iterator = arrayDeque.iterator();
                int n7 = 0;
                while (n7 < n) {
                    int n2;
                    if (!iterator.hasNext()) break;
                    Object object = (Block)iterator.next();
                    int n3 = 0;
                    if (!object.isPassable()) {
                        n2 = 0;
                        while (n2 < Sinkhole.this.rand.nextInt(15) + 5) {
                            if ((object = object.getRelative(BlockFace.UP)).isPassable()) {
                                object = object.getRelative(BlockFace.DOWN);
                                break;
                            }
                            if (treeBlocks.contains(object.getType())) {
                                ++n3;
                            }
                            ++n2;
                        }
                    } else {
                        n2 = object.getLocation().getBlockY();
                        while (n2 > Sinkhole.this.maxD) {
                            if ((object = object.getRelative(BlockFace.DOWN)).isPassable()) {
                                --n2;
                                continue;
                            }
                            break;
                        }
                    }
                    Location location2 = object.getLocation();
                    int n4 = 0;
                    double d = location2.add(0.5, 0.5, 0.5).distance(location);
                    n4 = d >= Sinkhole.this.radius / 4.0 * 3.0 ? (int)(Sinkhole.this.radius - d + (double)n3) : (int)(((double)Sinkhole.this.rand.nextInt((int)Sinkhole.this.radius) + Sinkhole.this.radius - d) * (double)Sinkhole.this.level);
                    Sinkhole.this.placements.add(new Places((Block)object, n4, sinkhole));
                    if (treeBlocks.contains(object.getType())) {
                        int n5 = location2.getBlockX() - 3;
                        while (n5 < location2.getBlockX() + 3) {
                            int n6 = location2.getBlockZ() - 3;
                            while (n6 < location2.getBlockZ() + 3) {
                                if ((n5 != location2.getBlockX() || n6 != location2.getBlockZ()) && treeBlocks.contains(location2.getWorld().getHighestBlockAt(n5, n6).getType())) {
                                    Sinkhole.this.placements.add(new Places(new Location(location2.getWorld(), (double)n5, (double)location2.getWorld().getHighestBlockYAt(n5, n6), (double)n6).getBlock(), n4, sinkhole));
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                    }
                    iterator.remove();
                    ++n7;
                }
                if (!iterator.hasNext()) {
                    Sinkhole.this.placements = new ArrayDeque<Places>(Sinkhole.this.placements.stream().sorted(Comparator.comparingDouble(places -> places.getBlock().getLocation().distanceSquared(location))).collect(Collectors.toList()));
                    for (Entity entity : Sinkhole.this.memory.getWorld().getNearbyEntities(Sinkhole.this.memory, Sinkhole.this.radius + 20.0, 128.0, Sinkhole.this.radius + 20.0)) {
                        if (!(entity instanceof Player) || entity.getLocation().getBlockY() > Sinkhole.this.memory.getBlockY() + 40) continue;
                        ((Player)entity).playSound(entity.getLocation(), Sound.ITEM_TOTEM_USE, (float)(0.33 * (double)Sinkhole.this.level * Sinkhole.this.volume), 0.5f);
                    }
                    Sinkhole.this.placements.forEach(places -> places.addTopBlock());
                    new RepeatingTask(Sinkhole.this.plugin, 0, Sinkhole.this.speed){

                        @Override
                        public void run() {
                            Iterator<Places> iterator = (this).Sinkhole.this.placements.iterator();
                            while (iterator.hasNext()) {
                                ((Places)iterator.next()).dig(iterator);
                            }
                            Iterator<Map.Entry<Block, Integer>> iterator2 = (this).Sinkhole.this.liquidBlocks.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry<Block, Integer> entry = iterator2.next();
                                if (entry.getKey().isLiquid()) {
                                    entry.getKey().setType(Material.AIR);
                                }
                                entry.setValue(entry.getValue() - 1);
                                if (entry.getValue() > 0) continue;
                                iterator2.remove();
                            }
                            if ((this).Sinkhole.this.placements.isEmpty()) {
                                (this).Sinkhole.this.plugin.getServer().getScheduler().runTaskLater((Plugin)(this).Sinkhole.this.plugin, new Runnable(){

                                    @Override
                                    public void run() {
                                        DeathMessages.sinkholes.remove(sinkhole);
                                    }
                                }, 200L);
                                Sinkhole.this.triggerRegen(true);
                                this.cancel();
                                ongoingDisasters.remove(sinkhole);
                                Metrics.incrementValue(Metrics.disasterDestroyedMap, (this).Sinkhole.this.type.getMetricsLabel(), (this).Sinkhole.this.blocksDestroyed);
                                (this).Sinkhole.this.plugin.getServer().getScheduler().runTaskLater((Plugin)(this).Sinkhole.this.plugin, () -> {
                                    Sinkhole.this.awardPlayersInSet(Sinkhole.this.survivingPlayers, 1, "disasters.survival.sinkhole");
                                    if ((this).Sinkhole.this.level >= 6) {
                                        Sinkhole.this.awardPlayersInSet(Sinkhole.this.survivingPlayers, 1, "disasters.survival.level_six", 0);
                                    }
                                    Sinkhole.this.removePlayersFromSurvivalChannel(Sinkhole.this.survivingPlayers);
                                }, 80L);
                            }
                        }
                    };
                    this.cancel();
                    return;
                }
            }
        };
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = Utils.getBlockBelow(location).getLocation()).getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(Utils.getBlockBelow(location).getLocation(), player);
    }

    public int getX() {
        return this.memory.getBlockX();
    }

    public int getY() {
        return this.memory.getBlockY();
    }

    public int getZ() {
        return this.memory.getBlockZ();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }
}

