/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.LinkedHashSet;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Supernova
extends DestructionDisaster {
    private double size;
    private double sizeMultiplier;
    private double particleMultiplier;
    private int tick = 1;
    private EnderCrystal crystal;
    private Particle particle;
    private Material[] materials;
    private boolean flash;
    private boolean farParticles;
    private int blocksDestroyed;

    public Supernova(int n) {
        super(n);
        switch (n) {
            default: {
                this.size = 35.0;
                break;
            }
            case 2: {
                this.size = 45.0;
                break;
            }
            case 3: {
                this.size = 57.0;
                break;
            }
            case 4: {
                this.size = 70.0;
                break;
            }
            case 5: {
                this.size = 85.0;
                break;
            }
            case 6: {
                this.size = 100.0;
            }
        }
        this.volume = this.configFile.getDouble("supernova.volume");
        this.particleMultiplier = this.configFile.getDouble("supernova.particle_multiplier");
        this.flash = this.configFile.getBoolean("supernova.flash");
        this.sizeMultiplier = this.configFile.getDouble("supernova.size");
        this.particle = Particle.EXPLOSION_LARGE;
        this.materials = new Material[]{Material.OBSIDIAN, Material.BLACK_CONCRETE, Material.FIRE};
        if (!this.configFile.getBoolean("supernova.place_fire")) {
            this.materials = new Material[]{Material.OBSIDIAN, Material.BLACK_CONCRETE};
        }
        this.farParticles = this.configFile.getBoolean("supernova.far_particles");
        this.type = Disaster.SUPERNOVA;
    }

    @Override
    public void start(final Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        this.loc = location;
        ongoingDisasters.add(this);
        DeathMessages.supernovas.add(this);
        this.size *= this.sizeMultiplier;
        final World world = location.getWorld();
        final Location location2 = location.clone();
        location2.setY(320.0);
        final Location location3 = location2.clone();
        this.crystal = (EnderCrystal)world.spawnEntity(location3, EntityType.ENDER_CRYSTAL);
        this.crystal.setShowingBottom(false);
        this.crystal.setBeamTarget(location2);
        final Vector vector = new Vector(0, -2, 0);
        this.addPlayersToSurvivalChannel(location, this.size, this.survivingPlayers);
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                location3.add(vector);
                if (vector.getY() < -0.5) {
                    vector.setY(vector.getY() + 0.01);
                }
                Supernova.this.crystal.remove();
                Supernova.this.crystal = (EnderCrystal)world.spawnEntity(location3, EntityType.ENDER_CRYSTAL);
                Supernova.this.crystal.setShowingBottom(false);
                Supernova.this.crystal.setBeamTarget(location2);
                world.spawnParticle(Particle.CLOUD, location3, 10, 0.5, 0.5, 0.5, 0.01, null, true);
                world.spawnParticle(Particle.FLAME, location3, 10, 0.5, 0.5, 0.5, 0.01, null, true);
                Block block = location3.clone().subtract(0.0, 1.0, 0.0).getBlock();
                if (block.getType() != Material.AIR && !Utils.isBlockImmune(block.getType()) && !Utils.isZoneProtected(block.getLocation())) {
                    if (Supernova.this.plugin.CProtect) {
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                    }
                    Supernova.this.addBlockToList(block, block.getState());
                    block.setType(Material.AIR);
                    ++Supernova.this.blocksDestroyed;
                }
                if (location3.distance(location) < 3.0) {
                    Supernova.this.crystal.remove();
                    this.cancel();
                    Supernova.this.explode(world);
                }
                if (Supernova.this.flash) {
                    for (Entity entity : world.getNearbyEntities(location, 140.0, 100.0, 140.0)) {
                        if (!(entity instanceof Player)) continue;
                        Location location4 = entity.getLocation();
                        ((Player)entity).spawnParticle(Particle.FLASH, location4.clone().add(new Vector(location4.getX() - location3.getX(), location4.getY() - location3.getY(), location4.getZ() - location3.getZ()).normalize().multiply(-3)), 1, 1.0, 1.0, 1.0, 0.001);
                    }
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 10){

            @Override
            public void run() {
                if (Supernova.this.tick > 1) {
                    this.cancel();
                }
                if (Supernova.this.plugin.mcVersion >= 1.16) {
                    for (Entity entity : world.getNearbyEntities(location, 140.0, 140.0, 140.0)) {
                        if (!(entity instanceof Player)) continue;
                        Location location2 = entity.getLocation();
                        ((Player)entity).playSound(location2.clone().add(new Vector(location2.getX() - location3.getX(), location2.getY() - location3.getY(), location2.getZ() - location3.getZ()).normalize().multiply(-4)), Sound.AMBIENT_NETHER_WASTES_MOOD, (float)((2.0 - 0.002 * location3.distance(entity.getLocation())) * Supernova.this.volume), 0.5f);
                    }
                }
            }
        };
    }

    private void explode(final World world) {
        final BlockVector blockVector = new BlockVector(this.loc.getX(), this.loc.getY(), this.loc.getZ());
        final Random random = new Random();
        final boolean bl = this.plugin.CProtect;
        final Supernova supernova = this;
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if ((double)Supernova.this.tick > Supernova.this.size) {
                    this.cancel();
                    ongoingDisasters.remove(supernova);
                    DeathMessages.supernovas.remove(supernova);
                    Supernova.this.triggerRegen(true);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, Supernova.this.type.getMetricsLabel(), Supernova.this.blocksDestroyed);
                    Supernova.this.awardPlayersInSet(Supernova.this.survivingPlayers, 1, "disasters.survival.supernova");
                    if (Supernova.this.level >= 6) {
                        Supernova.this.awardPlayersInSet(Supernova.this.survivingPlayers, 1, "disasters.survival.level_six", 4);
                    }
                    Supernova.this.removePlayersFromSurvivalChannel(Supernova.this.survivingPlayers);
                    return;
                }
                final LinkedHashSet<Block> linkedHashSet = new LinkedHashSet<Block>(Supernova.this.tick * Supernova.this.tick * Supernova.this.tick);
                int n = -Supernova.this.tick;
                while (n < Supernova.this.tick) {
                    int n2 = -Supernova.this.tick;
                    while (n2 < Supernova.this.tick) {
                        int n3 = -Supernova.this.tick;
                        while (n3 < Supernova.this.tick) {
                            Vector vector = blockVector.clone().add(new Vector(n, n2, n3));
                            if (blockVector.distance(vector) >= (double)(Supernova.this.tick - 1) && blockVector.distance(vector) <= (double)Supernova.this.tick) {
                                Block block = world.getBlockAt(vector.toLocation(world));
                                linkedHashSet.add(block);
                                if (block.getType() != Material.AIR && !Utils.isBlockImmune(block.getType()) && !Utils.isZoneProtected(block.getLocation())) {
                                    if (bl) {
                                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                    }
                                    if ((double)Supernova.this.tick > Supernova.this.size - 2.0 && random.nextInt(8) == 0) {
                                        Material material = Supernova.this.materials[random.nextInt(Supernova.this.materials.length)];
                                        if (bl) {
                                            Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), material, material.createBlockData());
                                        }
                                        Supernova.this.addBlockWithTopToList(block, block.getState());
                                        block.setType(material);
                                        ++Supernova.this.blocksDestroyed;
                                    } else {
                                        Supernova.this.addBlockWithTopToList(block, block.getState());
                                        block.setType(Material.AIR);
                                        ++Supernova.this.blocksDestroyed;
                                    }
                                }
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n;
                }
                ++Supernova.this.tick;
                Supernova.this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)Supernova.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        int n = (int)Math.ceil((double)(1 + linkedHashSet.size() / 1000) * (this).Supernova.this.particleMultiplier);
                        for (Block block : linkedHashSet) {
                            if (random.nextInt(n) != 0) continue;
                            world.spawnParticle((this).Supernova.this.particle, block.getLocation(), 1, 0.0, 0.0, 0.0, 1.0, null, (this).Supernova.this.farParticles);
                        }
                    }
                });
            }
        };
        new RepeatingTask(this.plugin, 0, 10){

            @Override
            public void run() {
                if ((double)Supernova.this.tick > Supernova.this.size) {
                    this.cancel();
                    return;
                }
                for (Entity entity : world.getNearbyEntities(Supernova.this.loc, (double)(Supernova.this.tick + 100), (double)(Supernova.this.tick + 100), (double)(Supernova.this.tick + 100))) {
                    if (!(entity instanceof LivingEntity) || entity.isDead()) continue;
                    if (Supernova.this.loc.distance(entity.getLocation()) < (double)Supernova.this.tick) {
                        if (Utils.isZoneProtected(entity.getLocation()) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                        Utils.pureDamageEntity((LivingEntity)entity, 20.0, "dd-supernova", true, null);
                        continue;
                    }
                    if (!(entity instanceof Player)) continue;
                    Location location = entity.getLocation().clone().add(new Vector(entity.getLocation().getX() - Supernova.this.loc.getX(), entity.getLocation().getY() - Supernova.this.loc.getY(), entity.getLocation().getZ() - Supernova.this.loc.getZ()).normalize().multiply(-4));
                    float f = (float)((2.0 - (5.0E-4 * Supernova.this.loc.distance(entity.getLocation()) - (double)Supernova.this.tick)) * Supernova.this.volume);
                    if (Supernova.this.plugin.mcVersion >= 1.16) {
                        ((Player)entity).playSound(location, Sound.AMBIENT_WARPED_FOREST_MOOD, f, 0.5f);
                    }
                    ((Player)entity).playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, f, 0.5f);
                    ((Player)entity).playSound(location, Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, f / 30.0f, 0.5f);
                }
            }
        };
    }

    public void removeCrystal() {
        if (this.crystal != null) {
            this.crystal.remove();
        }
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = Utils.getBlockBelow(location).getLocation()).getBlockY() < this.type.getMinHeight() || location.getWorld().getEnvironment() == World.Environment.NETHER) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(Utils.getBlockBelow(location).getLocation(), player);
    }

    public double getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public void setSizeMultiplier(double d) {
        this.sizeMultiplier = d;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public Material[] getMaterials() {
        return this.materials;
    }

    public void setMaterials(Material[] materialArray) {
        this.materials = materialArray;
    }

    public boolean isFlash() {
        return this.flash;
    }

    public void setFlash(boolean bl) {
        this.flash = bl;
    }

    public double getParticles() {
        return this.particleMultiplier;
    }

    public void setParticles(double d) {
        this.particleMultiplier = d;
    }
}

