/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class Tornado
extends DestructionDisaster {
    private double speed;
    private double size;
    private double pullForce;
    private double height;
    private double particles;
    private double yVelocity = 0.35;
    private int max_blocks;
    private int time;
    private int width;
    private int pickupRange;
    private int particleCount;
    private int blocksDestroyed;
    private World world;
    private boolean CP;
    private Particle particleType;
    private BlockData[] materials;
    public static Set<Material> bannedBlocks = new HashSet<Material>();
    public Map<UUID, Integer> cooldownEntities = new ConcurrentHashMap<UUID, Integer>();
    public Map<UUID, Integer> holdEntities = new ConcurrentHashMap<UUID, Integer>();
    public Map<UUID, Double> velocityMap = new ConcurrentHashMap<UUID, Double>();

    public Tornado(int n) {
        super(n);
        switch (n) {
            default: {
                this.time = 600;
                this.size = 30.0;
                break;
            }
            case 2: {
                this.time = 700;
                this.size = 40.0;
                break;
            }
            case 3: {
                this.time = 800;
                this.size = 50.0;
                break;
            }
            case 4: {
                this.time = 900;
                this.size = 60.0;
                break;
            }
            case 5: {
                this.time = 1000;
                this.size = 75.0;
                break;
            }
            case 6: {
                this.time = 1200;
                this.size = 90.0;
            }
        }
        this.size *= this.configFile.getDouble("tornado.size");
        this.time = (int)((double)this.time * this.configFile.getDouble("tornado.time_multiplier"));
        this.max_blocks = this.configFile.getInt("tornado.max_entities.level " + n);
        this.speed = 3.0 * this.configFile.getDouble("tornado.speed");
        this.particles = 1.0 * this.configFile.getDouble("tornado.particleAmount");
        this.volume = (float)(0.33 * (double)n * this.configFile.getDouble("tornado.volume"));
        this.CP = this.plugin.CProtect;
        this.particleType = Particle.CLOUD;
        this.pullForce = -(0.02 * (double)n);
        this.height = this.size + (double)(n * 7);
        this.width = this.configFile.getInt("tornado.width");
        this.pickupRange = (int)(this.size * this.configFile.getDouble("tornado.block_pickup_range"));
        this.particleCount = 8 - n;
        this.type = Disaster.TORNADO;
    }

    @Override
    public void start(Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        ongoingDisasters.add(this);
        DeathMessages.tornados.add(this);
        this.p = player;
        this.loc = location.clone().subtract(0.0, (double)(this.level * 2 + (6 - this.level)), 0.0);
        this.world = location.getWorld();
        this.spawnTornado();
    }

    public void spawnTornado() {
        Entity entity2;
        final Random random = this.plugin.random;
        final Vector vector = new Vector(random.nextDouble() - 0.5, 0.0, random.nextDouble() - 0.5).normalize().multiply(0.05);
        final Vector vector2 = new Vector(0.0, (double)this.level / 20.0, 0.0);
        final Vector vector3 = vector2.clone().multiply((double)this.level / 5.0);
        final FixedMetadataValue fixedMetadataValue = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
        int n = 180 - this.level * 15;
        final int n2 = 80 + this.level * 40;
        final double d = 1.0 / this.size;
        final double d2 = (double)this.level * 0.5 / this.size;
        final ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        this.addPlayersToSurvivalChannel(this.loc.clone().add(0.0, this.size / 2.0, 0.0), this.size + 5.0, this.survivingPlayers);
        for (Entity entity2 : this.world.getNearbyEntities(this.loc.clone().add(0.0, this.size - 5.0, 0.0), this.size, this.size, this.size)) {
            if (!(entity2 instanceof LivingEntity)) continue;
            this.cooldownEntities.put(entity2.getUniqueId(), random.nextInt(n));
        }
        entity2 = new Entity[]{this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable((BukkitTask[])entity2, random, n){
            private final /* synthetic */ BukkitTask[] val$task;
            private final /* synthetic */ Random val$rand;
            private final /* synthetic */ int val$cooldownTicks;
            {
                this.val$task = bukkitTaskArray;
                this.val$rand = random;
                this.val$cooldownTicks = n;
            }

            @Override
            public void run() {
                Map.Entry<UUID, Integer> entry;
                if (Tornado.this.time <= 0) {
                    this.val$task[0].cancel();
                    return;
                }
                Iterator<Map.Entry<UUID, Integer>> iterator = Tornado.this.cooldownEntities.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (entry.getValue() <= 0) {
                        iterator.remove();
                        continue;
                    }
                    entry.setValue(entry.getValue() - 1);
                }
                iterator = Tornado.this.holdEntities.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (entry.getValue() <= 0) {
                        Tornado.this.cooldownEntities.putIfAbsent(entry.getKey(), this.val$rand.nextInt(this.val$cooldownTicks) + this.val$cooldownTicks / 2);
                        iterator.remove();
                        continue;
                    }
                    entry.setValue(entry.getValue() - 1);
                }
            }
        }, 0L, 1L)};
        final Tornado tornado = this;
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (Tornado.this.time <= 0) {
                    this.cancel();
                    Tornado.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Tornado.this.plugin, () -> {
                        boolean bl = DeathMessages.tornados.remove(tornado);
                    }, 100L);
                    return;
                }
                --Tornado.this.time;
                Tornado.this.loc.add(vector);
                Iterator iterator = keySetView.iterator();
                HashSet<UUID> hashSet = new HashSet<UUID>();
                while (iterator.hasNext()) {
                    Vector vector4;
                    Entity entity = Bukkit.getEntity((UUID)((UUID)iterator.next()));
                    if (entity == null) continue;
                    double d3 = entity.getLocation().getY() - Tornado.this.loc.getY();
                    if (d3 > Tornado.this.height) {
                        iterator.remove();
                        continue;
                    }
                    Location location = entity.getLocation();
                    if (!(entity instanceof LivingEntity) && location.getX() < Tornado.this.loc.getX() + d3 && location.getX() > Tornado.this.loc.getX() - d3 && location.getZ() < Tornado.this.loc.getZ() + d3 && location.getZ() > Tornado.this.loc.getZ() - d3 || entity instanceof LivingEntity && location.getX() < Tornado.this.loc.getX() + d3 / 3.0 && location.getX() > Tornado.this.loc.getX() - d3 / 3.0 && location.getZ() < Tornado.this.loc.getZ() + d3 / 3.0 && location.getZ() > Tornado.this.loc.getZ() - d3 / 3.0) {
                        vector4 = new Vector(location.getX() - Tornado.this.loc.getX(), 0.0, location.getZ() - Tornado.this.loc.getZ()).rotateAroundY(1.5).normalize().multiply(d3 / (double)Tornado.this.width).multiply(Tornado.this.speed + random.nextDouble() * 2.0).add(new Vector(0.0, Tornado.this.velocityMap.get(entity.getUniqueId()).doubleValue(), 0.0));
                        entity.setVelocity(vector4);
                        if (entity instanceof Player) {
                            ((Player)entity).spawnParticle(Tornado.this.particleType, location.add(0.0, 1.0, 0.0), 30, 1.0, 1.0, 1.0, 0.3);
                            Block block = entity.getLocation().clone().add(entity.getVelocity()).getBlock();
                            if (!(block.isPassable() || disasterBlocks.containsKey(block) || Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                hashSet.add(Tornado.this.addBlock(block, fixedMetadataValue, Tornado.this.pullForce, random));
                            }
                            if (!((block = block.getRelative(BlockFace.UP)).isPassable() || disasterBlocks.containsKey(block) || Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                hashSet.add(Tornado.this.addBlock(block, fixedMetadataValue, Tornado.this.pullForce, random));
                            }
                        }
                        if (!(random.nextDouble() < Tornado.this.particles)) continue;
                        if (Tornado.this.particleType == Particle.CLOUD) {
                            double d22 = (double)Tornado.this.level * 0.5 - new Location(location.getWorld(), location.getX(), Tornado.this.loc.getY(), location.getZ()).distance(Tornado.this.loc) * d2;
                            vector4.normalize();
                            int n = 0;
                            while (n < Tornado.this.particleCount) {
                                Tornado.this.world.spawnParticle(Tornado.this.particleType, location.clone().add(random.nextDouble() * 3.0 - 1.5, random.nextDouble() * 3.0 - 1.5, random.nextDouble() * 3.0 - 1.5), 0, vector4.getX() * d22, (random.nextDouble() - 0.2) / 1.5 * d22, vector4.getZ() * d22, 1.0, null, true);
                                ++n;
                            }
                            continue;
                        }
                        int n = 0;
                        while (n < Tornado.this.particleCount) {
                            Tornado.this.world.spawnParticle(Tornado.this.particleType, location, Tornado.this.particleCount, 1.0, 1.0, 1.0, 0.3, null, true);
                            ++n;
                        }
                        continue;
                    }
                    if (entity instanceof LivingEntity) {
                        if (entity.getVelocity().getY() > 0.4) {
                            vector4 = new Vector(location.getX() - Tornado.this.loc.getX(), 0.0, location.getZ() - Tornado.this.loc.getZ()).normalize().multiply(Tornado.this.pullForce).multiply((Tornado.this.size + 1.0 - location.distance(Tornado.this.loc)) * d);
                            if (entity instanceof Player && Tornado.this.plugin.achievementsHandler.isMasteryActive(entity.getUniqueId(), "disasters.survival.tornado")) {
                                vector4.multiply(Tornado.this.plugin.achievementsHandler.getMasteryPower(entity.getUniqueId(), "disasters.survival.tornado"));
                            }
                            entity.setVelocity(entity.getVelocity().add(vector4));
                        } else {
                            vector4 = new Vector(location.getX() - Tornado.this.loc.getX(), 0.0, location.getZ() - Tornado.this.loc.getZ()).normalize().multiply(Tornado.this.pullForce).add(vector3).multiply((Tornado.this.size + 1.0 - location.distance(Tornado.this.loc)) * d);
                            if (entity instanceof Player && Tornado.this.plugin.achievementsHandler.isMasteryActive(entity.getUniqueId(), "disasters.survival.tornado")) {
                                vector4.multiply(Tornado.this.plugin.achievementsHandler.getMasteryPower(entity.getUniqueId(), "disasters.survival.tornado"));
                            }
                            entity.setVelocity(entity.getVelocity().add(vector4));
                        }
                        vector4 = entity.getLocation().clone().add(entity.getVelocity().clone().setY(0.3)).getBlock();
                        if (!(vector4.isPassable() || disasterBlocks.containsKey(vector4) || Utils.passStrengthTest(vector4.getType()) || Utils.isZoneProtected(vector4.getLocation()))) {
                            hashSet.add(Tornado.this.addBlock((Block)vector4, fixedMetadataValue, Tornado.this.pullForce, random));
                        }
                        if ((vector4 = vector4.getRelative(BlockFace.UP)).isPassable() || disasterBlocks.containsKey(vector4) || Utils.passStrengthTest(vector4.getType()) || Utils.isZoneProtected(vector4.getLocation())) continue;
                        hashSet.add(Tornado.this.addBlock((Block)vector4, fixedMetadataValue, Tornado.this.pullForce, random));
                        continue;
                    }
                    entity.setVelocity(new Vector(location.getX() - Tornado.this.loc.getX(), 0.0, location.getZ() - Tornado.this.loc.getZ()).normalize().multiply(Tornado.this.pullForce * 3.0).add(vector2));
                }
                keySetView.addAll(hashSet);
                if (keySetView.size() < Tornado.this.max_blocks) {
                    int n = 0;
                    while (n < Tornado.this.level * 4) {
                        Block block = Tornado.this.loc.clone().add((double)(random.nextInt(Tornado.this.pickupRange * 2) - Tornado.this.pickupRange), (double)random.nextInt((int)(Tornado.this.size / 2.0)) + Tornado.this.size / 3.0, (double)(random.nextInt(Tornado.this.pickupRange * 2) - Tornado.this.pickupRange)).getBlock();
                        int n2 = 1;
                        while (n2 < 40) {
                            if (!(block.isPassable() || bannedBlocks.contains(block.getType()) || disasterBlocks.containsKey(block) || Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                keySetView.add(Tornado.this.addBlock(block, fixedMetadataValue, Tornado.this.pullForce, random));
                                break;
                            }
                            block = block.getRelative(BlockFace.DOWN);
                            ++n2;
                        }
                        ++n;
                    }
                }
            }
        };
        new RepeatingTask(this.plugin, 200, 10){

            @Override
            public void run() {
                Block block;
                if (Tornado.this.time <= 0 || Utils.isZoneProtected(Tornado.this.loc)) {
                    Tornado.this.time = 0;
                    Tornado.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Tornado.this.plugin, () -> {
                        ongoingDisasters.remove(tornado);
                        Tornado.this.triggerRegen(true);
                    }, 160L);
                    this.cancel();
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, Tornado.this.type.getMetricsLabel(), Tornado.this.blocksDestroyed);
                    Tornado.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Tornado.this.plugin, () -> {
                        Tornado.this.awardPlayersInSet(Tornado.this.survivingPlayers, 1, "disasters.survival.tornado");
                        if (Tornado.this.level >= 6) {
                            Tornado.this.awardPlayersInSet(Tornado.this.survivingPlayers, 1, "disasters.survival.level_six", 2);
                        }
                        Tornado.this.removePlayersFromSurvivalChannel(Tornado.this.survivingPlayers);
                    }, 80L);
                    return;
                }
                keySetView.clear();
                Location location = Tornado.this.loc.clone().add(vector.clone().multiply(2));
                if (location.clone().add(0.0, (double)(Tornado.this.level * 2 + (6 - Tornado.this.level) + 1), 0.0).getBlock().getType().isSolid()) {
                    Tornado.this.loc.setY(Tornado.this.loc.getY() + 1.0);
                } else if (location.clone().add(0.0, (double)(Tornado.this.level * 2 + (6 - Tornado.this.level) - 1), 0.0).getBlock().getType() == Material.AIR) {
                    Tornado.this.loc.setY(Tornado.this.loc.getY() - 1.0);
                }
                location = Tornado.this.loc.clone().add(vector);
                int n = (int)Tornado.this.size;
                while (n >= 0) {
                    int n22 = -n / 5;
                    while (n22 < n / 5) {
                        block = location.clone().add(new Vector(vector.getZ(), 0.0, -vector.getX()).normalize().multiply(n22).add(new Vector(0, n, 0))).getBlock();
                        if (!(block.isPassable() || bannedBlocks.contains(block.getType()) || disasterBlocks.containsKey(block) || Utils.passStrengthTest(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                            Tornado.this.addBlock(block, fixedMetadataValue, Tornado.this.pullForce, random);
                        }
                        ++n22;
                    }
                    --n;
                }
                for (Entity entity : Tornado.this.world.getNearbyEntities(Tornado.this.loc.clone().add(0.0, Tornado.this.size - 5.0, 0.0), Tornado.this.size, Tornado.this.size, Tornado.this.size)) {
                    if (!(keySetView.size() > Tornado.this.max_blocks && !(entity instanceof LivingEntity) || Tornado.this.cooldownEntities.containsKey(entity.getUniqueId()) || entity instanceof Player && ((Player)entity).isFlying())) {
                        keySetView.add(entity.getUniqueId());
                        Tornado.this.holdEntities.putIfAbsent(entity.getUniqueId(), n2);
                        Tornado.this.velocityMap.putIfAbsent(entity.getUniqueId(), random.nextDouble() / 2.0);
                    }
                    if (!(entity instanceof Player)) continue;
                    block = entity.getLocation();
                    ((Player)entity).playSound(block.clone().add(new Vector(block.getX() - Tornado.this.loc.getX(), -3.0, block.getZ() - Tornado.this.loc.getZ()).normalize().multiply(-3)), Sound.WEATHER_RAIN_ABOVE, (float)((2.0 - 0.02 * Tornado.this.loc.distance(block.subtract(0.0, block.getY() - Tornado.this.loc.getY(), 0.0))) * Tornado.this.volume), 0.5f);
                }
                Tornado.this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)Tornado.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Iterator<Map.Entry<UUID, Double>> iterator = (this).Tornado.this.velocityMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            if (keySetView.contains(iterator.next().getKey())) continue;
                            iterator.remove();
                        }
                    }
                });
            }
        };
    }

    private UUID addBlock(Block block, FixedMetadataValue fixedMetadataValue, double d, Random random) {
        BlockData blockData = null;
        blockData = this.materials == null ? block.getBlockData() : this.materials[random.nextInt(this.materials.length)];
        FallingBlock fallingBlock = this.world.spawnFallingBlock(block.getLocation().clone().add(0.5, 0.5, 0.5), blockData);
        BlockState blockState = block.getState();
        if (blockState instanceof InventoryHolder) {
            CoreListener.addBlockInventory((Entity)fallingBlock, ((InventoryHolder)block.getState()).getInventory().getContents());
        }
        this.addBlockToList(block, blockState);
        block.setType(Material.AIR);
        fallingBlock.setVelocity(new Vector(fallingBlock.getLocation().getX() - this.loc.getX(), -0.5, fallingBlock.getLocation().getZ() - this.loc.getZ()).normalize().multiply(d));
        fallingBlock.setDropItem(false);
        fallingBlock.setHurtEntities(true);
        fallingBlock.setMetadata("dd-fb", (MetadataValue)fixedMetadataValue);
        this.UUIDToFalling.put(fallingBlock.getUniqueId(), block);
        if (this.CP) {
            Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
        }
        ++this.blocksDestroyed;
        this.velocityMap.put(fallingBlock.getUniqueId(), random.nextDouble() / 2.0);
        return fallingBlock.getUniqueId();
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = Utils.getBlockBelow(location).getLocation()).getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(Utils.getBlockBelow(location).getLocation(), player);
    }

    public boolean isEntityInvolved(UUID uUID) {
        return this.cooldownEntities.containsKey(uUID) || this.holdEntities.containsKey(uUID);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public int getMaxBlocks() {
        return this.max_blocks;
    }

    public void setMaxBlocks(int n) {
        this.max_blocks = n;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public double getPullForce() {
        return this.pullForce;
    }

    public void setPullForce(double d) {
        this.pullForce = d;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public Particle getParticleType() {
        return this.particleType;
    }

    public void setParticleType(Particle particle) {
        this.particleType = particle;
    }

    public BlockData[] getMaterials() {
        return this.materials;
    }

    public void setMaterials(Material[] materialArray) {
        this.materials = new BlockData[materialArray.length];
        int n = 0;
        while (n < materialArray.length) {
            this.materials[n] = materialArray[n].createBlockData();
            ++n;
        }
    }

    public double getParticles() {
        return this.particles;
    }

    public void setParticles(double d) {
        this.particles = d;
    }

    public double getyVelocity() {
        return this.yVelocity;
    }

    public void setyVelocity(double d) {
        this.yVelocity = d;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

