/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import deadlydisasters.Main;
import deadlydisasters.commands.Disasters;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.disasters.CustomDisaster;
import deadlydisasters.events.disasters.ExtremeWinds;
import deadlydisasters.events.disasters.Hurricane;
import deadlydisasters.events.disasters.Sinkhole;
import deadlydisasters.events.disasters.Tornado;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.listeners.TownyListener;
import deadlydisasters.listeners.spawners.GlobalSpawner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import me.angeschossen.lands.api.integration.LandsIntegration;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.kingdoms.constants.land.Land;

public class Utils {
    private static Map<Material, Double> matStrength = new HashMap<Material, Double>();
    private static Main plugin;
    private static Random rand;
    public static boolean WGuardB;
    public static boolean TownyB;
    public static boolean GriefB;
    public static boolean LandsB;
    public static boolean KingsB;
    private static CoreProtectAPI coreProtect;
    private static TownyAPI townyapi;
    private static DataStore grief;
    private static LandsIntegration landsclaims;
    private static Sound startSound;
    private static float[] startSoundModifiers;
    private static int descriptionLine;
    private static Set<Material> gravityBlocks;
    private static DecimalFormat decimalFormat;

    static {
        descriptionLine = 35;
        gravityBlocks = new HashSet<Material>(Arrays.asList(Material.GRAVEL, Material.SAND, Material.RED_SAND, Material.DRAGON_EGG, Material.BLACK_CONCRETE_POWDER, Material.BLUE_CONCRETE_POWDER, Material.BROWN_CONCRETE_POWDER, Material.CYAN_CONCRETE_POWDER, Material.GRAY_CONCRETE_POWDER, Material.GREEN_CONCRETE_POWDER, Material.LIGHT_BLUE_CONCRETE_POWDER, Material.LIGHT_GRAY_CONCRETE_POWDER, Material.LIME_CONCRETE_POWDER, Material.MAGENTA_CONCRETE_POWDER, Material.ORANGE_CONCRETE_POWDER, Material.PINK_CONCRETE_POWDER, Material.PURPLE_CONCRETE_POWDER, Material.RED_CONCRETE_POWDER, Material.WHITE_CONCRETE_POWDER, Material.YELLOW_CONCRETE_POWDER));
        decimalFormat = new DecimalFormat("0.0");
    }

    public Utils(final Main main) {
        plugin = main;
        rand = main.random;
        Utils.reloadVariables();
        main.getServer().getScheduler().runTaskLater((Plugin)main, new Runnable(){

            @Override
            public void run() {
                if (main.CProtect) {
                    coreProtect = ((CoreProtect)main.getServer().getPluginManager().getPlugin("CoreProtect")).getAPI();
                }
                if (TownyB) {
                    townyapi = TownyAPI.getInstance();
                    TownyListener.registerTowns();
                }
                if (GriefB) {
                    grief = GriefPrevention.instance.dataStore;
                }
                if (LandsB) {
                    landsclaims = new LandsIntegration((Plugin)main);
                }
            }
        }, 1L);
        Sinkhole.treeBlocks.addAll(Tag.LEAVES.getValues());
        Sinkhole.treeBlocks.addAll(Tag.LOGS.getValues());
        Tornado.bannedBlocks.addAll(Arrays.asList(Material.SNOW, Material.LADDER, Material.VINE, Material.TORCH, Material.WALL_TORCH, Material.REDSTONE_TORCH, Material.REDSTONE_WALL_TORCH));
        if (main.mcVersion >= 1.14) {
            Tornado.bannedBlocks.addAll(Tag.SIGNS.getValues());
        }
        Tornado.bannedBlocks.addAll(Tag.CARPETS.getValues());
        Tornado.bannedBlocks.addAll(Tag.BUTTONS.getValues());
        if (main.mcVersion >= 1.16) {
            Tornado.bannedBlocks.addAll(Tag.FIRE.getValues());
        }
        if (main.mcVersion >= 1.16) {
            Tornado.bannedBlocks.addAll(Arrays.asList(Material.SOUL_TORCH, Material.SOUL_WALL_TORCH));
        }
        ExtremeWinds.bannedBlocks.addAll(Tornado.bannedBlocks);
        ExtremeWinds.bannedBlocks.addAll(Tag.LEAVES.getValues());
        Hurricane.oceans.addAll(Arrays.asList(Biome.OCEAN, Biome.COLD_OCEAN, Biome.DEEP_COLD_OCEAN, Biome.DEEP_FROZEN_OCEAN, Biome.DEEP_LUKEWARM_OCEAN, Biome.DEEP_OCEAN, Biome.FROZEN_OCEAN, Biome.LUKEWARM_OCEAN, Biome.WARM_OCEAN));
        gravityBlocks.addAll(Tag.ANVIL.getValues());
    }

    public static String chat(String string) {
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void broadcastEvent(int n, String string, Disaster disaster, World world) {
        if (n > 5) {
            n = 5;
        }
        String string2 = plugin.getConfig().getString("messages." + string + ".level " + n);
        string2 = string2.replace("%world%", world.getName());
        string2 = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string2);
        string2 = string2.replace("%disaster%", disaster.getLabel());
        if (plugin.getConfig().getBoolean("messages.disaster_tips")) {
            string2 = String.valueOf(string2) + "\n" + disaster.getTip();
        }
        for (Player player : world.getPlayers()) {
            player.sendMessage(string2);
        }
        if (startSound != null) {
            for (Player player : world.getPlayers()) {
                player.playSound(player.getLocation(), startSound, startSoundModifiers[0], startSoundModifiers[1]);
            }
        }
        Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string2);
    }

    public static void broadcastEvent(int n, String string, Disaster disaster, Location location, Player player) {
        String string2 = plugin.getConfig().getString("messages." + string + ".level " + n);
        string2 = string2.replace("%location%", String.valueOf(location.getBlockX()) + " " + location.getBlockY() + " " + location.getBlockZ());
        string2 = player != null ? string2.replace("%player%", player.getName()) : string2.replace("%player%", "");
        string2 = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string2);
        string2 = string2.replace("%disaster%", disaster.getLabel());
        if (plugin.getConfig().getBoolean("messages.disaster_tips")) {
            string2 = String.valueOf(string2) + "\n" + disaster.getTip();
        }
        for (Player player2 : location.getWorld().getPlayers()) {
            player2.sendMessage(string2);
        }
        if (startSound != null) {
            for (Player player2 : location.getWorld().getPlayers()) {
                player2.playSound(player2.getLocation(), startSound, startSoundModifiers[0], startSoundModifiers[1]);
            }
        }
        Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string2 + org.bukkit.ChatColor.GREEN + " (" + location.getWorld().getName() + ")");
    }

    public static boolean isWGRegion(Location location) {
        com.sk89q.worldedit.util.Location location2 = BukkitAdapter.adapt((Location)location);
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery regionQuery = regionContainer.createQuery();
        ApplicableRegionSet applicableRegionSet = regionQuery.getApplicableRegions(location2);
        return applicableRegionSet.size() != 0;
    }

    public static boolean passStrengthTest(Material material) {
        return matStrength.containsKey(material) && rand.nextDouble() + 1.0E-4 < matStrength.get(material);
    }

    public static boolean isBlockImmune(Material material) {
        return matStrength.containsKey(material) && matStrength.get(material) >= 1.0;
    }

    public static CoreProtectAPI getCoreProtect() {
        return coreProtect;
    }

    public static TownyAPI getTownyAPI() {
        return townyapi;
    }

    public static DataStore getGriefPrevention() {
        return grief;
    }

    public static LandsIntegration getLandsClaims() {
        return landsclaims;
    }

    public static void reloadVariables() {
        Utils.refreshBlockStrengths();
        if (!plugin.getConfig().getString("messages.start_sound.sound").equalsIgnoreCase("none")) {
            try {
                startSound = Sound.valueOf((String)plugin.getConfig().getString("messages.start_sound.sound").toUpperCase());
            }
            catch (Exception exception) {
                Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: There is no sound with the name &d'" + plugin.getConfig().getString("messages.start_sound.sound") + "' &ein the config at:\nmessages:\n    start_sound:\n        sound: " + plugin.getConfig().getString("messages.start_sound.sound")));
            }
            try {
                startSoundModifiers = new float[]{(float)plugin.getConfig().getDouble("messages.start_sound.volume"), (float)plugin.getConfig().getDouble("messages.start_sound.pitch")};
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        descriptionLine = plugin.getConfig().getInt("customitems.item_lore_characters_per_line");
    }

    public static void refreshBlockStrengths() {
        File file = new File(plugin.getDataFolder().getAbsolutePath(), "blocks.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
                FileUtils.copyInputStreamToFile(plugin.getResource("files/blocks.yml"), file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        HashSet<String> hashSet = new HashSet<String>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = materialArray[n2];
            hashSet.add(object.name());
            ++n2;
        }
        matStrength.clear();
        for (Object object : yamlConfiguration.getKeys(false)) {
            if (hashSet.contains(((String)object).toUpperCase())) {
                matStrength.put(Material.valueOf((String)((String)object).toUpperCase()), yamlConfiguration.getDouble((String)object));
                continue;
            }
            if (((String)object).equals("wools")) {
                for (Material material : Tag.WOOL.getValues()) {
                    matStrength.put(material, yamlConfiguration.getDouble((String)object));
                }
                continue;
            }
            if (((String)object).equals("terracottas") && Utils.plugin.mcVersion >= 1.18) {
                for (Material material : Tag.TERRACOTTA.getValues()) {
                    matStrength.put(material, yamlConfiguration.getDouble((String)object));
                }
                continue;
            }
            plugin.getLogger().info("Unreconized: " + (String)object);
        }
        if (matStrength.containsKey(Material.OAK_PLANKS)) {
            if (!matStrength.containsKey(Material.OAK_STAIRS)) {
                matStrength.put(Material.OAK_STAIRS, matStrength.get(Material.OAK_PLANKS));
            }
            if (!matStrength.containsKey(Material.OAK_SLAB)) {
                matStrength.put(Material.OAK_SLAB, matStrength.get(Material.OAK_PLANKS));
            }
            if (!matStrength.containsKey(Material.OAK_FENCE)) {
                matStrength.put(Material.OAK_FENCE, matStrength.get(Material.OAK_PLANKS));
            }
        }
        if (matStrength.containsKey(Material.BIRCH_PLANKS)) {
            if (!matStrength.containsKey(Material.BIRCH_STAIRS)) {
                matStrength.put(Material.BIRCH_STAIRS, matStrength.get(Material.BIRCH_PLANKS));
            }
            if (!matStrength.containsKey(Material.BIRCH_SLAB)) {
                matStrength.put(Material.BIRCH_SLAB, matStrength.get(Material.BIRCH_PLANKS));
            }
            if (!matStrength.containsKey(Material.BIRCH_FENCE)) {
                matStrength.put(Material.BIRCH_FENCE, matStrength.get(Material.BIRCH_PLANKS));
            }
        }
        if (matStrength.containsKey(Material.SPRUCE_PLANKS)) {
            if (!matStrength.containsKey(Material.SPRUCE_STAIRS)) {
                matStrength.put(Material.SPRUCE_STAIRS, matStrength.get(Material.SPRUCE_PLANKS));
            }
            if (!matStrength.containsKey(Material.SPRUCE_SLAB)) {
                matStrength.put(Material.SPRUCE_SLAB, matStrength.get(Material.SPRUCE_PLANKS));
            }
            if (!matStrength.containsKey(Material.SPRUCE_FENCE)) {
                matStrength.put(Material.SPRUCE_FENCE, matStrength.get(Material.SPRUCE_PLANKS));
            }
        }
        if (matStrength.containsKey(Material.JUNGLE_PLANKS)) {
            if (!matStrength.containsKey(Material.JUNGLE_STAIRS)) {
                matStrength.put(Material.JUNGLE_STAIRS, matStrength.get(Material.JUNGLE_PLANKS));
            }
            if (!matStrength.containsKey(Material.JUNGLE_SLAB)) {
                matStrength.put(Material.JUNGLE_SLAB, matStrength.get(Material.JUNGLE_PLANKS));
            }
            if (!matStrength.containsKey(Material.JUNGLE_FENCE)) {
                matStrength.put(Material.JUNGLE_FENCE, matStrength.get(Material.JUNGLE_PLANKS));
            }
        }
        if (matStrength.containsKey(Material.ACACIA_PLANKS)) {
            if (!matStrength.containsKey(Material.ACACIA_STAIRS)) {
                matStrength.put(Material.ACACIA_STAIRS, matStrength.get(Material.ACACIA_PLANKS));
            }
            if (!matStrength.containsKey(Material.ACACIA_SLAB)) {
                matStrength.put(Material.ACACIA_SLAB, matStrength.get(Material.ACACIA_PLANKS));
            }
            if (!matStrength.containsKey(Material.ACACIA_FENCE)) {
                matStrength.put(Material.ACACIA_FENCE, matStrength.get(Material.ACACIA_PLANKS));
            }
        }
        if (matStrength.containsKey(Material.DARK_OAK_PLANKS)) {
            if (!matStrength.containsKey(Material.DARK_OAK_STAIRS)) {
                matStrength.put(Material.DARK_OAK_STAIRS, matStrength.get(Material.DARK_OAK_PLANKS));
            }
            if (!matStrength.containsKey(Material.DARK_OAK_SLAB)) {
                matStrength.put(Material.DARK_OAK_SLAB, matStrength.get(Material.DARK_OAK_PLANKS));
            }
            if (!matStrength.containsKey(Material.DARK_OAK_FENCE)) {
                matStrength.put(Material.DARK_OAK_FENCE, matStrength.get(Material.DARK_OAK_PLANKS));
            }
        }
        if (matStrength.containsKey(Material.COBBLESTONE)) {
            if (!matStrength.containsKey(Material.COBBLESTONE_STAIRS)) {
                matStrength.put(Material.COBBLESTONE_STAIRS, matStrength.get(Material.COBBLESTONE));
            }
            if (!matStrength.containsKey(Material.COBBLESTONE_SLAB)) {
                matStrength.put(Material.COBBLESTONE_SLAB, matStrength.get(Material.COBBLESTONE));
            }
            if (!matStrength.containsKey(Material.COBBLESTONE_WALL)) {
                matStrength.put(Material.COBBLESTONE_WALL, matStrength.get(Material.COBBLESTONE));
            }
        }
        if (matStrength.containsKey(Material.STONE_BRICKS)) {
            if (!matStrength.containsKey(Material.STONE_BRICK_STAIRS)) {
                matStrength.put(Material.STONE_BRICK_STAIRS, matStrength.get(Material.STONE_BRICKS));
            }
            if (!matStrength.containsKey(Material.STONE_BRICK_SLAB)) {
                matStrength.put(Material.STONE_BRICK_SLAB, matStrength.get(Material.STONE_BRICKS));
            }
            if (!matStrength.containsKey(Material.STONE_BRICK_WALL)) {
                matStrength.put(Material.STONE_BRICK_WALL, matStrength.get(Material.STONE_BRICKS));
            }
        }
        if (matStrength.containsKey(Material.STONE)) {
            if (!matStrength.containsKey(Material.STONE_STAIRS)) {
                matStrength.put(Material.STONE_STAIRS, matStrength.get(Material.STONE));
            }
            if (!matStrength.containsKey(Material.STONE_SLAB)) {
                matStrength.put(Material.STONE_SLAB, matStrength.get(Material.STONE));
            }
        }
        if (matStrength.containsKey(Material.BRICK)) {
            if (!matStrength.containsKey(Material.BRICK_STAIRS)) {
                matStrength.put(Material.BRICK_STAIRS, matStrength.get(Material.BRICK));
            }
            if (!matStrength.containsKey(Material.BRICK_SLAB)) {
                matStrength.put(Material.BRICK_SLAB, matStrength.get(Material.BRICK));
            }
            if (!matStrength.containsKey(Material.BRICK_WALL)) {
                matStrength.put(Material.BRICK_WALL, matStrength.get(Material.BRICK));
            }
        }
        if (matStrength.containsKey(Material.SMOOTH_STONE) && !matStrength.containsKey(Material.SMOOTH_STONE_SLAB)) {
            matStrength.put(Material.SMOOTH_STONE_SLAB, matStrength.get(Material.SMOOTH_STONE));
        }
        if (matStrength.containsKey(Material.SANDSTONE)) {
            if (!matStrength.containsKey(Material.SANDSTONE_STAIRS)) {
                matStrength.put(Material.SANDSTONE_STAIRS, matStrength.get(Material.SANDSTONE));
            }
            if (!matStrength.containsKey(Material.SANDSTONE_SLAB)) {
                matStrength.put(Material.SANDSTONE_SLAB, matStrength.get(Material.SANDSTONE));
            }
            if (!matStrength.containsKey(Material.SANDSTONE_WALL)) {
                matStrength.put(Material.SANDSTONE_WALL, matStrength.get(Material.SANDSTONE));
            }
        }
        if (matStrength.containsKey(Material.CUT_SANDSTONE) && !matStrength.containsKey(Material.CUT_SANDSTONE_SLAB)) {
            matStrength.put(Material.CUT_SANDSTONE_SLAB, matStrength.get(Material.CUT_SANDSTONE));
        }
        if (matStrength.containsKey(Material.SMOOTH_SANDSTONE)) {
            if (!matStrength.containsKey(Material.SMOOTH_SANDSTONE_STAIRS)) {
                matStrength.put(Material.SMOOTH_SANDSTONE_STAIRS, matStrength.get(Material.SMOOTH_SANDSTONE));
            }
            if (!matStrength.containsKey(Material.SMOOTH_SANDSTONE_SLAB)) {
                matStrength.put(Material.SMOOTH_SANDSTONE_SLAB, matStrength.get(Material.SMOOTH_SANDSTONE));
            }
        }
        if (matStrength.containsKey(Material.RED_SANDSTONE)) {
            if (!matStrength.containsKey(Material.RED_SANDSTONE_STAIRS)) {
                matStrength.put(Material.RED_SANDSTONE_STAIRS, matStrength.get(Material.RED_SANDSTONE));
            }
            if (!matStrength.containsKey(Material.RED_SANDSTONE_SLAB)) {
                matStrength.put(Material.RED_SANDSTONE_SLAB, matStrength.get(Material.RED_SANDSTONE));
            }
            if (!matStrength.containsKey(Material.RED_SANDSTONE_WALL)) {
                matStrength.put(Material.RED_SANDSTONE_WALL, matStrength.get(Material.RED_SANDSTONE));
            }
        }
        if (matStrength.containsKey(Material.CUT_RED_SANDSTONE) && !matStrength.containsKey(Material.CUT_RED_SANDSTONE_SLAB)) {
            matStrength.put(Material.CUT_RED_SANDSTONE_SLAB, matStrength.get(Material.CUT_RED_SANDSTONE));
        }
        if (matStrength.containsKey(Material.SMOOTH_RED_SANDSTONE)) {
            if (!matStrength.containsKey(Material.SMOOTH_RED_SANDSTONE_STAIRS)) {
                matStrength.put(Material.SMOOTH_RED_SANDSTONE_STAIRS, matStrength.get(Material.SMOOTH_RED_SANDSTONE));
            }
            if (!matStrength.containsKey(Material.SMOOTH_RED_SANDSTONE_SLAB)) {
                matStrength.put(Material.SMOOTH_RED_SANDSTONE_SLAB, matStrength.get(Material.SMOOTH_RED_SANDSTONE));
            }
        }
        if (matStrength.containsKey(Material.NETHER_BRICK)) {
            if (!matStrength.containsKey(Material.NETHER_BRICK_STAIRS)) {
                matStrength.put(Material.NETHER_BRICK_STAIRS, matStrength.get(Material.NETHER_BRICK));
            }
            if (!matStrength.containsKey(Material.NETHER_BRICK_SLAB)) {
                matStrength.put(Material.NETHER_BRICK_SLAB, matStrength.get(Material.NETHER_BRICK));
            }
            if (!matStrength.containsKey(Material.NETHER_BRICK_FENCE)) {
                matStrength.put(Material.NETHER_BRICK_FENCE, matStrength.get(Material.NETHER_BRICK));
            }
            if (!matStrength.containsKey(Material.NETHER_BRICK_WALL)) {
                matStrength.put(Material.NETHER_BRICK_WALL, matStrength.get(Material.NETHER_BRICK));
            }
        }
        if (matStrength.containsKey(Material.RED_NETHER_BRICKS)) {
            if (!matStrength.containsKey(Material.RED_NETHER_BRICK_STAIRS)) {
                matStrength.put(Material.RED_NETHER_BRICK_STAIRS, matStrength.get(Material.RED_NETHER_BRICKS));
            }
            if (!matStrength.containsKey(Material.RED_NETHER_BRICK_SLAB)) {
                matStrength.put(Material.RED_NETHER_BRICK_SLAB, matStrength.get(Material.RED_NETHER_BRICKS));
            }
            if (!matStrength.containsKey(Material.RED_NETHER_BRICK_WALL)) {
                matStrength.put(Material.RED_NETHER_BRICK_WALL, matStrength.get(Material.RED_NETHER_BRICKS));
            }
        }
        if (matStrength.containsKey(Material.QUARTZ_BLOCK)) {
            if (!matStrength.containsKey(Material.QUARTZ_STAIRS)) {
                matStrength.put(Material.QUARTZ_STAIRS, matStrength.get(Material.QUARTZ_BLOCK));
            }
            if (!matStrength.containsKey(Material.QUARTZ_SLAB)) {
                matStrength.put(Material.QUARTZ_SLAB, matStrength.get(Material.QUARTZ_BLOCK));
            }
        }
        if (matStrength.containsKey(Material.PURPUR_BLOCK)) {
            if (!matStrength.containsKey(Material.PURPUR_STAIRS)) {
                matStrength.put(Material.PURPUR_STAIRS, matStrength.get(Material.PURPUR_BLOCK));
            }
            if (!matStrength.containsKey(Material.PURPUR_SLAB)) {
                matStrength.put(Material.PURPUR_SLAB, matStrength.get(Material.PURPUR_BLOCK));
            }
        }
        if (matStrength.containsKey(Material.PRISMARINE)) {
            if (!matStrength.containsKey(Material.PRISMARINE_STAIRS)) {
                matStrength.put(Material.PRISMARINE_STAIRS, matStrength.get(Material.PRISMARINE));
            }
            if (!matStrength.containsKey(Material.PRISMARINE_SLAB)) {
                matStrength.put(Material.PRISMARINE_SLAB, matStrength.get(Material.PRISMARINE));
            }
            if (!matStrength.containsKey(Material.PRISMARINE_WALL)) {
                matStrength.put(Material.PRISMARINE_WALL, matStrength.get(Material.PRISMARINE));
            }
        }
        if (matStrength.containsKey(Material.PRISMARINE_BRICKS)) {
            if (!matStrength.containsKey(Material.PRISMARINE_BRICK_STAIRS)) {
                matStrength.put(Material.PRISMARINE_BRICK_STAIRS, matStrength.get(Material.PRISMARINE_BRICKS));
            }
            if (!matStrength.containsKey(Material.PRISMARINE_BRICK_SLAB)) {
                matStrength.put(Material.PRISMARINE_BRICK_SLAB, matStrength.get(Material.PRISMARINE_BRICKS));
            }
        }
        if (matStrength.containsKey(Material.DARK_PRISMARINE)) {
            if (!matStrength.containsKey(Material.DARK_PRISMARINE_STAIRS)) {
                matStrength.put(Material.DARK_PRISMARINE_STAIRS, matStrength.get(Material.DARK_PRISMARINE));
            }
            if (!matStrength.containsKey(Material.DARK_PRISMARINE_SLAB)) {
                matStrength.put(Material.DARK_PRISMARINE_SLAB, matStrength.get(Material.DARK_PRISMARINE));
            }
        }
        if (matStrength.containsKey(Material.END_STONE_BRICKS)) {
            if (!matStrength.containsKey(Material.END_STONE_BRICK_STAIRS)) {
                matStrength.put(Material.END_STONE_BRICK_STAIRS, matStrength.get(Material.END_STONE_BRICKS));
            }
            if (!matStrength.containsKey(Material.END_STONE_BRICK_SLAB)) {
                matStrength.put(Material.END_STONE_BRICK_SLAB, matStrength.get(Material.END_STONE_BRICKS));
            }
        }
        if (Utils.plugin.mcVersion >= 1.16) {
            if (matStrength.containsKey(Material.CRIMSON_PLANKS)) {
                if (!matStrength.containsKey(Material.CRIMSON_STAIRS)) {
                    matStrength.put(Material.CRIMSON_STAIRS, matStrength.get(Material.CRIMSON_PLANKS));
                }
                if (!matStrength.containsKey(Material.CRIMSON_SLAB)) {
                    matStrength.put(Material.CRIMSON_SLAB, matStrength.get(Material.CRIMSON_PLANKS));
                }
            }
            if (matStrength.containsKey(Material.WARPED_PLANKS)) {
                if (!matStrength.containsKey(Material.WARPED_STAIRS)) {
                    matStrength.put(Material.WARPED_STAIRS, matStrength.get(Material.WARPED_PLANKS));
                }
                if (!matStrength.containsKey(Material.WARPED_SLAB)) {
                    matStrength.put(Material.WARPED_SLAB, matStrength.get(Material.WARPED_PLANKS));
                }
            }
            if (matStrength.containsKey(Material.BLACKSTONE)) {
                if (!matStrength.containsKey(Material.BLACKSTONE_STAIRS)) {
                    matStrength.put(Material.BLACKSTONE_STAIRS, matStrength.get(Material.BLACKSTONE));
                }
                if (!matStrength.containsKey(Material.BLACKSTONE_SLAB)) {
                    matStrength.put(Material.BLACKSTONE_SLAB, matStrength.get(Material.BLACKSTONE));
                }
                if (!matStrength.containsKey(Material.BLACKSTONE_WALL)) {
                    matStrength.put(Material.BLACKSTONE_WALL, matStrength.get(Material.BLACKSTONE));
                }
            }
            if (matStrength.containsKey(Material.POLISHED_BLACKSTONE)) {
                if (!matStrength.containsKey(Material.POLISHED_BLACKSTONE_STAIRS)) {
                    matStrength.put(Material.POLISHED_BLACKSTONE_STAIRS, matStrength.get(Material.POLISHED_BLACKSTONE));
                }
                if (!matStrength.containsKey(Material.POLISHED_BLACKSTONE_SLAB)) {
                    matStrength.put(Material.POLISHED_BLACKSTONE_SLAB, matStrength.get(Material.POLISHED_BLACKSTONE));
                }
                if (!matStrength.containsKey(Material.POLISHED_BLACKSTONE_WALL)) {
                    matStrength.put(Material.POLISHED_BLACKSTONE_WALL, matStrength.get(Material.POLISHED_BLACKSTONE));
                }
            }
            if (matStrength.containsKey(Material.POLISHED_BLACKSTONE_BRICKS)) {
                if (!matStrength.containsKey(Material.POLISHED_BLACKSTONE_BRICK_STAIRS)) {
                    matStrength.put(Material.POLISHED_BLACKSTONE_BRICK_STAIRS, matStrength.get(Material.POLISHED_BLACKSTONE_BRICKS));
                }
                if (!matStrength.containsKey(Material.POLISHED_BLACKSTONE_BRICK_SLAB)) {
                    matStrength.put(Material.POLISHED_BLACKSTONE_BRICK_SLAB, matStrength.get(Material.POLISHED_BLACKSTONE_BRICKS));
                }
                if (!matStrength.containsKey(Material.POLISHED_BLACKSTONE_BRICK_WALL)) {
                    matStrength.put(Material.POLISHED_BLACKSTONE_BRICK_WALL, matStrength.get(Material.POLISHED_BLACKSTONE_BRICKS));
                }
            }
            if (Utils.plugin.mcVersion >= 1.17) {
                if (matStrength.containsKey(Material.COBBLED_DEEPSLATE)) {
                    if (!matStrength.containsKey(Material.COBBLED_DEEPSLATE_STAIRS)) {
                        matStrength.put(Material.COBBLED_DEEPSLATE_STAIRS, matStrength.get(Material.COBBLED_DEEPSLATE));
                    }
                    if (!matStrength.containsKey(Material.COBBLED_DEEPSLATE_SLAB)) {
                        matStrength.put(Material.COBBLED_DEEPSLATE_SLAB, matStrength.get(Material.COBBLED_DEEPSLATE));
                    }
                    if (!matStrength.containsKey(Material.COBBLED_DEEPSLATE_WALL)) {
                        matStrength.put(Material.COBBLED_DEEPSLATE_WALL, matStrength.get(Material.COBBLED_DEEPSLATE));
                    }
                }
                if (Utils.plugin.mcVersion >= 1.19 && matStrength.containsKey(Material.MANGROVE_PLANKS)) {
                    if (!matStrength.containsKey(Material.MANGROVE_STAIRS)) {
                        matStrength.put(Material.MANGROVE_STAIRS, matStrength.get(Material.MANGROVE_PLANKS));
                    }
                    if (!matStrength.containsKey(Material.MANGROVE_SLAB)) {
                        matStrength.put(Material.MANGROVE_SLAB, matStrength.get(Material.MANGROVE_PLANKS));
                    }
                }
            }
        }
    }

    public static void xchatColor(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            by = (byte)(by + 3);
            ++n2;
        }
        plugin.getLogger().info(stringBuilder.toString());
        plugin.getLogger().info(Utils.zchatColor(stringBuilder.toString()));
    }

    public static String zchatColor(String string) {
        String[] stringArray = string.split(",");
        byte[] byArray = new byte[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            byArray[n] = (byte)(Byte.valueOf(stringArray[n]) - 3);
            ++n;
        }
        return new String(byArray);
    }

    public static boolean isPlayerImmune(Player player) {
        return player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR;
    }

    public static boolean isZoneProtected(Location location) {
        return WorldObject.findWorldObject((World)location.getWorld()).protectRegions && (WGuardB && Utils.isWGRegion(location) || TownyB && townyapi.getTownBlock(location) != null && townyapi.getTownBlock(location).getTownOrNull().getMetadata("DeadlyDisasters").getValue().equals(true) || GriefB && grief.getClaimAt(location, true, null) != null || LandsB && landsclaims.isClaimed(location) || KingsB && Land.getLand((Location)location) != null);
    }

    public static boolean isWeatherDisabled(Location location, WeatherDisaster weatherDisaster) {
        return weatherDisaster.RegionWeather && (WGuardB && Utils.isWGRegion(location) || TownyB && townyapi.getTownBlock(location) != null && townyapi.getTownBlock(location).getTownOrNull().getMetadata("DeadlyDisasters").getValue().equals(true) || GriefB && grief.getClaimAt(location, true, null) != null || LandsB && landsclaims.isClaimed(location) || KingsB && Land.getLand((Location)location) != null);
    }

    public static Block getBlockAbove(Location location) {
        Block block = location.getBlock();
        int n = location.getBlockY();
        while (n < 320) {
            if (block.getType().isSolid()) break;
            block = block.getRelative(BlockFace.UP);
            ++n;
        }
        return block;
    }

    public static Block getBlockBelow(Location location) {
        Block block = location.getBlock();
        int n = location.getBlockY();
        while (n > Utils.plugin.maxDepth) {
            if (block.getType().isSolid()) break;
            block = block.getRelative(BlockFace.DOWN);
            --n;
        }
        return block;
    }

    public static Block getBlockAbove(Location location, int n) {
        Block block = location.getBlock();
        int n2 = 0;
        while (n2 < n) {
            if (!block.isPassable()) break;
            block = block.getRelative(BlockFace.UP);
            ++n2;
        }
        if (block.isPassable()) {
            return null;
        }
        return block;
    }

    public static Block getBlockBelow(Location location, int n) {
        Block block = location.getBlock();
        int n2 = 0;
        while (n2 > n) {
            if (!block.isPassable()) break;
            block = block.getRelative(BlockFace.DOWN);
            --n2;
        }
        if (block.isPassable()) {
            return null;
        }
        return block;
    }

    public static Block getHighestExposedBlock(Location location, int n) {
        if (location == null) {
            return null;
        }
        Block block = location.getBlock();
        if (block.isPassable()) {
            int n2 = 0;
            while (n2 < n) {
                if (!(block = block.getRelative(BlockFace.DOWN)).isPassable()) {
                    return block;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if ((block = block.getRelative(BlockFace.UP)).isPassable()) {
                    return block.getRelative(BlockFace.DOWN);
                }
                ++n3;
            }
        }
        return null;
    }

    public static Location findApplicableSpawn(Location location) {
        if (location == null) {
            return null;
        }
        Block block = location.getBlock();
        if (block.isPassable()) {
            int n = location.getBlockY();
            while (n > Utils.plugin.maxDepth) {
                if (!(block = block.getRelative(BlockFace.DOWN)).isPassable() && block.getRelative(BlockFace.UP).isPassable() && block.getRelative(BlockFace.UP, 2).isPassable()) {
                    return block.getRelative(BlockFace.UP).getLocation();
                }
                --n;
            }
        } else {
            int n = location.getBlockY();
            while (n < 320) {
                if ((block = block.getRelative(BlockFace.UP)).isPassable() && block.getRelative(BlockFace.UP).isPassable() && !block.getRelative(BlockFace.DOWN).isPassable()) {
                    return block.getLocation();
                }
                ++n;
            }
        }
        return location;
    }

    public static Location findSmartYSpawn(Location location, Location location2, int n, int n2) {
        int n3;
        if (location == null || location2 == null) {
            return null;
        }
        Block block = location2.getBlock();
        Location location3 = null;
        Location location4 = null;
        int n4 = location2.getBlockY();
        while (n4 > location2.getBlockY() - n2) {
            block13: {
                if (!(block = block.getRelative(BlockFace.DOWN)).isPassable() && block.getRelative(BlockFace.UP).isPassable() && !block.getRelative(BlockFace.UP).isLiquid()) {
                    n3 = 2;
                    while (n3 <= n - 1) {
                        if (block.getRelative(BlockFace.UP, n3).isPassable()) {
                            ++n3;
                            continue;
                        }
                        break block13;
                    }
                    location3 = block.getRelative(BlockFace.UP).getLocation().add(0.5, 0.01, 0.5);
                    break;
                }
            }
            --n4;
        }
        block = location2.getBlock();
        n4 = location2.getBlockY();
        while (n4 < location2.getBlockY() + n2) {
            block14: {
                if ((block = block.getRelative(BlockFace.UP)).isPassable() && !block.getRelative(BlockFace.DOWN).isPassable() && !block.isLiquid()) {
                    n3 = 1;
                    while (n3 < n) {
                        if (block.getRelative(BlockFace.UP, n3).isPassable()) {
                            ++n3;
                            continue;
                        }
                        break block14;
                    }
                    location4 = block.getLocation().add(0.5, 0.01, 0.5);
                    break;
                }
            }
            ++n4;
        }
        if (location3 != null && location4 == null) {
            return location3;
        }
        if (location3 == null && location4 != null) {
            return location4;
        }
        if (location3 == null && location4 == null) {
            return null;
        }
        if (Math.abs(location.getY() - location4.getY()) < Math.abs(location.getY() - location3.getY())) {
            return location3;
        }
        return location4;
    }

    public static int levelOfEnchant(String string, ItemStack itemStack) {
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasLore()) {
            return 0;
        }
        for (String string2 : itemStack.getItemMeta().getLore()) {
            if (!string2.contains(string)) continue;
            int n = string2.length() - 1;
            while (n >= 0) {
                if (string2.charAt(n) == ' ') {
                    return Utils.getFromNumerical(string2.substring(n + 1));
                }
                --n;
            }
        }
        return 0;
    }

    public static boolean rayTraceForSolidBlock(Location location, Location location2) {
        Vector vector = new Vector(location2.getX() - location.getX(), location2.getY() - location.getY(), location2.getZ() - location.getZ()).normalize();
        double d = Math.ceil(location.distance(location2));
        int n = 0;
        while ((double)n < d) {
            if (!location.clone().add(vector.clone().multiply(n)).getBlock().isPassable()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Location getSpotInSquareRadius(Location location, int n) {
        Location location2 = location.clone();
        int n2 = rand.nextInt(4);
        if (n2 == 0) {
            location2.add((double)n, 0.0, (double)(rand.nextInt(n) - n / 2));
        } else if (n2 == 1) {
            location2.add((double)(-n), 0.0, (double)(rand.nextInt(n) - n / 2));
        } else if (n2 == 2) {
            location2.add((double)(rand.nextInt(n) - n / 2), 0.0, (double)n);
        } else if (n2 == 3) {
            location2.add((double)(rand.nextInt(n) - n / 2), 0.0, (double)(-n));
        }
        return location2;
    }

    public static Vector getVectorTowards(Location location, Location location2) {
        return new Vector(location2.getX() - location.getX(), location2.getY() - location.getY(), location2.getZ() - location.getZ()).normalize();
    }

    public static void copyUrlToFile(URL uRL, File file) {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:10.0.2) Gecko/20100101 Firefox/10.0.2");
        httpsURLConnection.connect();
        FileUtils.copyInputStreamToFile(httpsURLConnection.getInputStream(), file);
    }

    public static int[] removeElement(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length - 1];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n2];
            ++n2;
        }
        n2 = n;
        while (n2 < nArray2.length) {
            nArray2[n2] = nArray[n2 + 1];
            ++n2;
        }
        return nArray2;
    }

    public static char getLevelChar(int n) {
        int n2 = 97;
        if (n == 2) {
            n2 = 50;
        } else if (n == 3) {
            n2 = 98;
        } else if (n == 4) {
            n2 = 101;
        } else if (n == 5) {
            n2 = 99;
        } else if (n == 6) {
            n2 = 52;
        }
        return (char)n2;
    }

    public static void makeEntityFaceLocation(Entity entity, Location location) {
        Vector vector = location.toVector().subtract(entity.getLocation().toVector());
        entity.teleport(entity.getLocation().setDirection(vector));
    }

    public static void clearEntityOfItems(LivingEntity livingEntity) {
        ItemStack[] itemStackArray = livingEntity.getEquipment().getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemStack = itemStackArray[n2];
            itemStack.setType(Material.AIR);
            ++n2;
        }
        livingEntity.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        livingEntity.getEquipment().setItemInOffHand(new ItemStack(Material.AIR));
        if (livingEntity.isInsideVehicle()) {
            livingEntity.getVehicle().remove();
        }
    }

    public static String spigotText(String string, String string2) {
        return ChatColor.of((String)string2) + string;
    }

    /*
     * Unable to fully structure code
     */
    public static String translateTextColor(String var0) {
        if (var0 == null) {
            return null;
        }
        var1_1 = var0;
        if (var1_1.contains("(hex:")) ** GOTO lbl8
        return Utils.chat(var1_1);
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.substring(var1_1.indexOf("(hex:") + 5);
            var1_1 = String.valueOf(var1_1.substring(0, var1_1.indexOf("(hex:"))) + ChatColor.of((String)var2_2.substring(0, var2_2.indexOf(")"))) + var2_2.substring(var2_2.indexOf(")") + 1);
lbl8:
            // 2 sources

            ** while (var1_1.contains((CharSequence)"(hex:"))
        }
lbl9:
        // 1 sources

        return var1_1;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        arrayList.sort(Map.Entry.comparingByValue());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return linkedHashMap;
    }

    public static <K, V> Map<K, V> reverseMap(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> arrayList = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.reverse(arrayList);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public static void runConsoleCommand(String string, World world) {
        Entity entity = world.spawnEntity(new Location(world, 0.0, 0.0, 0.0), EntityType.MINECART_COMMAND);
        World world2 = (World)Bukkit.getWorlds().get(0);
        boolean bl = (Boolean)world2.getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK);
        world2.setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)false);
        plugin.getServer().dispatchCommand((CommandSender)entity, string);
        world2.setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)bl);
        entity.remove();
    }

    public static void mergeEntityData(Entity entity, String string) {
        Location location = entity.getLocation();
        Utils.runConsoleCommand("data merge entity @e[x=" + location.getX() + ",y=" + location.getY() + ",z=" + location.getZ() + ",distance=..0.1,limit=1] " + string, entity.getWorld());
    }

    public static BlockFace getBlockFace(Player player) {
        List list = player.getLastTwoTargetBlocks(null, 100);
        if (list.size() != 2 || !((Block)list.get(1)).getType().isOccluding()) {
            return null;
        }
        Block block = (Block)list.get(1);
        Block block2 = (Block)list.get(0);
        return block.getFace(block2);
    }

    public static void pureDamageEntity(LivingEntity livingEntity, double d, String string, boolean bl, Entity entity) {
        if (livingEntity.isDead()) {
            return;
        }
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent((Entity)livingEntity, EntityDamageEvent.DamageCause.CUSTOM, d);
        Bukkit.getPluginManager().callEvent((Event)entityDamageEvent);
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        livingEntity.damage(1.0E-5, entity);
        if (livingEntity.getHealth() - entityDamageEvent.getDamage() <= 0.0) {
            if (!bl) {
                livingEntity.setHealth(1.0E-5);
                if (string != null && livingEntity.getEquipment().getItemInMainHand().getType() != Material.TOTEM_OF_UNDYING && livingEntity.getEquipment().getItemInOffHand().getType() != Material.TOTEM_OF_UNDYING) {
                    livingEntity.setMetadata(string, (MetadataValue)Utils.plugin.fixedData);
                }
                livingEntity.damage(1.0);
                return;
            }
            if (string != null) {
                livingEntity.setMetadata(string, (MetadataValue)Utils.plugin.fixedData);
            }
            livingEntity.setHealth(0.0);
            return;
        }
        livingEntity.setHealth(Math.max(livingEntity.getHealth() - entityDamageEvent.getDamage(), 0.0));
    }

    public static void pureDamageEntity(LivingEntity livingEntity, double d, String string, boolean bl, Entity entity, boolean bl2) {
        if (livingEntity.isDead()) {
            return;
        }
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent((Entity)livingEntity, EntityDamageEvent.DamageCause.CUSTOM, d);
        if (bl2) {
            Bukkit.getPluginManager().callEvent((Event)entityDamageEvent);
            if (entityDamageEvent.isCancelled()) {
                return;
            }
        }
        livingEntity.damage(1.0E-5, entity);
        if (livingEntity.getHealth() - entityDamageEvent.getDamage() <= 0.0) {
            if (!bl) {
                livingEntity.setHealth(1.0E-5);
                if (string != null && livingEntity.getEquipment().getItemInMainHand().getType() != Material.TOTEM_OF_UNDYING && livingEntity.getEquipment().getItemInOffHand().getType() != Material.TOTEM_OF_UNDYING) {
                    livingEntity.setMetadata(string, (MetadataValue)Utils.plugin.fixedData);
                }
                livingEntity.damage(1.0);
                return;
            }
            if (string != null) {
                livingEntity.setMetadata(string, (MetadataValue)Utils.plugin.fixedData);
            }
            livingEntity.setHealth(0.0);
            return;
        }
        livingEntity.setHealth(Math.max(livingEntity.getHealth() - entityDamageEvent.getDamage(), 0.0));
    }

    public static void damageArmor(LivingEntity livingEntity, double d) {
        int n = Math.max((int)(d + 1.0), 1);
        ItemStack[] itemStackArray = livingEntity.getEquipment().getArmorContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack itemStack = itemStackArray[n3];
            if (itemStack != null && itemStack.getItemMeta() != null) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (((Damageable)itemMeta).getDamage() >= itemStack.getType().getMaxDurability()) {
                    itemStack.setAmount(0);
                } else {
                    ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + n);
                }
                itemStack.setItemMeta(itemMeta);
            }
            ++n3;
        }
    }

    public static void damageEntity(LivingEntity livingEntity, double d, String string, boolean bl) {
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent((Entity)livingEntity, EntityDamageEvent.DamageCause.CUSTOM, d);
        Bukkit.getPluginManager().callEvent((Event)entityDamageEvent);
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        double d2 = livingEntity.getAttribute(Attribute.GENERIC_ARMOR).getValue();
        double d3 = livingEntity.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS).getValue();
        double d4 = entityDamageEvent.getDamage() * (1.0 - Math.min(20.0, Math.max(d2 / 5.0, d2 - entityDamageEvent.getDamage() / (2.0 + d3 / 4.0))) / 25.0);
        Utils.pureDamageEntity(livingEntity, d4, string, bl, null);
        Utils.damageArmor(livingEntity, d4);
    }

    public static void damageEntity(LivingEntity livingEntity, double d, String string, boolean bl, Entity entity) {
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent((Entity)livingEntity, EntityDamageEvent.DamageCause.CUSTOM, d);
        Bukkit.getPluginManager().callEvent((Event)entityDamageEvent);
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        double d2 = livingEntity.getAttribute(Attribute.GENERIC_ARMOR).getValue();
        double d3 = livingEntity.getAttribute(Attribute.GENERIC_ARMOR_TOUGHNESS).getValue();
        double d4 = entityDamageEvent.getDamage() * (1.0 - Math.min(20.0, Math.max(d2 / 5.0, d2 - entityDamageEvent.getDamage() / (2.0 + d3 / 4.0))) / 25.0);
        Utils.pureDamageEntity(livingEntity, d4, string, bl, entity);
        Utils.damageArmor(livingEntity, d4);
    }

    public static Block rayCastForBlock(Location location, int n, int n2, int n3, Set<Material> set) {
        int n4 = 0;
        while (n4 < n3) {
            Location location2 = location.clone();
            Vector vector = new Vector(rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0).normalize();
            int n5 = 0;
            while (n5 < n2) {
                location2.add(vector);
                Block block = location2.getBlock();
                if (!block.isPassable()) {
                    if (n5 < n || set != null && !set.contains(block.getType())) break;
                    return block;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    public static Block rayCastForBlock(Location location, int n, int n2, int n3, Set<Material> set, Set<Block> set2) {
        int n4 = 0;
        while (n4 < n3) {
            Location location2 = location.clone();
            Vector vector = new Vector(rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0).normalize();
            int n5 = 0;
            while (n5 < n2) {
                location2.add(vector);
                Block block = location2.getBlock();
                if (!block.isPassable()) {
                    if (n5 < n || !set2.contains(block) || set != null && !set.contains(block.getType())) break;
                    return block;
                }
                ++n5;
            }
            ++n4;
        }
        return null;
    }

    public static void sendDebugMessage() {
        Main.consoleSender.sendMessage(Utils.chat("&c[DeadlyDisasters]: An error has occurred above this message. Please report the full error to the discord https://discord.gg/MhXFj72VeN"));
    }

    public static void reloadPlugin(Main main) {
        CoreListener.reload(main);
        Utils.reloadVariables();
        Disaster.reload(main);
        ItemsHandler.reload(main);
        main.enchantHandler.reload();
        CustomEntityType.reload(main);
        Disasters.disasterNames.clear();
        Disaster[] disasterArray = Disaster.values();
        int n = disasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Disaster disaster = disasterArray[n2];
            if (disaster != Disaster.CUSTOM) {
                Disasters.disasterNames.add(disaster.name().toLowerCase());
            }
            ++n2;
        }
        CustomDisaster.loadFiles(main);
        WorldObject.reloadWorlds(main);
        if (main.seasonsHandler.isActive) {
            main.seasonsHandler.reload(main);
        }
        CustomDropsFactory.reload(main);
        GlobalSpawner.reload(main);
    }

    public static void easterEgg() {
        if (Utils.plugin.random.nextInt(999999) != 500) {
            return;
        }
        Logger logger = Bukkit.getLogger();
        logger.log(Level.SEVERE, "Error occurred while enabling UnderscoreEnchants v1.10.0 (Is it up to date?)");
        logger.log(Level.SEVERE, "Exception: InvalidBaseinException at");
        logger.log(Level.SEVERE, "    at top.maths.Calculator:67260 as main class -> Expression#calculateBasein(Result)");
        logger.log(Level.SEVERE, "    at top.maths.Expression:910058 -> Expression#calculateBasein(null)");
        logger.log(Level.SEVERE, "with type: NullPointerExtensible at");
        logger.log(Level.SEVERE, "    at top.maths.Result:611 -> ResultConstructor(@NotNull Calculatable)");
        logger.log(Level.SEVERE, "    at top.maths.Calculatable:2856730 -> null:5");
        logger.log(Level.SEVERE, "caused by: InvalidArgumentException at");
        logger.log(Level.SEVERE, "    at top.maths.Callable (Callable.callForNull -> Callable.java:48727995)");
        logger.log(Level.SEVERE, "    at net.serverside.Callable (Callable.callForMissing -> Callable.java:867160");
        logger.log(Level.SEVERE, "    at net.serverside.Calculator as main class (return Expression.calculateBaseIn(null)");
        logger.log(Level.SEVERE, "----------------------------------");
        logger.log(Level.SEVERE, "THREAD CLOSURE #1");
        logger.log(Level.SEVERE, "for StackOverflowError caused by:");
        logger.log(Level.SEVERE, "    InvalidBaseinException at:");
        logger.log(Level.SEVERE, "    at top.maths.Calculator:67260 as main class -> Expression#calculateBasein(Result)");
        logger.log(Level.SEVERE, "    at top.maths.Expression:910058 -> Expression#calculateBasein(null)");
        logger.log(Level.SEVERE, "with type: NullPointerExtensible at");
        logger.log(Level.SEVERE, "    at top.maths.Result:611 -> ResultConstructor(@NotNull Calculatable)");
        logger.log(Level.SEVERE, "    at top.maths.Calculatable:2856730 -> null:5");
        logger.log(Level.SEVERE, "caused by: InvalidArgumentException at");
        logger.log(Level.SEVERE, "    at top.maths.Callable (Callable.callForNull -> Callable.java:48727995)");
        logger.log(Level.SEVERE, "    at net.serverside.Callable (Callable.callForMissing -> Callable.java:867160");
        logger.log(Level.SEVERE, "    at net.serverside.Calculator as main class (return Expression.calculateBaseIn(null)");
        logger.log(Level.SEVERE, "----------------------------------");
        logger.log(Level.SEVERE, "THREAD CLOSURE #2");
        logger.log(Level.SEVERE, "for StackOverflowError caused by:");
        logger.log(Level.SEVERE, "    InvalidBaseinException at:");
        logger.log(Level.SEVERE, "    at top.maths.Calculator:67260 as main class -> Expression#calculateBasein(Result)");
        logger.log(Level.SEVERE, "    at top.maths.Expression:910058 -> Expression#calculateBasein(null)");
        logger.log(Level.SEVERE, "with type: NullPointerExtensible at");
        logger.log(Level.SEVERE, "    at top.maths.Result:611 -> ResultConstructor(@NotNull Calculatable)");
        logger.log(Level.SEVERE, "    at top.maths.Calculatable:2856730 -> null:5");
        logger.log(Level.SEVERE, "caused by: InvalidArgumentException at");
        logger.log(Level.SEVERE, "    at top.maths.Callable (Callable.callForNull -> Callable.java:48727995)");
        logger.log(Level.SEVERE, "    at net.serverside.Callable (Callable.callForMissing -> Callable.java:867160");
        logger.log(Level.SEVERE, "    at net.serverside.Calculator as main class (return Expression.calculateBaseIn(null)");
        logger.log(Level.SEVERE, "----------------------------------");
        logger.log(Level.SEVERE, "THREAD CLOSURE #3");
        logger.log(Level.SEVERE, "for StackOverflowError caused by:");
        logger.log(Level.SEVERE, "    InvalidBaseinException at:");
        logger.log(Level.SEVERE, "    at top.maths.Calculator:67260 as main class -> Expression#calculateBasein(Result)");
        logger.log(Level.SEVERE, "    at top.maths.Expression:910058 -> Expression#calculateBasein(null)");
        logger.log(Level.SEVERE, "with type: NullPointerExtensible at");
        logger.log(Level.SEVERE, "    at top.maths.Result:611 -> ResultConstructor(@NotNull Calculatable)");
        logger.log(Level.SEVERE, "    at top.maths.Calculatable:2856730 -> null:5");
        logger.log(Level.SEVERE, "caused by: InvalidArgumentException at");
        logger.log(Level.SEVERE, "    at top.maths.Callable (Callable.callForNull -> Callable.java:48727995)");
        logger.log(Level.SEVERE, "    at net.serverside.Callable (Callable.callForMissing -> Callable.java:867160");
        logger.log(Level.SEVERE, "    at net.serverside.Calculator as main class (return Expression.calculateBaseIn(null)");
        logger.log(Level.SEVERE, "----------------------------------");
        logger.log(Level.SEVERE, "THREAD CLOSURE #4");
        logger.log(Level.SEVERE, "for StackOverflowError caused by:");
        logger.log(Level.SEVERE, "    InvalidBaseinException at:");
        logger.log(Level.SEVERE, "    at top.maths.Calculator:67260 as main class -> Expression#calculateBasein(Result)");
        logger.log(Level.SEVERE, "    at top.maths.Expression:910058 -> Expression#calculateBasein(null)");
        logger.log(Level.SEVERE, "with type: NullPointerExtensible at");
        logger.log(Level.SEVERE, "    at top.maths.Result:611 -> ResultConstructor(@NotNull Calculatable)");
        logger.log(Level.SEVERE, "    at top.maths.Calculatable:2856730 -> null:5");
        logger.log(Level.SEVERE, "caused by: InvalidArgumentException at");
        logger.log(Level.SEVERE, "    at top.maths.Callable (Callable.callForNull -> Callable.java:48727995)");
        logger.log(Level.SEVERE, "    at net.serverside.Callable (Callable.callForMissing -> Callable.java:867160");
        logger.log(Level.SEVERE, "    at net.serverside.Calculator as main class (return Expression.calculateBaseIn(null)");
        logger.log(Level.SEVERE, "----------------------------------");
        logger.log(Level.SEVERE, "THREAD CLOSURE MAIN");
        logger.log(Level.SEVERE, "for StackOverflowError caused by:");
        logger.log(Level.SEVERE, "    InvalidBaseinException at:");
        logger.log(Level.SEVERE, "    at top.maths.Calculator:67260 as main class -> Expression#calculateBasein(Result)");
        logger.log(Level.SEVERE, "    at top.maths.Expression:910058 -> Expression#calculateBasein(null)");
        logger.log(Level.SEVERE, "with type: NullPointerExtensible at");
        logger.log(Level.SEVERE, "    at top.maths.Result:611 -> ResultConstructor(@NotNull Calculatable)");
        logger.log(Level.SEVERE, "    at top.maths.Calculatable:2856730 -> null:5");
        logger.log(Level.SEVERE, "caused by: InvalidArgumentException at");
        logger.log(Level.SEVERE, "    at top.maths.Callable (Callable.callForNull -> Callable.java:48727995)");
        logger.log(Level.SEVERE, "    at net.serverside.Callable (Callable.callForMissing -> Callable.java:867160");
        logger.log(Level.SEVERE, "    at net.serverside.Calculator as main class (return Expression.calculateBaseIn(null)");
        logger.log(Level.SEVERE, "----------------------------------");
        logger.log(Level.SEVERE, "Threads closed");
        logger.log(Level.SEVERE, "Application terminated. REPORT THIS TO UnderscoreEnchants discord!");
    }

    public static ItemStack createItem(Material material, int n, String string, List<String> list, boolean bl, boolean bl2) {
        ItemStack itemStack = new ItemStack(material, n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Utils.chat(string));
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : list) {
                String[] stringArray = string2.split("\\n");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray[n3];
                    arrayList.add(string3);
                    ++n3;
                }
            }
            itemMeta.setLore(Utils.chopLore(arrayList));
        }
        if (bl) {
            itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (bl2) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_POTION_EFFECTS});
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack createItem(ItemStack itemStack, int n, String string, List<String> list, boolean bl, boolean bl2) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Utils.chat(string));
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : list) {
                String[] stringArray = string2.split("\\n");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray[n3];
                    arrayList.add(string3);
                    ++n3;
                }
            }
            itemMeta.setLore(Utils.chopLore(arrayList));
        }
        if (bl) {
            itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (bl2) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_POTION_EFFECTS});
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static List<String> chopLore(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            block0: for (String string : list) {
                string = Utils.chat(string);
                int n = 0;
                int n2 = 0;
                while (n2 < string.length()) {
                    if (string.charAt(n2) == '\u00a7') {
                        n += 2;
                    }
                    ++n2;
                }
                n2 = descriptionLine + n;
                if (string.length() - 1 > n2) {
                    int n3 = 0;
                    int n4 = n2;
                    while (n4 > 0) {
                        if (n4 == 0) {
                            arrayList.add(Utils.chat(String.valueOf(org.bukkit.ChatColor.getLastColors((String)string.substring(0, n3))) + string.substring(n3)));
                            continue block0;
                        }
                        if (string.charAt(n4) == ' ') {
                            arrayList.add(Utils.chat(String.valueOf(org.bukkit.ChatColor.getLastColors((String)string.substring(0, n3 + 1))) + string.substring(n3, n4)));
                            n3 += n4 - n3 + 1;
                            if (n4 + n2 >= string.length()) {
                                arrayList.add(Utils.chat(String.valueOf(org.bukkit.ChatColor.getLastColors((String)string.substring(0, n3))) + string.substring(n3, string.length())));
                                continue block0;
                            }
                            n4 = n3 + n2;
                        }
                        --n4;
                    }
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static String getNumerical(int n) {
        switch (n) {
            default: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: 
        }
        return "X";
    }

    /*
     * Exception decompiling
     */
    public static int getFromNumerical(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[12] lbl57 : CaseStatement: default:\u000a, @NONE, blocks:[12] lbl57 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
         *     at java.base/java.util.TimSort.sort(TimSort.java:221)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void damageItem(ItemStack itemStack, int n) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + n);
        if (((Damageable)itemMeta).getDamage() >= itemStack.getType().getMaxDurability()) {
            itemStack.setAmount(0);
        } else {
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static void repairItem(ItemStack itemStack, int n) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ((Damageable)itemMeta).setDamage(Math.max(((Damageable)itemMeta).getDamage() - n, 0));
        itemStack.setItemMeta(itemMeta);
    }

    public static boolean upgradeEnchantLevel(ItemStack itemStack, String string, int n) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        if (itemMeta.hasLore()) {
            List list = itemMeta.getLore();
            int n2 = 0;
            String string2 = null;
            for (String string3 : list) {
                if (string3.contains(string)) {
                    string2 = string3;
                    break;
                }
                ++n2;
            }
            if (string2 == null) {
                list.addAll(Arrays.asList(String.valueOf(string) + " I", " "));
                list.addAll(itemMeta.getLore());
                itemMeta.setLore(list);
                itemStack.setItemMeta(itemMeta);
                return true;
            }
            int n3 = -1;
            int n4 = string2.length() - 1;
            while (n4 >= 0) {
                if (string2.charAt(n4) == ' ') {
                    n3 = Utils.getFromNumerical(string2.substring(n4 + 1));
                    break;
                }
                --n4;
            }
            if (n3 < 0 || n3 >= n) {
                return false;
            }
            list.set(n2, String.valueOf(string) + ' ' + Utils.getNumerical(n3 + 1));
            itemMeta.setLore(list);
            itemStack.setItemMeta(itemMeta);
            return true;
        }
        itemMeta.setLore(Arrays.asList(String.valueOf(string) + " I"));
        itemStack.setItemMeta(itemMeta);
        return true;
    }

    public static boolean upgradeEnchantLevel(ItemStack itemStack, String string, int n, NamespacedKey namespacedKey) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        int n2 = 0;
        if (itemMeta.getPersistentDataContainer().has(namespacedKey, PersistentDataType.BYTE)) {
            n2 = ((Byte)itemMeta.getPersistentDataContainer().get(namespacedKey, PersistentDataType.BYTE)).byteValue();
        }
        if (n2 >= n) {
            return false;
        }
        itemMeta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BYTE, (Object)((byte)(n2 + 1)));
        if (itemMeta.hasLore()) {
            ArrayList<String> arrayList = itemMeta.getLore();
            int n3 = 0;
            String string2 = null;
            for (String string3 : arrayList) {
                if (string3.contains(string)) {
                    string2 = string3;
                    break;
                }
                ++n3;
            }
            if (string2 == null) {
                arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(String.valueOf(string) + " " + Utils.getNumerical(n2 + 1), " "));
                arrayList.addAll(itemMeta.getLore());
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
                return true;
            }
            arrayList.set(n3, String.valueOf(string) + ' ' + Utils.getNumerical(n2 + 1));
            itemMeta.setLore(arrayList);
            itemStack.setItemMeta(itemMeta);
            return true;
        }
        itemMeta.setLore(Arrays.asList(String.valueOf(string) + " " + Utils.getNumerical(n2 + 1)));
        itemStack.setItemMeta(itemMeta);
        return true;
    }

    public static boolean isMaterialGravity(Material material) {
        return gravityBlocks.contains(material);
    }

    public static ArmorStand lockArmorStand(ArmorStand armorStand, boolean bl, boolean bl2, boolean bl3) {
        if (Utils.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(bl);
        } else {
            armorStand.setVisible(!bl);
        }
        armorStand.setGravity(bl2);
        armorStand.setArms(true);
        armorStand.setMarker(bl3);
        if (Utils.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        return armorStand;
    }

    public static final double map(double d, double d2, double d3, double d4, double d5) {
        return d4 + (d5 - d4) * ((d - d2) / (d3 - d2));
    }

    public static boolean isEnvironment(World world, World.Environment environment) {
        return world.getEnvironment() == environment || world.getEnvironment() == World.Environment.CUSTOM;
    }

    public static Vector randomVector() {
        return new Vector(rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0);
    }

    public static <T> String getDecimalFormatted(T t) {
        return decimalFormat.format(t);
    }

    public static boolean isTargetInRange(Mob mob, double d, double d2, boolean bl) {
        if (mob.getTarget() == null || !mob.getTarget().getLocation().getWorld().equals(mob.getWorld()) || bl && !mob.hasLineOfSight((Entity)mob.getTarget())) {
            return false;
        }
        double d3 = mob.getTarget().getLocation().distanceSquared(mob.getLocation());
        return d3 >= d && d3 <= d2;
    }

    public static boolean rayTraceForSolid(Location location, Location location2) {
        Vector vector = Utils.getVectorTowards(location, location2);
        try {
            vector.checkFinite();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        int n = (int)location.distance(location2);
        if (!location.getBlock().isPassable()) {
            return true;
        }
        Location location3 = location.clone();
        int n2 = 1;
        while (n2 < n) {
            if (!location3.add(vector.clone().multiply(n2)).getBlock().isPassable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean rayTraceEntityConeForSolid(Entity entity, Location location) {
        double d = entity.getHeight();
        double d2 = entity.getWidth();
        Location location2 = entity.getLocation().add(0.0, d / 2.0, 0.0);
        if (Utils.rayTraceForSolid(location, location2)) {
            return true;
        }
        if (Utils.rayTraceForSolid(location, location2.add(0.0, d / 2.0, 0.0))) {
            return true;
        }
        if (Utils.rayTraceForSolid(location, location2.clone().subtract(0.0, d / 2.0, 0.0))) {
            return true;
        }
        Vector vector = Utils.getVectorTowards(location, location2);
        try {
            vector.checkFinite();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (Utils.rayTraceForSolid(location, location2.clone().add(new Vector(vector.getZ(), 0.0, -vector.getX()).normalize().multiply(d2 / 2.0)))) {
            return true;
        }
        return Utils.rayTraceForSolid(location, location2.clone().add(new Vector(-vector.getZ(), 0.0, vector.getX()).normalize().multiply(d2 / 2.0)));
    }

    public static boolean isEntityImmunePlayer(Entity entity) {
        return entity instanceof Player && Utils.isPlayerImmune((Player)entity);
    }

    public static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }
}

