/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class ProxyWriter
extends FilterWriter {
    public ProxyWriter(Writer writer) {
        super(writer);
    }

    @Override
    public Writer append(char c) {
        try {
            this.beforeWrite(1);
            this.out.append(c);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        try {
            this.beforeWrite(n2 - n);
            this.out.append(charSequence, n, n2);
            this.afterWrite(n2 - n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        try {
            int n = IOUtils.length(charSequence);
            this.beforeWrite(n);
            this.out.append(charSequence);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return this;
    }

    @Override
    public void write(int n) {
        try {
            this.beforeWrite(1);
            this.out.write(n);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(char[] cArray) {
        try {
            int n = IOUtils.length(cArray);
            this.beforeWrite(n);
            this.out.write(cArray);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            this.beforeWrite(n2);
            this.out.write(cArray, n, n2);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(String string) {
        try {
            int n = IOUtils.length(string);
            this.beforeWrite(n);
            this.out.write(string);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        try {
            this.beforeWrite(n2);
            this.out.write(string, n, n2);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void close() {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    protected void beforeWrite(int n) {
    }

    protected void afterWrite(int n) {
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }
}

