/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.XmlStreamReader;

public class XmlStreamWriter
extends Writer {
    private static final int BUFFER_SIZE = 8192;
    private final OutputStream out;
    private final String defaultEncoding;
    private StringWriter xmlPrologWriter = new StringWriter(8192);
    private Writer writer;
    private String encoding;
    static final Pattern ENCODING_PATTERN = XmlStreamReader.ENCODING_PATTERN;

    public XmlStreamWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public XmlStreamWriter(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.defaultEncoding = string != null ? string : "UTF-8";
    }

    public XmlStreamWriter(File file) {
        this(file, null);
    }

    public XmlStreamWriter(File file, String string) {
        this(new FileOutputStream(file), string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public void close() {
        if (this.writer == null) {
            this.encoding = this.defaultEncoding;
            this.writer = new OutputStreamWriter(this.out, this.encoding);
            this.writer.write(this.xmlPrologWriter.toString());
        }
        this.writer.close();
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    private void detectEncoding(char[] cArray, int n, int n2) {
        int n3 = n2;
        StringBuffer stringBuffer = this.xmlPrologWriter.getBuffer();
        if (stringBuffer.length() + n2 > 8192) {
            n3 = 8192 - stringBuffer.length();
        }
        this.xmlPrologWriter.write(cArray, n, n3);
        if (stringBuffer.length() >= 5) {
            if (stringBuffer.substring(0, 5).equals("<?xml")) {
                int n4 = stringBuffer.indexOf("?>");
                if (n4 > 0) {
                    Matcher matcher = ENCODING_PATTERN.matcher(stringBuffer.substring(0, n4));
                    if (matcher.find()) {
                        this.encoding = matcher.group(1).toUpperCase(Locale.ROOT);
                        this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
                    } else {
                        this.encoding = this.defaultEncoding;
                    }
                } else if (stringBuffer.length() >= 8192) {
                    this.encoding = this.defaultEncoding;
                }
            } else {
                this.encoding = this.defaultEncoding;
            }
            if (this.encoding != null) {
                this.xmlPrologWriter = null;
                this.writer = new OutputStreamWriter(this.out, this.encoding);
                this.writer.write(stringBuffer.toString());
                if (n2 > n3) {
                    this.writer.write(cArray, n + n3, n2 - n3);
                }
            }
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        if (this.xmlPrologWriter != null) {
            this.detectEncoding(cArray, n, n2);
        } else {
            this.writer.write(cArray, n, n2);
        }
    }
}

