/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.api.framework.blockutil.impl;

import com.google.gson.JsonObject;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPosition
implements me.angeschossen.upgradeablehoppers.api.framework.blockutil.BlockPosition {
    public final World world;
    public final int x;
    public final int y;
    public final int z;

    public BlockPosition(World world, int n, int n2, int n3) {
        this.world = world;
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    @NotNull
    public final Block getBlock() {
        return this.world.getBlockAt(this.x, this.y, this.z);
    }

    public BlockPosition(Location location) {
        this(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Nullable
    public static BlockPosition fromJson(JsonObject jsonObject) {
        World world = Bukkit.getWorld((String)jsonObject.get("world").getAsString());
        if (world == null) {
            return null;
        }
        return new BlockPosition(world, jsonObject.get("x").getAsInt(), jsonObject.get("y").getAsInt(), jsonObject.get("z").getAsInt());
    }

    public final boolean equals(World world, int n, int n2, int n3) {
        return this.world.equals(world) && this.x == n && this.y == n2 && this.z == n3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlockPosition)) {
            return false;
        }
        BlockPosition blockPosition = (BlockPosition)object;
        return blockPosition.world.equals(this.world) && blockPosition.x == this.x && blockPosition.z == this.z && blockPosition.y == this.y;
    }

    public final boolean equals(int n, int n2, int n3) {
        return this.x == n && this.z == n3 && this.y == n2;
    }

    @Override
    public final int getChunkX() {
        return this.x >> 4;
    }

    @Override
    public final int getChunkZ() {
        return this.z >> 4;
    }

    @Override
    @NotNull
    public Location toLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final int getZ() {
        return this.z;
    }

    public int hashCode() {
        int n = 17;
        n = n * 31 + this.x;
        n = n * 31 + this.y;
        n = n * 31 + this.z;
        return n;
    }

    @Override
    public final boolean isChunkLoaded() {
        return this.world.isChunkLoaded(this.x >> 4, this.z >> 4);
    }

    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("world", this.world.getName());
        jsonObject.addProperty("x", (Number)this.x);
        jsonObject.addProperty("y", (Number)this.y);
        jsonObject.addProperty("z", (Number)this.z);
        return jsonObject;
    }

    public String toString() {
        return "BlockPosition{world=" + this.world + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + '}';
    }
}

